/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Point;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.view.MotionEventCompat;

public class DragStartHelper {
    private final View mView;
    private final OnDragStartListener mListener;
    private int mLastTouchX;
    private int mLastTouchY;
    private boolean mDragging;
    private final View.OnLongClickListener mLongClickListener = this::onLongClick;
    private final View.OnTouchListener mTouchListener = this::onTouch;

    public DragStartHelper(@NonNull View view, @NonNull OnDragStartListener listener) {
        this.mView = view;
        this.mListener = listener;
    }

    public void attach() {
        this.mView.setOnLongClickListener(this.mLongClickListener);
        this.mView.setOnTouchListener(this.mTouchListener);
    }

    public void detach() {
        this.mView.setOnLongClickListener(null);
        this.mView.setOnTouchListener(null);
    }

    public boolean onTouch(@NonNull View v, @NonNull MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                break;
            }
            case 2: {
                if (!MotionEventCompat.isFromSource(event, 8194) || (event.getButtonState() & 1) == 0 || this.mDragging || this.mLastTouchX == x && this.mLastTouchY == y) break;
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.mDragging = this.mListener.onDragStart(v, this);
                return this.mDragging;
            }
            case 1: 
            case 3: {
                this.mDragging = false;
            }
        }
        return false;
    }

    public boolean onLongClick(@NonNull View v) {
        return this.mListener.onDragStart(v, this);
    }

    public void getTouchPosition(@NonNull Point point) {
        point.set(this.mLastTouchX, this.mLastTouchY);
    }

    public static interface OnDragStartListener {
        public boolean onDragStart(@NonNull View var1, @NonNull DragStartHelper var2);
    }
}

