/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.core.os.BuildCompat;
import java.util.ArrayList;

public final class BundleCompat {
    private BundleCompat() {
    }

    @Nullable
    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static <T> T getParcelable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
        if (BuildCompat.isAtLeastU()) {
            return Api33Impl.getParcelable(in, key, clazz);
        }
        Parcelable parcelable = in.getParcelable(key);
        return (T)(clazz.isInstance(parcelable) ? parcelable : null);
    }

    @Nullable
    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public static Parcelable[] getParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends Parcelable> clazz) {
        if (BuildCompat.isAtLeastU()) {
            return Api33Impl.getParcelableArray(in, key, clazz);
        }
        return in.getParcelableArray(key);
    }

    @Nullable
    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public static <T> ArrayList<T> getParcelableArrayList(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
        if (BuildCompat.isAtLeastU()) {
            return Api33Impl.getParcelableArrayList(in, key, clazz);
        }
        return in.getParcelableArrayList(key);
    }

    @Nullable
    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static <T> SparseArray<T> getSparseParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
        if (BuildCompat.isAtLeastU()) {
            return Api33Impl.getSparseParcelableArray(in, key, clazz);
        }
        return in.getSparseParcelableArray(key);
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static <T> T getParcelable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return (T)in.getParcelable(key, clazz);
        }

        @DoNotInline
        static <T> T[] getParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return in.getParcelableArray(key, clazz);
        }

        @DoNotInline
        static <T> ArrayList<T> getParcelableArrayList(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
            return in.getParcelableArrayList(key, clazz);
        }

        @DoNotInline
        static <T> SparseArray<T> getSparseParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
            return in.getSparseParcelableArray(key, clazz);
        }
    }
}

