/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.annotation.SuppressLint;
import android.graphics.Typeface;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.LongSparseArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@SuppressLint(value={"SoonBlockedPrivateApi"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=26)
final class WeightTypefaceApi26 {
    private static final String TAG = "WeightTypeface";
    private static final String NATIVE_INSTANCE_FIELD = "native_instance";
    private static final String NATIVE_CREATE_FROM_TYPEFACE_WITH_EXACT_STYLE_METHOD = "nativeCreateFromTypefaceWithExactStyle";
    private static final Field sNativeInstance;
    private static final Method sNativeCreateFromTypefaceWithExactStyle;
    private static final Constructor<Typeface> sConstructor;
    @GuardedBy(value="sWeightCacheLock")
    private static final LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static final Object sWeightCacheLock;

    private static boolean isPrivateApiAvailable() {
        return sNativeInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static Typeface createWeightStyle(@NonNull Typeface base, int weight, boolean italic) {
        Typeface typeface;
        if (!WeightTypefaceApi26.isPrivateApiAvailable()) {
            return null;
        }
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            long baseNativeInstance = WeightTypefaceApi26.getNativeInstance(base);
            SparseArray innerCache = (SparseArray)sWeightTypefaceCache.get(baseNativeInstance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(baseNativeInstance, (Object)innerCache);
            } else {
                typeface = (Typeface)innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = WeightTypefaceApi26.create(WeightTypefaceApi26.nativeCreateFromTypefaceWithExactStyle(baseNativeInstance, weight, italic));
            innerCache.put(key, (Object)typeface);
        }
        return typeface;
    }

    private static long getNativeInstance(@NonNull Typeface typeface) {
        try {
            return sNativeInstance.getLong(typeface);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private static long nativeCreateFromTypefaceWithExactStyle(long nativeInstance, int weight, boolean italic) {
        try {
            return (Long)sNativeCreateFromTypefaceWithExactStyle.invoke(null, nativeInstance, weight, italic);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Typeface create(long nativeInstance) {
        try {
            return sConstructor.newInstance(nativeInstance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private WeightTypefaceApi26() {
    }

    static {
        Constructor constructor;
        Method nativeCreateFromTypefaceWithExactStyle;
        Field nativeInstance;
        try {
            nativeInstance = Typeface.class.getDeclaredField(NATIVE_INSTANCE_FIELD);
            nativeCreateFromTypefaceWithExactStyle = Typeface.class.getDeclaredMethod(NATIVE_CREATE_FROM_TYPEFACE_WITH_EXACT_STYLE_METHOD, Long.TYPE, Integer.TYPE, Boolean.TYPE);
            nativeCreateFromTypefaceWithExactStyle.setAccessible(true);
            constructor = Typeface.class.getDeclaredConstructor(Long.TYPE);
            constructor.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            Log.e((String)TAG, (String)e.getClass().getName(), (Throwable)e);
            nativeInstance = null;
            nativeCreateFromTypefaceWithExactStyle = null;
            constructor = null;
        }
        sNativeInstance = nativeInstance;
        sNativeCreateFromTypefaceWithExactStyle = nativeCreateFromTypefaceWithExactStyle;
        sConstructor = constructor;
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
    }
}

