/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class PendingIntentCompat {
    @NonNull
    public static PendingIntent getActivities(@NonNull Context context, int requestCode, @NonNull @SuppressLint(value={"ArrayReturn"}) Intent[] intents, int flags, @NonNull Bundle options, boolean isMutable) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.getActivities(context, requestCode, intents, PendingIntentCompat.addMutabilityFlags(isMutable, flags), options);
        }
        return PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)flags);
    }

    @NonNull
    public static PendingIntent getActivities(@NonNull Context context, int requestCode, @NonNull @SuppressLint(value={"ArrayReturn"}) Intent[] intents, int flags, boolean isMutable) {
        return PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @NonNull
    public static PendingIntent getActivity(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @NonNull
    public static PendingIntent getActivity(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, @NonNull Bundle options, boolean isMutable) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.getActivity(context, requestCode, intent, PendingIntentCompat.addMutabilityFlags(isMutable, flags), options);
        }
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)flags);
    }

    @NonNull
    public static PendingIntent getBroadcast(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @RequiresApi(value=26)
    @NonNull
    public static PendingIntent getForegroundService(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return Api26Impl.getForegroundService(context, requestCode, intent, PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    @NonNull
    public static PendingIntent getService(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, boolean isMutable) {
        return PendingIntent.getService((Context)context, (int)requestCode, (Intent)intent, (int)PendingIntentCompat.addMutabilityFlags(isMutable, flags));
    }

    private static int addMutabilityFlags(boolean isMutable, int flags) {
        if (isMutable) {
            if (Build.VERSION.SDK_INT >= 31) {
                flags |= 0x2000000;
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        return flags;
    }

    private PendingIntentCompat() {
    }

    @RequiresApi(value=16)
    private static class Api16Impl {
        private Api16Impl() {
        }

        @DoNotInline
        @NonNull
        public static PendingIntent getActivities(@NonNull Context context, int requestCode, @NonNull @SuppressLint(value={"ArrayReturn"}) Intent[] intents, int flags, @NonNull Bundle options) {
            return PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)flags, (Bundle)options);
        }

        @DoNotInline
        @NonNull
        public static PendingIntent getActivity(@NonNull Context context, int requestCode, @NonNull Intent intent, int flags, @NonNull Bundle options) {
            return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)flags, (Bundle)options);
        }
    }

    @RequiresApi(value=26)
    private static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        public static PendingIntent getForegroundService(Context context, int requestCode, Intent intent, int flags) {
            return PendingIntent.getForegroundService((Context)context, (int)requestCode, (Intent)intent, (int)flags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

