/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeyManagerRegistry;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrivateKeyTypeManager;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.shaded.protobuf.MessageLite;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Registry {
    private static final Logger logger = Logger.getLogger(Registry.class.getName());
    private static final AtomicReference<KeyManagerRegistry> keyManagerRegistry = new AtomicReference<KeyManagerRegistry>(new KeyManagerRegistry());
    private static final ConcurrentMap<String, KeyDataDeriver> keyDeriverMap = new ConcurrentHashMap<String, KeyDataDeriver>();
    private static final ConcurrentMap<String, Boolean> newKeyAllowedMap = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, Catalogue<?>> catalogueMap = new ConcurrentHashMap();
    private static final ConcurrentMap<String, com.google.crypto.tink.KeyTemplate> keyTemplateMap = new ConcurrentHashMap<String, com.google.crypto.tink.KeyTemplate>();

    private static <KeyProtoT extends MessageLite> KeyDataDeriver createDeriverFor(final KeyTypeManager<KeyProtoT> keyManager) {
        return new KeyDataDeriver(){

            private <KeyFormatProtoT extends MessageLite> MessageLite deriveKeyWithFactory(ByteString serializedKeyFormat, InputStream stream, KeyTypeManager.KeyFactory<KeyFormatProtoT, KeyProtoT> keyFactory) throws GeneralSecurityException {
                KeyFormatProtoT keyFormat;
                try {
                    keyFormat = keyFactory.parseKeyFormat(serializedKeyFormat);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new GeneralSecurityException("parsing key format failed in deriveKey", e);
                }
                keyFactory.validateKeyFormat(keyFormat);
                return keyFactory.deriveKey(keyFormat, stream);
            }

            @Override
            public KeyData deriveKeyData(ByteString serializedKeyFormat, InputStream stream) throws GeneralSecurityException {
                KeyTypeManager.KeyFactory keyFactory = keyManager.keyFactory();
                MessageLite keyValue = this.deriveKeyWithFactory(serializedKeyFormat, stream, keyFactory);
                return (KeyData)KeyData.newBuilder().setTypeUrl(keyManager.getKeyType()).setValue(keyValue.toByteString()).setKeyMaterialType(keyManager.keyMaterialType()).build();
            }
        };
    }

    static synchronized void reset() {
        keyManagerRegistry.set(new KeyManagerRegistry());
        MutablePrimitiveRegistry.resetGlobalInstanceTestOnly();
        keyDeriverMap.clear();
        newKeyAllowedMap.clear();
        catalogueMap.clear();
        keyTemplateMap.clear();
    }

    @Deprecated
    public static synchronized void addCatalogue(String catalogueName, Catalogue<?> catalogue) throws GeneralSecurityException {
        if (catalogueName == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        if (catalogue == null) {
            throw new IllegalArgumentException("catalogue must be non-null.");
        }
        if (catalogueMap.containsKey(catalogueName.toLowerCase(Locale.US))) {
            Catalogue existing = (Catalogue)catalogueMap.get(catalogueName.toLowerCase(Locale.US));
            if (!catalogue.getClass().getName().equals(existing.getClass().getName())) {
                logger.warning("Attempted overwrite of a catalogueName catalogue for name " + catalogueName);
                throw new GeneralSecurityException("catalogue for name " + catalogueName + " has been already registered");
            }
        }
        catalogueMap.put(catalogueName.toLowerCase(Locale.US), catalogue);
    }

    @Deprecated
    public static Catalogue<?> getCatalogue(String catalogueName) throws GeneralSecurityException {
        if (catalogueName == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        Catalogue catalogue = (Catalogue)catalogueMap.get(catalogueName.toLowerCase(Locale.US));
        if (catalogue == null) {
            String error = String.format("no catalogue found for %s. ", catalogueName);
            if (catalogueName.toLowerCase(Locale.US).startsWith("tinkaead")) {
                error = error + "Maybe call AeadConfig.register().";
            }
            if (catalogueName.toLowerCase(Locale.US).startsWith("tinkdeterministicaead")) {
                error = error + "Maybe call DeterministicAeadConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkstreamingaead")) {
                error = error + "Maybe call StreamingAeadConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkhybriddecrypt") || catalogueName.toLowerCase(Locale.US).startsWith("tinkhybridencrypt")) {
                error = error + "Maybe call HybridConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkmac")) {
                error = error + "Maybe call MacConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkpublickeysign") || catalogueName.toLowerCase(Locale.US).startsWith("tinkpublickeyverify")) {
                error = error + "Maybe call SignatureConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tink")) {
                error = error + "Maybe call TinkConfig.register().";
            }
            throw new GeneralSecurityException(error);
        }
        return catalogue;
    }

    public static synchronized <P> void registerKeyManager(KeyManager<P> manager) throws GeneralSecurityException {
        Registry.registerKeyManager(manager, true);
    }

    public static synchronized <P> void registerKeyManager(KeyManager<P> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        KeyManagerRegistry newKeyManagerRegistry = new KeyManagerRegistry(keyManagerRegistry.get());
        newKeyManagerRegistry.registerKeyManager(manager);
        if (!TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS.isCompatible()) {
            throw new GeneralSecurityException("Registering key managers is not supported in FIPS mode");
        }
        String typeUrl = manager.getKeyType();
        Registry.ensureKeyManagerInsertable(typeUrl, Collections.emptyMap(), newKeyAllowed);
        newKeyAllowedMap.put(typeUrl, newKeyAllowed);
        keyManagerRegistry.set(newKeyManagerRegistry);
    }

    public static synchronized <KeyProtoT extends MessageLite> void registerKeyManager(KeyTypeManager<KeyProtoT> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        KeyManagerRegistry newKeyManagerRegistry = new KeyManagerRegistry(keyManagerRegistry.get());
        newKeyManagerRegistry.registerKeyManager(manager);
        String typeUrl = manager.getKeyType();
        Registry.ensureKeyManagerInsertable(typeUrl, newKeyAllowed ? manager.keyFactory().keyFormats() : Collections.emptyMap(), newKeyAllowed);
        if (!keyManagerRegistry.get().typeUrlExists(typeUrl)) {
            keyDeriverMap.put(typeUrl, Registry.createDeriverFor(manager));
            if (newKeyAllowed) {
                Registry.registerKeyTemplates(typeUrl, manager.keyFactory().keyFormats());
            }
        }
        newKeyAllowedMap.put(typeUrl, newKeyAllowed);
        keyManagerRegistry.set(newKeyManagerRegistry);
    }

    @Deprecated
    public static synchronized <P> void registerKeyManager(String typeUrl, KeyManager<P> manager) throws GeneralSecurityException {
        Registry.registerKeyManager(typeUrl, manager, true);
    }

    @Deprecated
    public static synchronized <P> void registerKeyManager(String typeUrl, KeyManager<P> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        if (!typeUrl.equals(manager.getKeyType())) {
            throw new GeneralSecurityException("Manager does not support key type " + typeUrl + ".");
        }
        Registry.registerKeyManager(manager, newKeyAllowed);
    }

    private static synchronized <KeyFormatProtoT extends MessageLite> void ensureKeyManagerInsertable(String typeUrl, Map<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> keyFormats, boolean newKeyAllowed) throws GeneralSecurityException {
        block5: {
            if (newKeyAllowed && newKeyAllowedMap.containsKey(typeUrl) && !((Boolean)newKeyAllowedMap.get(typeUrl)).booleanValue()) {
                throw new GeneralSecurityException("New keys are already disallowed for key type " + typeUrl);
            }
            if (!newKeyAllowed) break block5;
            if (keyManagerRegistry.get().typeUrlExists(typeUrl)) {
                for (Map.Entry<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> entry : keyFormats.entrySet()) {
                    if (keyTemplateMap.containsKey(entry.getKey())) continue;
                    throw new GeneralSecurityException("Attempted to register a new key template " + entry.getKey() + " from an existing key manager of type " + typeUrl);
                }
            } else {
                for (Map.Entry<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> entry : keyFormats.entrySet()) {
                    if (!keyTemplateMap.containsKey(entry.getKey())) continue;
                    throw new GeneralSecurityException("Attempted overwrite of a registered key template " + entry.getKey());
                }
            }
        }
    }

    public static synchronized <KeyProtoT extends MessageLite, PublicKeyProtoT extends MessageLite> void registerAsymmetricKeyManagers(PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> privateKeyTypeManager, KeyTypeManager<PublicKeyProtoT> publicKeyTypeManager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (privateKeyTypeManager == null || publicKeyTypeManager == null) {
            throw new IllegalArgumentException("given key managers must be non-null.");
        }
        KeyManagerRegistry newKeyManagerRegistry = new KeyManagerRegistry(keyManagerRegistry.get());
        newKeyManagerRegistry.registerAsymmetricKeyManagers(privateKeyTypeManager, publicKeyTypeManager);
        String privateTypeUrl = privateKeyTypeManager.getKeyType();
        String publicTypeUrl = publicKeyTypeManager.getKeyType();
        Registry.ensureKeyManagerInsertable(privateTypeUrl, newKeyAllowed ? privateKeyTypeManager.keyFactory().keyFormats() : Collections.emptyMap(), newKeyAllowed);
        Registry.ensureKeyManagerInsertable(publicTypeUrl, Collections.emptyMap(), false);
        if (!keyManagerRegistry.get().typeUrlExists(privateTypeUrl)) {
            keyDeriverMap.put(privateTypeUrl, Registry.createDeriverFor(privateKeyTypeManager));
            if (newKeyAllowed) {
                Registry.registerKeyTemplates(privateKeyTypeManager.getKeyType(), privateKeyTypeManager.keyFactory().keyFormats());
            }
        }
        newKeyAllowedMap.put(privateTypeUrl, newKeyAllowed);
        newKeyAllowedMap.put(publicTypeUrl, false);
        keyManagerRegistry.set(newKeyManagerRegistry);
    }

    private static <KeyFormatProtoT extends MessageLite> void registerKeyTemplates(String typeUrl, Map<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> keyFormats) {
        for (Map.Entry<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> entry : keyFormats.entrySet()) {
            keyTemplateMap.put(entry.getKey(), com.google.crypto.tink.KeyTemplate.create(typeUrl, ((MessageLite)entry.getValue().keyFormat).toByteArray(), entry.getValue().outputPrefixType));
        }
    }

    public static synchronized <B, P> void registerPrimitiveWrapper(PrimitiveWrapper<B, P> wrapper) throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(wrapper);
    }

    @Deprecated
    public static <P> KeyManager<P> getKeyManager(String typeUrl) throws GeneralSecurityException {
        KeyManager<?> result = Registry.getUntypedKeyManager(typeUrl);
        return result;
    }

    public static <P> KeyManager<P> getKeyManager(String typeUrl, Class<P> primitiveClass) throws GeneralSecurityException {
        return keyManagerRegistry.get().getKeyManager(typeUrl, primitiveClass);
    }

    public static KeyManager<?> getUntypedKeyManager(String typeUrl) throws GeneralSecurityException {
        return keyManagerRegistry.get().getUntypedKeyManager(typeUrl);
    }

    public static synchronized KeyData newKeyData(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyManager<?> manager = Registry.getUntypedKeyManager(keyTemplate.getTypeUrl());
        if (((Boolean)newKeyAllowedMap.get(keyTemplate.getTypeUrl())).booleanValue()) {
            return manager.newKeyData(keyTemplate.getValue());
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + keyTemplate.getTypeUrl());
    }

    public static synchronized KeyData newKeyData(com.google.crypto.tink.KeyTemplate keyTemplate) throws GeneralSecurityException {
        return Registry.newKeyData(keyTemplate.getProto());
    }

    @Deprecated
    public static synchronized MessageLite newKey(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyManager<?> manager = Registry.getUntypedKeyManager(keyTemplate.getTypeUrl());
        if (((Boolean)newKeyAllowedMap.get(keyTemplate.getTypeUrl())).booleanValue()) {
            return manager.newKey(keyTemplate.getValue());
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + keyTemplate.getTypeUrl());
    }

    @Deprecated
    public static synchronized MessageLite newKey(String typeUrl, MessageLite format) throws GeneralSecurityException {
        KeyManager manager = Registry.getKeyManager(typeUrl);
        if (((Boolean)newKeyAllowedMap.get(typeUrl)).booleanValue()) {
            return manager.newKey(format);
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + typeUrl);
    }

    static synchronized KeyData deriveKey(KeyTemplate keyTemplate, InputStream randomStream) throws GeneralSecurityException {
        String typeUrl = keyTemplate.getTypeUrl();
        if (!keyDeriverMap.containsKey(typeUrl)) {
            throw new GeneralSecurityException("No keymanager registered or key manager cannot derive keys for " + typeUrl);
        }
        KeyDataDeriver deriver = (KeyDataDeriver)keyDeriverMap.get(typeUrl);
        return deriver.deriveKeyData(keyTemplate.getValue(), randomStream);
    }

    public static KeyData getPublicKeyData(String typeUrl, ByteString serializedPrivateKey) throws GeneralSecurityException {
        KeyManager manager = Registry.getKeyManager(typeUrl);
        if (!(manager instanceof PrivateKeyManager)) {
            throw new GeneralSecurityException("manager for key type " + typeUrl + " is not a PrivateKeyManager");
        }
        return ((PrivateKeyManager)manager).getPublicKeyData(serializedPrivateKey);
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, MessageLite key) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(typeUrl);
        return manager.getPrimitive(key.toByteString());
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, MessageLite key, Class<P> primitiveClass) throws GeneralSecurityException {
        KeyManager<P> manager = keyManagerRegistry.get().getKeyManager(typeUrl, primitiveClass);
        return manager.getPrimitive(key.toByteString());
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, ByteString serializedKey) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManager(typeUrl);
        return manager.getPrimitive(serializedKey);
    }

    public static <P> P getPrimitive(String typeUrl, ByteString serializedKey, Class<P> primitiveClass) throws GeneralSecurityException {
        KeyManager<P> manager = keyManagerRegistry.get().getKeyManager(typeUrl, primitiveClass);
        return manager.getPrimitive(serializedKey);
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, byte[] serializedKey) throws GeneralSecurityException {
        return Registry.getPrimitive(typeUrl, ByteString.copyFrom(serializedKey));
    }

    public static <P> P getPrimitive(String typeUrl, byte[] serializedKey, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getPrimitive(typeUrl, ByteString.copyFrom(serializedKey), primitiveClass);
    }

    @Deprecated
    public static <P> P getPrimitive(KeyData keyData) throws GeneralSecurityException {
        return Registry.getPrimitive(keyData.getTypeUrl(), keyData.getValue());
    }

    public static <P> P getPrimitive(KeyData keyData, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getPrimitive(keyData.getTypeUrl(), keyData.getValue(), primitiveClass);
    }

    static <KeyT extends Key, P> P getFullPrimitive(KeyT key, Class<P> primitiveClass) throws GeneralSecurityException {
        return MutablePrimitiveRegistry.globalInstance().getPrimitive(key, primitiveClass);
    }

    public static <B, P> P wrap(PrimitiveSet<B> primitiveSet, Class<P> clazz) throws GeneralSecurityException {
        return MutablePrimitiveRegistry.globalInstance().wrap(primitiveSet, clazz);
    }

    public static <P> P wrap(PrimitiveSet<P> primitiveSet) throws GeneralSecurityException {
        return Registry.wrap(primitiveSet, primitiveSet.getPrimitiveClass());
    }

    public static synchronized List<String> keyTemplates() {
        ArrayList results = new ArrayList();
        results.addAll(keyTemplateMap.keySet());
        return Collections.unmodifiableList(results);
    }

    static synchronized Map<String, com.google.crypto.tink.KeyTemplate> keyTemplateMap() {
        return Collections.unmodifiableMap(keyTemplateMap);
    }

    @Nullable
    public static Class<?> getInputPrimitive(Class<?> wrappedPrimitive) {
        try {
            return MutablePrimitiveRegistry.globalInstance().getInputPrimitiveClass(wrappedPrimitive);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    public static synchronized void restrictToFipsIfEmpty() throws GeneralSecurityException {
        if (TinkFipsUtil.useOnlyFips()) {
            return;
        }
        if (keyManagerRegistry.get().isEmpty()) {
            TinkFipsUtil.setFipsRestricted();
            return;
        }
        throw new GeneralSecurityException("Could not enable FIPS mode as Registry is not empty.");
    }

    private Registry() {
    }

    private static interface KeyDataDeriver {
        public KeyData deriveKeyData(ByteString var1, InputStream var2) throws GeneralSecurityException;
    }
}

