/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.TinkProtoParametersFormat;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.security.GeneralSecurityException;

@Immutable
public final class KeyTemplate {
    private final com.google.crypto.tink.proto.KeyTemplate kt;

    static OutputPrefixType fromProto(com.google.crypto.tink.proto.OutputPrefixType outputPrefixType) {
        switch (outputPrefixType) {
            case TINK: {
                return OutputPrefixType.TINK;
            }
            case LEGACY: {
                return OutputPrefixType.LEGACY;
            }
            case RAW: {
                return OutputPrefixType.RAW;
            }
            case CRUNCHY: {
                return OutputPrefixType.CRUNCHY;
            }
        }
        throw new IllegalArgumentException("Unknown output prefix type");
    }

    static com.google.crypto.tink.proto.OutputPrefixType toProto(OutputPrefixType outputPrefixType) {
        switch (outputPrefixType) {
            case TINK: {
                return com.google.crypto.tink.proto.OutputPrefixType.TINK;
            }
            case LEGACY: {
                return com.google.crypto.tink.proto.OutputPrefixType.LEGACY;
            }
            case RAW: {
                return com.google.crypto.tink.proto.OutputPrefixType.RAW;
            }
            case CRUNCHY: {
                return com.google.crypto.tink.proto.OutputPrefixType.CRUNCHY;
            }
        }
        throw new IllegalArgumentException("Unknown output prefix type");
    }

    public static KeyTemplate create(String typeUrl, byte[] value, OutputPrefixType outputPrefixType) {
        return new KeyTemplate((com.google.crypto.tink.proto.KeyTemplate)com.google.crypto.tink.proto.KeyTemplate.newBuilder().setTypeUrl(typeUrl).setValue(ByteString.copyFrom(value)).setOutputPrefixType(KeyTemplate.toProto(outputPrefixType)).build());
    }

    public static KeyTemplate createFrom(Parameters p) throws GeneralSecurityException {
        try {
            byte[] serializedParameters = TinkProtoParametersFormat.serialize(p);
            return new KeyTemplate(com.google.crypto.tink.proto.KeyTemplate.parseFrom(serializedParameters, ExtensionRegistryLite.getEmptyRegistry()));
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Parsing parameters failed", e);
        }
    }

    private KeyTemplate(com.google.crypto.tink.proto.KeyTemplate kt) {
        this.kt = kt;
    }

    com.google.crypto.tink.proto.KeyTemplate getProto() {
        return this.kt;
    }

    @Deprecated
    public String getTypeUrl() {
        return this.kt.getTypeUrl();
    }

    @Deprecated
    public byte[] getValue() {
        return this.kt.getValue().toByteArray();
    }

    public OutputPrefixType getOutputPrefixType() {
        return KeyTemplate.fromProto(this.kt.getOutputPrefixType());
    }

    public Parameters toParameters() throws GeneralSecurityException {
        return TinkProtoParametersFormat.parse(this.kt.toByteArray());
    }

    public static enum OutputPrefixType {
        TINK,
        LEGACY,
        RAW,
        CRUNCHY;

    }
}

