/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.microsoft.maui.ImageLoaderCallback;

public class MauiCustomTarget
extends CustomTarget<Drawable> {
    private final Context context;
    private final ImageLoaderCallback callback;
    private boolean completed = false;

    public MauiCustomTarget(Context context, ImageLoaderCallback callback) {
        this.context = context;
        this.callback = callback;
    }

    public void onLoadFailed(@Nullable Drawable errorDrawable) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.post(() -> this.callback.onComplete(false, errorDrawable, null));
    }

    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.post(() -> this.callback.onComplete(true, resource, this::clear));
    }

    public void onLoadCleared(@Nullable Drawable placeholder) {
    }

    private void post(Runnable runnable) {
        Looper looper = Looper.getMainLooper();
        Handler handler = new Handler(looper);
        handler.post(runnable);
    }

    private void clear() {
        this.post(() -> Glide.with((Context)this.context).clear((Target)this));
    }
}

