/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.net.Uri;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.R;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.TintTypedArray;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;
import androidx.window.layout.WindowMetricsCalculator;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.MaterialToolbar;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.microsoft.maui.ImageLoaderCallback;
import com.microsoft.maui.R;
import com.microsoft.maui.glide.MauiCustomTarget;
import com.microsoft.maui.glide.MauiCustomViewTarget;
import com.microsoft.maui.glide.font.FontModel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class PlatformInterop {
    public static void requestLayoutIfNeeded(View view) {
        if (!view.isInLayout()) {
            view.requestLayout();
            return;
        }
        Runnable runnable = () -> {
            if (!view.isInLayout()) {
                view.requestLayout();
            }
        };
        view.post(runnable);
    }

    public static void removeFromParent(View view) {
        ViewParent parent = view.getParent();
        if (parent == null) {
            return;
        }
        ((ViewGroup)parent).removeView(view);
    }

    public static void setPivotXIfNeeded(View view, float pivotX) {
        if (view.getPivotX() != pivotX) {
            view.setPivotX(pivotX);
        }
    }

    public static void setPivotYIfNeeded(View view, float pivotY) {
        if (view.getPivotY() != pivotY) {
            view.setPivotY(pivotY);
        }
    }

    public static void setContentDescriptionForAutomationId(View view, String description) {
        view = PlatformInterop.getSemanticPlatformElement(view);
        int importantForAccessibility = view.getImportantForAccessibility();
        view.setContentDescription((CharSequence)description);
        if (importantForAccessibility == 0) {
            view.setImportantForAccessibility(0);
        }
    }

    public static View getSemanticPlatformElement(View view) {
        if (view instanceof SearchView) {
            view = view.findViewById(R.id.search_src_text);
        }
        return view;
    }

    public static void set(View view, int visibility, int layoutDirection, int minimumHeight, int minimumWidth, boolean enabled, float alpha, float translationX, float translationY, float scaleX, float scaleY, float rotation, float rotationX, float rotationY, float pivotX, float pivotY) {
        PlatformInterop.requestLayoutIfNeeded(view);
        view.setVisibility(visibility);
        view.setLayoutDirection(layoutDirection);
        view.setMinimumHeight(minimumHeight);
        view.setMinimumWidth(minimumWidth);
        view.setEnabled(enabled);
        view.setAlpha(alpha);
        view.setTranslationX(translationX);
        view.setTranslationY(translationY);
        view.setScaleX(scaleX);
        view.setScaleY(scaleY);
        view.setRotation(rotation);
        view.setRotationX(rotationX);
        view.setRotationY(rotationY);
        PlatformInterop.setPivotXIfNeeded(view, pivotX);
        PlatformInterop.setPivotYIfNeeded(view, pivotY);
    }

    @NonNull
    public static LinearLayout createNavigationBarOuterLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        return linearLayout;
    }

    @NonNull
    public static FrameLayout createNavigationBarArea(Context context, LinearLayout linearLayout) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(View.generateViewId());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0);
        layoutParams.gravity = 119;
        layoutParams.weight = 1.0f;
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.addView((View)frameLayout);
        return frameLayout;
    }

    @NonNull
    public static BottomNavigationView createNavigationBar(Context context, int styleAttribute, LinearLayout linearLayout, NavigationBarView.OnItemSelectedListener listener) {
        BottomNavigationView navigationView = new BottomNavigationView(context, null, styleAttribute);
        navigationView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        navigationView.setBackgroundColor(-1);
        navigationView.setOnItemSelectedListener(listener);
        linearLayout.addView((View)navigationView);
        return navigationView;
    }

    @NonNull
    public static MaterialToolbar createToolbar(Context context, int actionBarHeight, int popupTheme) {
        MaterialToolbar toolbar = new MaterialToolbar(context);
        AppBarLayout.LayoutParams layoutParams = new AppBarLayout.LayoutParams(-1, actionBarHeight);
        layoutParams.setScrollFlags(0);
        toolbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (popupTheme > 0) {
            toolbar.setPopupTheme(popupTheme);
        }
        return toolbar;
    }

    @NonNull
    public static CoordinatorLayout createShellCoordinatorLayout(Context context) {
        CoordinatorLayout layout = new CoordinatorLayout(context);
        layout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return layout;
    }

    @NonNull
    public static AppBarLayout createShellAppBar(Context context, int appBarStyleAttribute, CoordinatorLayout layout) {
        AppBarLayout appbar = new AppBarLayout(context, null, appBarStyleAttribute);
        appbar.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        layout.addView((View)appbar);
        return appbar;
    }

    @NonNull
    public static TabLayout createShellTabLayout(Context context, AppBarLayout appbar, int actionBarHeight) {
        TabLayout layout = new TabLayout(context);
        AppBarLayout.LayoutParams layoutParams = new AppBarLayout.LayoutParams(-1, actionBarHeight);
        layoutParams.gravity = 80;
        layout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layout.setTabMode(0);
        appbar.addView((View)layout);
        return layout;
    }

    @NonNull
    public static ViewPager2 createShellViewPager(Context context, CoordinatorLayout layout, TabLayout tabLayout, TabLayoutMediator.TabConfigurationStrategy tabConfigurationStrategy, FragmentStateAdapter adapter, ViewPager2.OnPageChangeCallback callback) {
        ViewPager2 pager = new ViewPager2(context);
        CoordinatorLayout.LayoutParams layoutParams = new CoordinatorLayout.LayoutParams(-1, -1);
        layoutParams.setBehavior((CoordinatorLayout.Behavior)new AppBarLayout.ScrollingViewBehavior());
        pager.setOverScrollMode(2);
        pager.setId(View.generateViewId());
        pager.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        pager.setAdapter((RecyclerView.Adapter)adapter);
        pager.registerOnPageChangeCallback(callback);
        layout.addView((View)pager);
        new TabLayoutMediator(tabLayout, pager, tabConfigurationStrategy).attach();
        return pager;
    }

    public static void setColorFilter(@NonNull Drawable drawable, int color, int mode) {
        if (Build.VERSION.SDK_INT >= 29) {
            drawable.setColorFilter((ColorFilter)new BlendModeColorFilter(color, PlatformInterop.getBlendMode(mode)));
        } else {
            drawable.setColorFilter(color, PlatformInterop.getPorterMode(mode));
        }
    }

    @RequiresApi(api=29)
    static BlendMode getBlendMode(int mode) {
        switch (mode) {
            case 0: {
                return BlendMode.SRC_IN;
            }
            case 1: {
                return BlendMode.MULTIPLY;
            }
            case 2: {
                return BlendMode.SRC_ATOP;
            }
        }
        throw new RuntimeException("Invalid Mode");
    }

    static PorterDuff.Mode getPorterMode(int mode) {
        switch (mode) {
            case 0: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 1: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 2: {
                return PorterDuff.Mode.SRC_ATOP;
            }
        }
        throw new RuntimeException("Invalid Mode");
    }

    private static void prepare(RequestBuilder<Drawable> builder, Target<Drawable> target, boolean cachingEnabled, ImageLoaderCallback callback) {
        builder = builder.error((Object)callback);
        if (!cachingEnabled) {
            builder = (RequestBuilder)((RequestBuilder)builder.diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true);
        }
        builder.into(target);
    }

    private static void loadInto(RequestBuilder<Drawable> builder, ImageView imageView, boolean cachingEnabled, ImageLoaderCallback callback) {
        MauiCustomViewTarget target = new MauiCustomViewTarget(imageView, callback);
        PlatformInterop.prepare(builder, (Target<Drawable>)target, cachingEnabled, callback);
    }

    private static void load(RequestBuilder<Drawable> builder, Context context, boolean cachingEnabled, ImageLoaderCallback callback) {
        MauiCustomTarget target = new MauiCustomTarget(context, callback);
        PlatformInterop.prepare(builder, (Target<Drawable>)target, cachingEnabled, callback);
    }

    public static void loadImageFromFile(ImageView imageView, String file, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((View)imageView).load(file);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, true, callback);
    }

    public static void loadImageFromUri(ImageView imageView, String uri, boolean cachingEnabled, ImageLoaderCallback callback) {
        Uri androidUri = Uri.parse((String)uri);
        if (androidUri == null) {
            callback.onComplete(false, null, null);
            return;
        }
        RequestBuilder builder = Glide.with((View)imageView).load(androidUri);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, cachingEnabled, callback);
    }

    public static void loadImageFromStream(ImageView imageView, InputStream inputStream, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((View)imageView).load((Object)inputStream);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, false, callback);
    }

    public static void loadImageFromFont(ImageView imageView, @ColorInt int color, String glyph, Typeface typeface, float textSize, ImageLoaderCallback callback) {
        FontModel fontModel = new FontModel(color, glyph, textSize, typeface);
        RequestBuilder builder = (RequestBuilder)Glide.with((View)imageView).load((Object)fontModel).override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, true, callback);
    }

    public static void loadImageFromFile(Context context, String file, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((Context)context).load(file);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, true, callback);
    }

    public static void loadImageFromUri(Context context, String uri, boolean cachingEnabled, ImageLoaderCallback callback) {
        Uri androidUri = Uri.parse((String)uri);
        if (androidUri == null) {
            callback.onComplete(false, null, null);
            return;
        }
        RequestBuilder builder = Glide.with((Context)context).load(androidUri);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, cachingEnabled, callback);
    }

    public static void loadImageFromStream(Context context, InputStream inputStream, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((Context)context).load((Object)inputStream);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, false, callback);
    }

    public static void loadImageFromFont(Context context, @ColorInt int color, String glyph, Typeface typeface, float textSize, ImageLoaderCallback callback) {
        FontModel fontModel = new FontModel(color, glyph, textSize, typeface);
        RequestBuilder builder = (RequestBuilder)Glide.with((Context)context).load((Object)fontModel).override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList getColorStateListForToolbarStyleableAttribute(Context context, int resId, int index) {
        TintTypedArray styledAttributes = TintTypedArray.obtainStyledAttributes((Context)context, null, (int[])R.styleable.Toolbar, (int)resId, (int)0);
        try {
            ColorStateList colorStateList = styledAttributes.getColorStateList(index);
            return colorStateList;
        }
        finally {
            styledAttributes.recycle();
        }
    }

    public static long measureAndGetWidthAndHeight(View view, int widthMeasureSpec, int heightMeasureSpec) {
        view.measure(widthMeasureSpec, heightMeasureSpec);
        int width = view.getMeasuredWidth();
        int height = view.getMeasuredHeight();
        return (long)width << 32 | (long)height & 0xFFFFFFFFL;
    }

    @NonNull
    public static ColorStateList getDefaultColorStateList(int color) {
        return new ColorStateList(ColorStates.DEFAULT, new int[]{color});
    }

    @NonNull
    public static ColorStateList getEditTextColorStateList(int enabled, int disabled) {
        return new ColorStateList(ColorStates.getEditTextState(), new int[]{enabled, disabled});
    }

    @NonNull
    public static ColorStateList getCheckBoxColorStateList(int enabledChecked, int enabledUnchecked, int disabledChecked, int disabledUnchecked) {
        return new ColorStateList(ColorStates.getCheckBoxState(), new int[]{enabledChecked, enabledUnchecked, disabledChecked, disabledUnchecked});
    }

    @NonNull
    public static ColorStateList getSwitchColorStateList(int disabled, int on, int normal) {
        return new ColorStateList(ColorStates.getSwitchState(), new int[]{disabled, on, normal});
    }

    @NonNull
    public static ColorStateList getButtonColorStateList(int enabled, int disabled, int off, int pressed) {
        return new ColorStateList(ColorStates.getButtonState(), new int[]{enabled, disabled, off, pressed});
    }

    public static ColorStateList createEditTextColorStateList(ColorStateList colorStateList, int color) {
        if (colorStateList == null) {
            return PlatformInterop.getEditTextColorStateList(color, color);
        }
        int[][] editTextState = ColorStates.getEditTextState();
        for (int i = 0; i < editTextState.length; ++i) {
            if (colorStateList.getColorForState(editTextState[i], color) == color) continue;
            return PlatformInterop.getEditTextColorStateList(color, color);
        }
        return null;
    }

    public static void setPaintValues(Paint paint, float strokeWidth, Paint.Join strokeJoin, Paint.Cap strokeCap, float strokeMiter, PathEffect pathEffect) {
        paint.setStrokeWidth(strokeWidth);
        paint.setStrokeJoin(strokeJoin);
        paint.setStrokeCap(strokeCap);
        paint.setStrokeMiter(strokeMiter);
        if (pathEffect != null) {
            paint.setPathEffect(pathEffect);
        }
    }

    public static void drawMauiDrawablePath(PaintDrawable drawable, Canvas canvas, int width, int height, @NonNull Path clipPath, Paint borderPaint) {
        int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)width, (float)height, null);
        Paint paint = drawable.getPaint();
        if (paint != null) {
            canvas.drawPath(clipPath, paint);
        }
        if (borderPaint != null) {
            canvas.drawPath(clipPath, borderPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    public static int getWindowBackgroundColor(Context context) {
        TypedValue value = new TypedValue();
        if (!context.getTheme().resolveAttribute(16842836, value, true) && PlatformInterop.isColorType(value)) {
            return value.data;
        }
        return -1;
    }

    private static boolean isColorType(TypedValue value) {
        if (Build.VERSION.SDK_INT >= 29) {
            return value.isColorType();
        }
        return value.type >= 28 && value.type <= 31;
    }

    public static void updateMaxLength(@NonNull EditText editText, int maxLength) {
        PlatformInterop.setLengthFilter(editText, maxLength);
        if (maxLength < 0) {
            return;
        }
        Editable currentText = editText.getText();
        if (currentText.length() > maxLength) {
            editText.setText(currentText.subSequence(0, maxLength));
        }
    }

    public static void setLengthFilter(@NonNull EditText editText, int maxLength) {
        if (maxLength == -1) {
            maxLength = Integer.MAX_VALUE;
        }
        ArrayList<InputFilter> currentFilters = new ArrayList<InputFilter>(Arrays.asList(editText.getFilters()));
        boolean changed = false;
        for (int i = 0; i < currentFilters.size(); ++i) {
            InputFilter filter = (InputFilter)currentFilters.get(i);
            if (!(filter instanceof InputFilter.LengthFilter)) continue;
            currentFilters.remove(i);
            changed = true;
            break;
        }
        if (maxLength >= 0) {
            currentFilters.add((InputFilter)new InputFilter.LengthFilter(maxLength));
            changed = true;
        }
        if (changed) {
            InputFilter[] newFilter = new InputFilter[currentFilters.size()];
            editText.setFilters(currentFilters.toArray(newFilter));
        }
    }

    @NonNull
    public static Rect getCurrentWindowMetrics(Activity activity) {
        return WindowMetricsCalculator.Companion.getOrCreate().computeCurrentWindowMetrics(activity).getBounds();
    }

    public static Paint.FontMetrics getFontMetrics(Context context, final float defaultFontSize) {
        if (context == null) {
            return null;
        }
        final DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        if (metrics != null) {
            return new Paint(){
                {
                    this.setTextSize(TypedValue.applyDimension((int)2, (float)defaultFontSize, (DisplayMetrics)metrics));
                }
            }.getFontMetrics();
        }
        return null;
    }

    public static Animatable getAnimatable(Drawable drawable) {
        if (drawable instanceof Animatable) {
            return (Animatable)drawable;
        }
        return null;
    }

    private static class ColorStates {
        static final int[] EMPTY = new int[0];
        static final int[][] DEFAULT = new int[][]{EMPTY};
        private static int[][] editTextState;
        private static int[][] checkBoxState;
        private static int[][] switchState;
        private static int[][] buttonState;

        private ColorStates() {
        }

        static int[][] getEditTextState() {
            if (editTextState == null) {
                editTextState = new int[][]{{16842910}, {-16842910}};
            }
            return editTextState;
        }

        static int[][] getCheckBoxState() {
            if (checkBoxState == null) {
                checkBoxState = new int[][]{{16842910, 0x10100A0}, {16842910, -16842912}, {-16842910, 0x10100A0}, {-16842910, -16842919}};
            }
            return checkBoxState;
        }

        static int[][] getSwitchState() {
            if (switchState == null) {
                switchState = new int[][]{{-16842910}, {0x10100A0}, EMPTY};
            }
            return switchState;
        }

        static int[][] getButtonState() {
            if (buttonState == null) {
                buttonState = new int[][]{{16842910}, {-16842910}, {-16842912}, {16842919}};
            }
            return buttonState;
        }
    }
}

