/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util.pool;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Pools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.ArrayList;
import java.util.List;

public final class FactoryPools {
    private static final String TAG = "FactoryPools";
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final Resetter<Object> EMPTY_RESETTER = new Resetter<Object>(){

        @Override
        public void reset(@NonNull Object object) {
        }
    };

    private FactoryPools() {
    }

    @NonNull
    public static <T extends Poolable> Pools.Pool<T> simple(int size, @NonNull Factory<T> factory) {
        return FactoryPools.build(new Pools.SimplePool(size), factory);
    }

    @NonNull
    public static <T extends Poolable> Pools.Pool<T> threadSafe(int size, @NonNull Factory<T> factory) {
        return FactoryPools.build(new Pools.SynchronizedPool(size), factory);
    }

    @NonNull
    public static <T> Pools.Pool<List<T>> threadSafeList() {
        return FactoryPools.threadSafeList(20);
    }

    @NonNull
    public static <T> Pools.Pool<List<T>> threadSafeList(int size) {
        return FactoryPools.build(new Pools.SynchronizedPool(size), new Factory<List<T>>(){

            @Override
            @NonNull
            public List<T> create() {
                return new ArrayList();
            }
        }, new Resetter<List<T>>(){

            @Override
            public void reset(@NonNull List<T> object) {
                object.clear();
            }
        });
    }

    @NonNull
    private static <T extends Poolable> Pools.Pool<T> build(@NonNull Pools.Pool<T> pool, @NonNull Factory<T> factory) {
        return FactoryPools.build(pool, factory, FactoryPools.emptyResetter());
    }

    @NonNull
    private static <T> Pools.Pool<T> build(@NonNull Pools.Pool<T> pool, @NonNull Factory<T> factory, @NonNull Resetter<T> resetter) {
        return new FactoryPool<T>(pool, factory, resetter);
    }

    @NonNull
    private static <T> Resetter<T> emptyResetter() {
        return EMPTY_RESETTER;
    }

    private static final class FactoryPool<T>
    implements Pools.Pool<T> {
        private final Factory<T> factory;
        private final Resetter<T> resetter;
        private final Pools.Pool<T> pool;

        FactoryPool(@NonNull Pools.Pool<T> pool, @NonNull Factory<T> factory, @NonNull Resetter<T> resetter) {
            this.pool = pool;
            this.factory = factory;
            this.resetter = resetter;
        }

        public T acquire() {
            Object result = this.pool.acquire();
            if (result == null) {
                result = this.factory.create();
                if (Log.isLoggable((String)FactoryPools.TAG, (int)2)) {
                    Log.v((String)FactoryPools.TAG, (String)("Created new " + result.getClass()));
                }
            }
            if (result instanceof Poolable) {
                ((Poolable)result).getVerifier().setRecycled(false);
            }
            return (T)result;
        }

        public boolean release(@NonNull T instance) {
            if (instance instanceof Poolable) {
                ((Poolable)instance).getVerifier().setRecycled(true);
            }
            this.resetter.reset(instance);
            return this.pool.release(instance);
        }
    }

    public static interface Poolable {
        @NonNull
        public StateVerifier getVerifier();
    }

    public static interface Resetter<T> {
        public void reset(@NonNull T var1);
    }

    public static interface Factory<T> {
        public T create();
    }
}

