/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.module;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.bumptech.glide.module.GlideModule;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class ManifestParser {
    private static final String TAG = "ManifestParser";
    private static final String GLIDE_MODULE_VALUE = "GlideModule";
    private final Context context;

    public ManifestParser(Context context) {
        this.context = context;
    }

    @Nullable
    private ApplicationInfo getOurApplicationInfo() throws PackageManager.NameNotFoundException {
        return this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
    }

    public List<GlideModule> parse() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Loading Glide modules");
        }
        ArrayList<GlideModule> modules = new ArrayList<GlideModule>();
        try {
            ApplicationInfo appInfo = this.getOurApplicationInfo();
            if (appInfo == null || appInfo.metaData == null) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Got null app info metadata");
                }
                return modules;
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Got app info metadata: " + appInfo.metaData));
            }
            for (String key : appInfo.metaData.keySet()) {
                if (!GLIDE_MODULE_VALUE.equals(appInfo.metaData.get(key))) continue;
                modules.add(ManifestParser.parseModule(key));
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Loaded Glide module: " + key));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find metadata to parse GlideModules", e);
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Finished loading Glide modules");
        }
        return modules;
    }

    private static GlideModule parseModule(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find GlideModule implementation", e);
        }
        Object module = null;
        try {
            module = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            ManifestParser.throwInstantiateGlideModuleException(clazz, e);
        }
        catch (IllegalAccessException e) {
            ManifestParser.throwInstantiateGlideModuleException(clazz, e);
        }
        catch (NoSuchMethodException e) {
            ManifestParser.throwInstantiateGlideModuleException(clazz, e);
        }
        catch (InvocationTargetException e) {
            ManifestParser.throwInstantiateGlideModuleException(clazz, e);
        }
        if (!(module instanceof GlideModule)) {
            throw new RuntimeException("Expected instanceof GlideModule, but found: " + module);
        }
        return module;
    }

    private static void throwInstantiateGlideModuleException(Class<?> clazz, Exception e) {
        throw new RuntimeException("Unable to instantiate GlideModule implementation for " + clazz, e);
    }
}

