/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.manager.LifecycleLifecycle;
import com.bumptech.glide.manager.LifecycleListener;
import com.bumptech.glide.manager.RequestManagerRetriever;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class LifecycleRequestManagerRetriever {
    final Map<Lifecycle, RequestManager> lifecycleToRequestManager = new HashMap<Lifecycle, RequestManager>();
    @NonNull
    private final RequestManagerRetriever.RequestManagerFactory factory;

    LifecycleRequestManagerRetriever(@NonNull RequestManagerRetriever.RequestManagerFactory factory) {
        this.factory = factory;
    }

    RequestManager getOnly(Lifecycle lifecycle) {
        Util.assertMainThread();
        return this.lifecycleToRequestManager.get(lifecycle);
    }

    RequestManager getOrCreate(Context context, Glide glide, final Lifecycle lifecycle, FragmentManager childFragmentManager, boolean isParentVisible) {
        Util.assertMainThread();
        RequestManager result = this.getOnly(lifecycle);
        if (result == null) {
            LifecycleLifecycle glideLifecycle = new LifecycleLifecycle(lifecycle);
            result = this.factory.build(glide, glideLifecycle, new SupportRequestManagerTreeNode(childFragmentManager), context);
            this.lifecycleToRequestManager.put(lifecycle, result);
            glideLifecycle.addListener(new LifecycleListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onStop() {
                }

                @Override
                public void onDestroy() {
                    LifecycleRequestManagerRetriever.this.lifecycleToRequestManager.remove(lifecycle);
                }
            });
            if (isParentVisible) {
                result.onStart();
            }
        }
        return result;
    }

    private final class SupportRequestManagerTreeNode
    implements RequestManagerTreeNode {
        private final FragmentManager childFragmentManager;

        SupportRequestManagerTreeNode(FragmentManager childFragmentManager) {
            this.childFragmentManager = childFragmentManager;
        }

        @Override
        @NonNull
        public Set<RequestManager> getDescendants() {
            HashSet<RequestManager> result = new HashSet<RequestManager>();
            this.getChildFragmentsRecursive(this.childFragmentManager, result);
            return result;
        }

        private void getChildFragmentsRecursive(FragmentManager fragmentManager, Set<RequestManager> requestManagers) {
            List children = fragmentManager.getFragments();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                Fragment child = (Fragment)children.get(i);
                this.getChildFragmentsRecursive(child.getChildFragmentManager(), requestManagers);
                RequestManager fromChild = LifecycleRequestManagerRetriever.this.getOnly(child.getLifecycle());
                if (fromChild == null) continue;
                requestManagers.add(fromChild);
            }
        }
    }
}

