/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.data.InputStreamRewinder;
import com.bumptech.glide.load.data.ParcelFileDescriptorRewinder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.bumptech.glide.util.ByteBufferUtil;
import com.bumptech.glide.util.Preconditions;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

interface ImageReader {
    @Nullable
    public Bitmap decodeBitmap(BitmapFactory.Options var1) throws IOException;

    public ImageHeaderParser.ImageType getImageType() throws IOException;

    public int getImageOrientation() throws IOException;

    public void stopGrowingBuffers();

    @RequiresApi(value=21)
    public static final class ParcelFileDescriptorImageReader
    implements ImageReader {
        private final ArrayPool byteArrayPool;
        private final List<ImageHeaderParser> parsers;
        private final ParcelFileDescriptorRewinder dataRewinder;

        ParcelFileDescriptorImageReader(ParcelFileDescriptor parcelFileDescriptor, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.byteArrayPool = Preconditions.checkNotNull(byteArrayPool);
            this.parsers = Preconditions.checkNotNull(parsers);
            this.dataRewinder = new ParcelFileDescriptorRewinder(parcelFileDescriptor);
        }

        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) throws IOException {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)this.dataRewinder.rewindAndGet().getFileDescriptor(), null, (BitmapFactory.Options)options);
        }

        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            return ImageHeaderParserUtils.getType(this.parsers, this.dataRewinder, this.byteArrayPool);
        }

        @Override
        public int getImageOrientation() throws IOException {
            return ImageHeaderParserUtils.getOrientation(this.parsers, this.dataRewinder, this.byteArrayPool);
        }

        @Override
        public void stopGrowingBuffers() {
        }
    }

    public static final class InputStreamImageReader
    implements ImageReader {
        private final InputStreamRewinder dataRewinder;
        private final ArrayPool byteArrayPool;
        private final List<ImageHeaderParser> parsers;

        InputStreamImageReader(InputStream is, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.byteArrayPool = Preconditions.checkNotNull(byteArrayPool);
            this.parsers = Preconditions.checkNotNull(parsers);
            this.dataRewinder = new InputStreamRewinder(is, byteArrayPool);
        }

        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) throws IOException {
            return BitmapFactory.decodeStream((InputStream)this.dataRewinder.rewindAndGet(), null, (BitmapFactory.Options)options);
        }

        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            return ImageHeaderParserUtils.getType(this.parsers, this.dataRewinder.rewindAndGet(), this.byteArrayPool);
        }

        @Override
        public int getImageOrientation() throws IOException {
            return ImageHeaderParserUtils.getOrientation(this.parsers, this.dataRewinder.rewindAndGet(), this.byteArrayPool);
        }

        @Override
        public void stopGrowingBuffers() {
            this.dataRewinder.fixMarkLimits();
        }
    }

    public static final class ByteBufferReader
    implements ImageReader {
        private final ByteBuffer buffer;
        private final List<ImageHeaderParser> parsers;
        private final ArrayPool byteArrayPool;

        ByteBufferReader(ByteBuffer buffer, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.buffer = buffer;
            this.parsers = parsers;
            this.byteArrayPool = byteArrayPool;
        }

        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) {
            return BitmapFactory.decodeStream((InputStream)this.stream(), null, (BitmapFactory.Options)options);
        }

        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            return ImageHeaderParserUtils.getType(this.parsers, ByteBufferUtil.rewind(this.buffer));
        }

        @Override
        public int getImageOrientation() throws IOException {
            return ImageHeaderParserUtils.getOrientation(this.parsers, ByteBufferUtil.rewind(this.buffer), this.byteArrayPool);
        }

        @Override
        public void stopGrowingBuffers() {
        }

        private InputStream stream() {
            return ByteBufferUtil.toStream(ByteBufferUtil.rewind(this.buffer));
        }
    }

    public static final class FileReader
    implements ImageReader {
        private final File file;
        private final List<ImageHeaderParser> parsers;
        private final ArrayPool byteArrayPool;

        FileReader(File file, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.file = file;
            this.parsers = parsers;
            this.byteArrayPool = byteArrayPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) throws FileNotFoundException {
            InputStream is = null;
            try {
                is = new RecyclableBufferedInputStream(new FileInputStream(this.file), this.byteArrayPool);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
                return bitmap;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            InputStream is = null;
            try {
                is = new RecyclableBufferedInputStream(new FileInputStream(this.file), this.byteArrayPool);
                ImageHeaderParser.ImageType imageType = ImageHeaderParserUtils.getType(this.parsers, is, this.byteArrayPool);
                return imageType;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getImageOrientation() throws IOException {
            InputStream is = null;
            try {
                is = new RecyclableBufferedInputStream(new FileInputStream(this.file), this.byteArrayPool);
                int n = ImageHeaderParserUtils.getOrientation(this.parsers, is, this.byteArrayPool);
                return n;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void stopGrowingBuffers() {
        }
    }

    public static final class ByteArrayReader
    implements ImageReader {
        private final byte[] bytes;
        private final List<ImageHeaderParser> parsers;
        private final ArrayPool byteArrayPool;

        ByteArrayReader(byte[] bytes, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.bytes = bytes;
            this.parsers = parsers;
            this.byteArrayPool = byteArrayPool;
        }

        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) {
            return BitmapFactory.decodeByteArray((byte[])this.bytes, (int)0, (int)this.bytes.length, (BitmapFactory.Options)options);
        }

        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            return ImageHeaderParserUtils.getType(this.parsers, ByteBuffer.wrap(this.bytes));
        }

        @Override
        public int getImageOrientation() throws IOException {
            return ImageHeaderParserUtils.getOrientation(this.parsers, ByteBuffer.wrap(this.bytes), this.byteArrayPool);
        }

        @Override
        public void stopGrowingBuffers() {
        }
    }
}

