/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import com.bumptech.glide.load.resource.DefaultOnHeaderDecodedListener;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.io.IOException;

@RequiresApi(api=28)
public final class BitmapImageDecoderResourceDecoder
implements ResourceDecoder<ImageDecoder.Source, Bitmap> {
    private static final String TAG = "BitmapImageDecoder";
    private final BitmapPool bitmapPool = new BitmapPoolAdapter();

    @Override
    public boolean handles(@NonNull ImageDecoder.Source source, @NonNull Options options) throws IOException {
        return true;
    }

    @Override
    public Resource<Bitmap> decode(@NonNull ImageDecoder.Source source, int width, int height, @NonNull Options options) throws IOException {
        Bitmap result = ImageDecoder.decodeBitmap((ImageDecoder.Source)source, (ImageDecoder.OnHeaderDecodedListener)new DefaultOnHeaderDecodedListener(width, height, options));
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Decoded [" + result.getWidth() + "x" + result.getHeight() + "] for [" + width + "x" + height + "]"));
        }
        return new BitmapResource(result, this.bitmapPool);
    }
}

