/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource;

import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.os.Build;
import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.PreferredColorSpace;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;

@RequiresApi(api=28)
public final class DefaultOnHeaderDecodedListener
implements ImageDecoder.OnHeaderDecodedListener {
    private static final String TAG = "ImageDecoder";
    private final HardwareConfigState hardwareConfigState = HardwareConfigState.getInstance();
    private final int requestedWidth;
    private final int requestedHeight;
    private final DecodeFormat decodeFormat;
    private final DownsampleStrategy strategy;
    private final boolean isHardwareConfigAllowed;
    private final PreferredColorSpace preferredColorSpace;

    public DefaultOnHeaderDecodedListener(int requestedWidth, int requestedHeight, @NonNull Options options) {
        this.requestedWidth = requestedWidth;
        this.requestedHeight = requestedHeight;
        this.decodeFormat = options.get(Downsampler.DECODE_FORMAT);
        this.strategy = options.get(DownsampleStrategy.OPTION);
        this.isHardwareConfigAllowed = options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != null && options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != false;
        this.preferredColorSpace = options.get(Downsampler.PREFERRED_COLOR_SPACE);
    }

    public void onHeaderDecoded(@NonNull ImageDecoder decoder, @NonNull ImageDecoder.ImageInfo info, @NonNull ImageDecoder.Source source) {
        if (this.hardwareConfigState.isHardwareConfigAllowed(this.requestedWidth, this.requestedHeight, this.isHardwareConfigAllowed, false)) {
            decoder.setAllocator(3);
        } else {
            decoder.setAllocator(1);
        }
        if (this.decodeFormat == DecodeFormat.PREFER_RGB_565) {
            decoder.setMemorySizePolicy(0);
        }
        decoder.setOnPartialImageListener(new ImageDecoder.OnPartialImageListener(){

            public boolean onPartialImage(@NonNull ImageDecoder.DecodeException e) {
                return false;
            }
        });
        Size size = info.getSize();
        int targetWidth = this.requestedWidth;
        if (this.requestedWidth == Integer.MIN_VALUE) {
            targetWidth = size.getWidth();
        }
        int targetHeight = this.requestedHeight;
        if (this.requestedHeight == Integer.MIN_VALUE) {
            targetHeight = size.getHeight();
        }
        float scaleFactor = this.strategy.getScaleFactor(size.getWidth(), size.getHeight(), targetWidth, targetHeight);
        int resizeWidth = Math.round(scaleFactor * (float)size.getWidth());
        int resizeHeight = Math.round(scaleFactor * (float)size.getHeight());
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Resizing from [" + size.getWidth() + "x" + size.getHeight() + "] to [" + resizeWidth + "x" + resizeHeight + "] scaleFactor: " + scaleFactor));
        }
        decoder.setTargetSize(resizeWidth, resizeHeight);
        if (this.preferredColorSpace != null) {
            if (Build.VERSION.SDK_INT >= 28) {
                boolean isP3Eligible = this.preferredColorSpace == PreferredColorSpace.DISPLAY_P3 && info.getColorSpace() != null && info.getColorSpace().isWideGamut();
                decoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)(isP3Eligible ? ColorSpace.Named.DISPLAY_P3 : ColorSpace.Named.SRGB)));
            } else if (Build.VERSION.SDK_INT >= 26) {
                decoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB));
            }
        }
    }
}

