/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.bumptech.glide.util.LogTime;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class HttpUrlFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "HttpUrlFetcher";
    private static final int MAXIMUM_REDIRECTS = 5;
    @VisibleForTesting
    static final String REDIRECT_HEADER_FIELD = "Location";
    @VisibleForTesting
    static final HttpUrlConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultHttpUrlConnectionFactory();
    @VisibleForTesting
    static final int INVALID_STATUS_CODE = -1;
    private final GlideUrl glideUrl;
    private final int timeout;
    private final HttpUrlConnectionFactory connectionFactory;
    private HttpURLConnection urlConnection;
    private InputStream stream;
    private volatile boolean isCancelled;

    public HttpUrlFetcher(GlideUrl glideUrl, int timeout) {
        this(glideUrl, timeout, DEFAULT_CONNECTION_FACTORY);
    }

    @VisibleForTesting
    HttpUrlFetcher(GlideUrl glideUrl, int timeout, HttpUrlConnectionFactory connectionFactory) {
        this.glideUrl = glideUrl;
        this.timeout = timeout;
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        long startTime = LogTime.getLogTime();
        try {
            InputStream result = this.loadDataWithRedirects(this.glideUrl.toURL(), 0, null, this.glideUrl.getHeaders());
            callback.onDataReady(result);
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to load data for url", (Throwable)e);
            }
            callback.onLoadFailed(e);
        }
        finally {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Finished http url fetcher fetch in " + LogTime.getElapsedMillis(startTime)));
            }
        }
    }

    private InputStream loadDataWithRedirects(URL url, int redirects, URL lastUrl, Map<String, String> headers) throws HttpException {
        if (redirects >= 5) {
            throw new HttpException("Too many (> 5) redirects!", -1);
        }
        try {
            if (lastUrl != null && url.toURI().equals(lastUrl.toURI())) {
                throw new HttpException("In re-direct loop", -1);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.urlConnection = this.buildAndConfigureConnection(url, headers);
        try {
            this.urlConnection.connect();
            this.stream = this.urlConnection.getInputStream();
        }
        catch (IOException e) {
            throw new HttpException("Failed to connect or obtain data", HttpUrlFetcher.getHttpStatusCodeOrInvalid(this.urlConnection), e);
        }
        if (this.isCancelled) {
            return null;
        }
        int statusCode = HttpUrlFetcher.getHttpStatusCodeOrInvalid(this.urlConnection);
        if (HttpUrlFetcher.isHttpOk(statusCode)) {
            return this.getStreamForSuccessfulRequest(this.urlConnection);
        }
        if (HttpUrlFetcher.isHttpRedirect(statusCode)) {
            URL redirectUrl;
            String redirectUrlString = this.urlConnection.getHeaderField(REDIRECT_HEADER_FIELD);
            if (TextUtils.isEmpty((CharSequence)redirectUrlString)) {
                throw new HttpException("Received empty or null redirect url", statusCode);
            }
            try {
                redirectUrl = new URL(url, redirectUrlString);
            }
            catch (MalformedURLException e) {
                throw new HttpException("Bad redirect url: " + redirectUrlString, statusCode, e);
            }
            this.cleanup();
            return this.loadDataWithRedirects(redirectUrl, redirects + 1, url, headers);
        }
        if (statusCode == -1) {
            throw new HttpException(statusCode);
        }
        try {
            throw new HttpException(this.urlConnection.getResponseMessage(), statusCode);
        }
        catch (IOException e) {
            throw new HttpException("Failed to get a response message", statusCode, e);
        }
    }

    private static int getHttpStatusCodeOrInvalid(HttpURLConnection urlConnection) {
        try {
            return urlConnection.getResponseCode();
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to get a response code", (Throwable)e);
            }
            return -1;
        }
    }

    private HttpURLConnection buildAndConfigureConnection(URL url, Map<String, String> headers) throws HttpException {
        HttpURLConnection urlConnection;
        try {
            urlConnection = this.connectionFactory.build(url);
        }
        catch (IOException e) {
            throw new HttpException("URL.openConnection threw", 0, e);
        }
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            urlConnection.addRequestProperty(headerEntry.getKey(), headerEntry.getValue());
        }
        urlConnection.setConnectTimeout(this.timeout);
        urlConnection.setReadTimeout(this.timeout);
        urlConnection.setUseCaches(false);
        urlConnection.setDoInput(true);
        urlConnection.setInstanceFollowRedirects(false);
        return urlConnection;
    }

    private static boolean isHttpOk(int statusCode) {
        return statusCode / 100 == 2;
    }

    private static boolean isHttpRedirect(int statusCode) {
        return statusCode / 100 == 3;
    }

    private InputStream getStreamForSuccessfulRequest(HttpURLConnection urlConnection) throws HttpException {
        try {
            if (TextUtils.isEmpty((CharSequence)urlConnection.getContentEncoding())) {
                int contentLength = urlConnection.getContentLength();
                this.stream = ContentLengthInputStream.obtain(urlConnection.getInputStream(), contentLength);
            } else {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Got non empty content encoding: " + urlConnection.getContentEncoding()));
                }
                this.stream = urlConnection.getInputStream();
            }
        }
        catch (IOException e) {
            throw new HttpException("Failed to obtain InputStream", HttpUrlFetcher.getHttpStatusCodeOrInvalid(urlConnection), e);
        }
        return this.stream;
    }

    @Override
    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
        this.urlConnection = null;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }

    private static class DefaultHttpUrlConnectionFactory
    implements HttpUrlConnectionFactory {
        DefaultHttpUrlConnectionFactory() {
        }

        @Override
        public HttpURLConnection build(URL url) throws IOException {
            return (HttpURLConnection)url.openConnection();
        }
    }

    static interface HttpUrlConnectionFactory {
        public HttpURLConnection build(URL var1) throws IOException;
    }
}

