/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.data.ParcelFileDescriptorRewinder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.bumptech.glide.util.ByteBufferUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public final class ImageHeaderParserUtils {
    private static final int MARK_READ_LIMIT = 0x500000;

    private ImageHeaderParserUtils() {
    }

    @NonNull
    public static ImageHeaderParser.ImageType getType(@NonNull List<ImageHeaderParser> parsers, @Nullable InputStream is, @NonNull ArrayPool byteArrayPool) throws IOException {
        if (is == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        if (!is.markSupported()) {
            is = new RecyclableBufferedInputStream(is, byteArrayPool);
        }
        is.mark(0x500000);
        final InputStream finalIs = is;
        return ImageHeaderParserUtils.getTypeInternal(parsers, new TypeReader(){

            @Override
            public ImageHeaderParser.ImageType getTypeAndRewind(ImageHeaderParser parser) throws IOException {
                try {
                    ImageHeaderParser.ImageType imageType = parser.getType(finalIs);
                    return imageType;
                }
                finally {
                    finalIs.reset();
                }
            }
        });
    }

    @NonNull
    public static ImageHeaderParser.ImageType getType(@NonNull List<ImageHeaderParser> parsers, final @Nullable ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        return ImageHeaderParserUtils.getTypeInternal(parsers, new TypeReader(){

            @Override
            public ImageHeaderParser.ImageType getTypeAndRewind(ImageHeaderParser parser) throws IOException {
                try {
                    ImageHeaderParser.ImageType imageType = parser.getType(buffer);
                    return imageType;
                }
                finally {
                    ByteBufferUtil.rewind(buffer);
                }
            }
        });
    }

    @NonNull
    @RequiresApi(value=21)
    public static ImageHeaderParser.ImageType getType(@NonNull List<ImageHeaderParser> parsers, final @NonNull ParcelFileDescriptorRewinder parcelFileDescriptorRewinder, final @NonNull ArrayPool byteArrayPool) throws IOException {
        return ImageHeaderParserUtils.getTypeInternal(parsers, new TypeReader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImageHeaderParser.ImageType getTypeAndRewind(ImageHeaderParser parser) throws IOException {
                RecyclableBufferedInputStream is = null;
                try {
                    is = new RecyclableBufferedInputStream(new FileInputStream(parcelFileDescriptorRewinder.rewindAndGet().getFileDescriptor()), byteArrayPool);
                    ImageHeaderParser.ImageType imageType = parser.getType(is);
                    return imageType;
                }
                finally {
                    if (is != null) {
                        is.release();
                    }
                    parcelFileDescriptorRewinder.rewindAndGet();
                }
            }
        });
    }

    @NonNull
    private static ImageHeaderParser.ImageType getTypeInternal(@NonNull List<ImageHeaderParser> parsers, TypeReader reader) throws IOException {
        int size = parsers.size();
        for (int i = 0; i < size; ++i) {
            ImageHeaderParser parser = parsers.get(i);
            ImageHeaderParser.ImageType type = reader.getTypeAndRewind(parser);
            if (type == ImageHeaderParser.ImageType.UNKNOWN) continue;
            return type;
        }
        return ImageHeaderParser.ImageType.UNKNOWN;
    }

    public static int getOrientation(@NonNull List<ImageHeaderParser> parsers, final @Nullable ByteBuffer buffer, final @NonNull ArrayPool arrayPool) throws IOException {
        if (buffer == null) {
            return -1;
        }
        return ImageHeaderParserUtils.getOrientationInternal(parsers, new OrientationReader(){

            @Override
            public int getOrientationAndRewind(ImageHeaderParser parser) throws IOException {
                try {
                    int n = parser.getOrientation(buffer, arrayPool);
                    return n;
                }
                finally {
                    ByteBufferUtil.rewind(buffer);
                }
            }
        });
    }

    public static int getOrientation(@NonNull List<ImageHeaderParser> parsers, @Nullable InputStream is, final @NonNull ArrayPool byteArrayPool) throws IOException {
        if (is == null) {
            return -1;
        }
        if (!is.markSupported()) {
            is = new RecyclableBufferedInputStream(is, byteArrayPool);
        }
        is.mark(0x500000);
        final InputStream finalIs = is;
        return ImageHeaderParserUtils.getOrientationInternal(parsers, new OrientationReader(){

            @Override
            public int getOrientationAndRewind(ImageHeaderParser parser) throws IOException {
                try {
                    int n = parser.getOrientation(finalIs, byteArrayPool);
                    return n;
                }
                finally {
                    finalIs.reset();
                }
            }
        });
    }

    @RequiresApi(value=21)
    public static int getOrientation(@NonNull List<ImageHeaderParser> parsers, final @NonNull ParcelFileDescriptorRewinder parcelFileDescriptorRewinder, final @NonNull ArrayPool byteArrayPool) throws IOException {
        return ImageHeaderParserUtils.getOrientationInternal(parsers, new OrientationReader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getOrientationAndRewind(ImageHeaderParser parser) throws IOException {
                RecyclableBufferedInputStream is = null;
                try {
                    is = new RecyclableBufferedInputStream(new FileInputStream(parcelFileDescriptorRewinder.rewindAndGet().getFileDescriptor()), byteArrayPool);
                    int n = parser.getOrientation(is, byteArrayPool);
                    return n;
                }
                finally {
                    if (is != null) {
                        is.release();
                    }
                    parcelFileDescriptorRewinder.rewindAndGet();
                }
            }
        });
    }

    private static int getOrientationInternal(@NonNull List<ImageHeaderParser> parsers, OrientationReader reader) throws IOException {
        int size = parsers.size();
        for (int i = 0; i < size; ++i) {
            ImageHeaderParser parser = parsers.get(i);
            int orientation = reader.getOrientationAndRewind(parser);
            if (orientation == -1) continue;
            return orientation;
        }
        return -1;
    }

    private static interface OrientationReader {
        public int getOrientationAndRewind(ImageHeaderParser var1) throws IOException;
    }

    private static interface TypeReader {
        public ImageHeaderParser.ImageType getTypeAndRewind(ImageHeaderParser var1) throws IOException;
    }
}

