/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import android.os.Bundle;
import androidx.annotation.NonNull;

public interface TrustedWebActivityDisplayMode {
    public static final String KEY_ID = "androidx.browser.trusted.displaymode.KEY_ID";

    @NonNull
    public static TrustedWebActivityDisplayMode fromBundle(@NonNull Bundle bundle) {
        switch (bundle.getInt(KEY_ID)) {
            case 1: {
                return ImmersiveMode.fromBundle(bundle);
            }
        }
        return new DefaultMode();
    }

    @NonNull
    public Bundle toBundle();

    public static class DefaultMode
    implements TrustedWebActivityDisplayMode {
        private static final int ID = 0;

        @Override
        @NonNull
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(TrustedWebActivityDisplayMode.KEY_ID, 0);
            return bundle;
        }
    }

    public static class ImmersiveMode
    implements TrustedWebActivityDisplayMode {
        private static final int ID = 1;
        public static final String KEY_STICKY = "androidx.browser.trusted.displaymode.KEY_STICKY";
        public static final String KEY_CUTOUT_MODE = "androidx.browser.trusted.displaymode.KEY_CUTOUT_MODE";
        private final boolean mIsSticky;
        private final int mLayoutInDisplayCutoutMode;

        public ImmersiveMode(boolean isSticky, int layoutInDisplayCutoutMode) {
            this.mIsSticky = isSticky;
            this.mLayoutInDisplayCutoutMode = layoutInDisplayCutoutMode;
        }

        @NonNull
        static TrustedWebActivityDisplayMode fromBundle(@NonNull Bundle bundle) {
            return new ImmersiveMode(bundle.getBoolean(KEY_STICKY), bundle.getInt(KEY_CUTOUT_MODE));
        }

        @Override
        @NonNull
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(TrustedWebActivityDisplayMode.KEY_ID, 1);
            bundle.putBoolean(KEY_STICKY, this.mIsSticky);
            bundle.putInt(KEY_CUTOUT_MODE, this.mLayoutInDisplayCutoutMode);
            return bundle;
        }

        public boolean isSticky() {
            return this.mIsSticky;
        }

        public int layoutInDisplayCutoutMode() {
            return this.mLayoutInDisplayCutoutMode;
        }
    }
}

