/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.ViewGroup;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.Toolbar;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.AbstractAppBarOnDestinationChangedListener;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.transition.TransitionManager;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/navigation/ui/ToolbarOnDestinationChangedListener;", "Landroidx/navigation/ui/AbstractAppBarOnDestinationChangedListener;", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "configuration", "Landroidx/navigation/ui/AppBarConfiguration;", "(Landroidx/appcompat/widget/Toolbar;Landroidx/navigation/ui/AppBarConfiguration;)V", "toolbarWeakReference", "Ljava/lang/ref/WeakReference;", "onDestinationChanged", "", "controller", "Landroidx/navigation/NavController;", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "setNavigationIcon", "icon", "Landroid/graphics/drawable/Drawable;", "contentDescription", "", "setTitle", "title", "", "navigation-ui_release"})
public final class ToolbarOnDestinationChangedListener
extends AbstractAppBarOnDestinationChangedListener {
    @NotNull
    private final WeakReference<Toolbar> toolbarWeakReference;

    public ToolbarOnDestinationChangedListener(@NotNull Toolbar toolbar, @NotNull AppBarConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Context context = toolbar.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"toolbar.context");
        super(context, configuration);
        this.toolbarWeakReference = new WeakReference<Toolbar>(toolbar);
    }

    @Override
    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Toolbar toolbar = (Toolbar)this.toolbarWeakReference.get();
        if (toolbar == null) {
            controller.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            return;
        }
        super.onDestinationChanged(controller, destination, arguments);
    }

    @Override
    protected void setTitle(@Nullable CharSequence title) {
        block0: {
            Toolbar toolbar = (Toolbar)this.toolbarWeakReference.get();
            if (toolbar == null) break block0;
            Toolbar toolbar2 = toolbar;
            boolean bl = false;
            toolbar2.setTitle(title);
        }
    }

    @Override
    protected void setNavigationIcon(@Nullable Drawable icon, @StringRes int contentDescription) {
        block1: {
            Toolbar toolbar = (Toolbar)this.toolbarWeakReference.get();
            if (toolbar == null) break block1;
            Toolbar $this$setNavigationIcon_u24lambda_u241 = toolbar;
            boolean bl = false;
            boolean useTransition = icon == null && $this$setNavigationIcon_u24lambda_u241.getNavigationIcon() != null;
            $this$setNavigationIcon_u24lambda_u241.setNavigationIcon(icon);
            $this$setNavigationIcon_u24lambda_u241.setNavigationContentDescription(contentDescription);
            if (useTransition) {
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)$this$setNavigationIcon_u24lambda_u241));
            }
        }
    }
}

