/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.IdRes;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.customview.widget.Openable;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.ui.ActionBarOnDestinationChangedListener;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.CollapsingToolbarOnDestinationChangedListener;
import androidx.navigation.ui.NavigationUiSaveStateControl;
import androidx.navigation.ui.R;
import androidx.navigation.ui.ToolbarOnDestinationChangedListener;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.navigation.NavigationView;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\"\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J*\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\u0019\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u001b\u0010\"\u001a\u00020\n*\u00020#2\b\b\u0001\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/navigation/ui/NavigationUI;", "", "()V", "TAG", "", "findBottomSheetBehavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "view", "Landroid/view/View;", "navigateUp", "", "navController", "Landroidx/navigation/NavController;", "openableLayout", "Landroidx/customview/widget/Openable;", "configuration", "Landroidx/navigation/ui/AppBarConfiguration;", "onNavDestinationSelected", "item", "Landroid/view/MenuItem;", "saveState", "setupActionBarWithNavController", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "setupWithNavController", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "collapsingToolbarLayout", "Lcom/google/android/material/appbar/CollapsingToolbarLayout;", "navigationBarView", "Lcom/google/android/material/navigation/NavigationBarView;", "navigationView", "Lcom/google/android/material/navigation/NavigationView;", "matchDestination", "Landroidx/navigation/NavDestination;", "destId", "", "matchDestination$navigation_ui_release", "navigation-ui_release"})
@SourceDebugExtension(value={"SMAP\nNavigationUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationUI.kt\nandroidx/navigation/ui/NavigationUI\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,728:1\n1229#2,2:729\n*S KotlinDebug\n*F\n+ 1 NavigationUI.kt\nandroidx/navigation/ui/NavigationUI\n*L\n726#1:729,2\n*E\n"})
public final class NavigationUI {
    @NotNull
    public static final NavigationUI INSTANCE = new NavigationUI();
    @NotNull
    private static final String TAG = "NavigationUI";

    private NavigationUI() {
    }

    @JvmStatic
    public static final boolean onNavDestinationSelected(@NotNull MenuItem item, @NotNull NavController navController) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavOptions.Builder builder = new NavOptions.Builder().setLaunchSingleTop(true).setRestoreState(true);
        NavDestination navDestination = navController.getCurrentDestination();
        Intrinsics.checkNotNull((Object)navDestination);
        NavGraph navGraph = navDestination.getParent();
        Intrinsics.checkNotNull((Object)navGraph);
        if (navGraph.findNode(item.getItemId()) instanceof ActivityNavigator.Destination) {
            builder.setEnterAnim(R.anim.nav_default_enter_anim).setExitAnim(R.anim.nav_default_exit_anim).setPopEnterAnim(R.anim.nav_default_pop_enter_anim).setPopExitAnim(R.anim.nav_default_pop_exit_anim);
        } else {
            builder.setEnterAnim(R.animator.nav_default_enter_anim).setExitAnim(R.animator.nav_default_exit_anim).setPopEnterAnim(R.animator.nav_default_pop_enter_anim).setPopExitAnim(R.animator.nav_default_pop_exit_anim);
        }
        if ((item.getOrder() & 0x30000) == 0) {
            builder.setPopUpTo(NavGraph.Companion.findStartDestination(navController.getGraph()).getId(), false, true);
        }
        NavOptions options = builder.build();
        try {
            navController.navigate(item.getItemId(), null, options);
            NavDestination navDestination2 = navController.getCurrentDestination();
            bl = navDestination2 != null ? NavigationUI.matchDestination$navigation_ui_release(navDestination2, item.getItemId()) : false;
        }
        catch (IllegalArgumentException e) {
            String name = NavDestination.Companion.getDisplayName(navController.getContext(), item.getItemId());
            Log.i((String)TAG, (String)("Ignoring onNavDestinationSelected for MenuItem " + name + " as it cannot be found from the current destination " + navController.getCurrentDestination()), (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NavigationUiSaveStateControl
    @JvmStatic
    public static final boolean onNavDestinationSelected(@NotNull MenuItem item, @NotNull NavController navController, boolean saveState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        if (!(!saveState)) {
            boolean $i$a$-check-NavigationUI$onNavDestinationSelected$22 = false;
            String $i$a$-check-NavigationUI$onNavDestinationSelected$22 = "Leave the saveState parameter out entirely to use the non-experimental version of this API, which saves the state by default";
            throw new IllegalStateException($i$a$-check-NavigationUI$onNavDestinationSelected$22.toString());
        }
        NavOptions.Builder builder = new NavOptions.Builder().setLaunchSingleTop(true);
        NavDestination navDestination = navController.getCurrentDestination();
        Intrinsics.checkNotNull((Object)navDestination);
        NavGraph navGraph = navDestination.getParent();
        Intrinsics.checkNotNull((Object)navGraph);
        if (navGraph.findNode(item.getItemId()) instanceof ActivityNavigator.Destination) {
            builder.setEnterAnim(R.anim.nav_default_enter_anim).setExitAnim(R.anim.nav_default_exit_anim).setPopEnterAnim(R.anim.nav_default_pop_enter_anim).setPopExitAnim(R.anim.nav_default_pop_exit_anim);
        } else {
            builder.setEnterAnim(R.animator.nav_default_enter_anim).setExitAnim(R.animator.nav_default_exit_anim).setPopEnterAnim(R.animator.nav_default_pop_enter_anim).setPopExitAnim(R.animator.nav_default_pop_exit_anim);
        }
        if ((item.getOrder() & 0x30000) == 0) {
            NavOptions.Builder.setPopUpTo$default((NavOptions.Builder)builder, (int)NavGraph.Companion.findStartDestination(navController.getGraph()).getId(), (boolean)false, (boolean)false, (int)4, null);
        }
        NavOptions options = builder.build();
        try {
            navController.navigate(item.getItemId(), null, options);
            NavDestination navDestination2 = navController.getCurrentDestination();
            bl = navDestination2 != null ? NavigationUI.matchDestination$navigation_ui_release(navDestination2, item.getItemId()) : false;
        }
        catch (IllegalArgumentException e) {
            String name = NavDestination.Companion.getDisplayName(navController.getContext(), item.getItemId());
            Log.i((String)TAG, (String)("Ignoring onNavDestinationSelected for MenuItem " + name + " as it cannot be found from the current destination " + navController.getCurrentDestination()), (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean navigateUp(@NotNull NavController navController, @Nullable Openable openableLayout) {
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        return NavigationUI.navigateUp(navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    @JvmStatic
    public static final boolean navigateUp(@NotNull NavController navController, @NotNull AppBarConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Openable openableLayout = configuration.getOpenableLayout();
        NavDestination currentDestination = navController.getCurrentDestination();
        if (openableLayout == null || currentDestination == null || !configuration.isTopLevelDestination(currentDestination)) {
            boolean bl;
            if (navController.navigateUp()) {
                bl = true;
            } else {
                AppBarConfiguration.OnNavigateUpListener onNavigateUpListener = configuration.getFallbackOnNavigateUpListener();
                bl = onNavigateUpListener != null ? onNavigateUpListener.onNavigateUp() : false;
            }
            return bl;
        }
        openableLayout.open();
        return true;
    }

    @JvmStatic
    public static final void setupActionBarWithNavController(@NotNull AppCompatActivity activity, @NotNull NavController navController, @Nullable Openable openableLayout) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationUI.setupActionBarWithNavController(activity, navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    @JvmStatic
    @JvmOverloads
    public static final void setupActionBarWithNavController(@NotNull AppCompatActivity activity, @NotNull NavController navController, @NotNull AppBarConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)new ActionBarOnDestinationChangedListener(activity, configuration));
    }

    public static /* synthetic */ void setupActionBarWithNavController$default(AppCompatActivity appCompatActivity, NavController navController, AppBarConfiguration appBarConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            appBarConfiguration = new AppBarConfiguration.Builder(navController.getGraph()).build();
        }
        NavigationUI.setupActionBarWithNavController(appCompatActivity, navController, appBarConfiguration);
    }

    @JvmStatic
    public static final void setupWithNavController(@NotNull Toolbar toolbar, @NotNull NavController navController, @Nullable Openable openableLayout) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationUI.setupWithNavController(toolbar, navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    @JvmStatic
    @JvmOverloads
    public static final void setupWithNavController(@NotNull Toolbar toolbar, @NotNull NavController navController, @NotNull AppBarConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)new ToolbarOnDestinationChangedListener(toolbar, configuration));
        toolbar.setNavigationOnClickListener(arg_0 -> NavigationUI.setupWithNavController$lambda$1(navController, configuration, arg_0));
    }

    public static /* synthetic */ void setupWithNavController$default(Toolbar toolbar, NavController navController, AppBarConfiguration appBarConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            appBarConfiguration = new AppBarConfiguration.Builder(navController.getGraph()).build();
        }
        NavigationUI.setupWithNavController(toolbar, navController, appBarConfiguration);
    }

    @JvmStatic
    public static final void setupWithNavController(@NotNull CollapsingToolbarLayout collapsingToolbarLayout, @NotNull Toolbar toolbar, @NotNull NavController navController, @Nullable Openable openableLayout) {
        Intrinsics.checkNotNullParameter((Object)collapsingToolbarLayout, (String)"collapsingToolbarLayout");
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationUI.setupWithNavController(collapsingToolbarLayout, toolbar, navController, new AppBarConfiguration.Builder(navController.getGraph()).setOpenableLayout(openableLayout).build());
    }

    @JvmStatic
    @JvmOverloads
    public static final void setupWithNavController(@NotNull CollapsingToolbarLayout collapsingToolbarLayout, @NotNull Toolbar toolbar, @NotNull NavController navController, @NotNull AppBarConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)collapsingToolbarLayout, (String)"collapsingToolbarLayout");
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)new CollapsingToolbarOnDestinationChangedListener(collapsingToolbarLayout, toolbar, configuration));
        toolbar.setNavigationOnClickListener(arg_0 -> NavigationUI.setupWithNavController$lambda$2(navController, configuration, arg_0));
    }

    public static /* synthetic */ void setupWithNavController$default(CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, NavController navController, AppBarConfiguration appBarConfiguration, int n, Object object) {
        if ((n & 8) != 0) {
            appBarConfiguration = new AppBarConfiguration.Builder(navController.getGraph()).build();
        }
        NavigationUI.setupWithNavController(collapsingToolbarLayout, toolbar, navController, appBarConfiguration);
    }

    @JvmStatic
    public static final void setupWithNavController(@NotNull NavigationView navigationView, @NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)navigationView, (String)"navigationView");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        navigationView.setNavigationItemSelectedListener(arg_0 -> NavigationUI.setupWithNavController$lambda$3(navController, navigationView, arg_0));
        WeakReference<NavigationView> weakReference = new WeakReference<NavigationView>(navigationView);
        navController.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(weakReference, navController){
            final /* synthetic */ WeakReference<NavigationView> $weakReference;
            final /* synthetic */ NavController $navController;
            {
                this.$weakReference = $weakReference;
                this.$navController = $navController;
            }

            /*
             * WARNING - void declaration
             */
            public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
                Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                NavigationView view = (NavigationView)this.$weakReference.get();
                if (view == null) {
                    this.$navController.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
                    return;
                }
                if (destination instanceof FloatingWindow) {
                    return;
                }
                Menu menu = view.getMenu();
                Intrinsics.checkNotNullExpressionValue((Object)menu, (String)"view.menu");
                Menu $this$forEach$iv = menu;
                boolean $i$f$forEach = false;
                int n = 0;
                int n2 = $this$forEach$iv.size();
                while (n < n2) {
                    MenuItem item;
                    void index$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getItem((int)index$iv), (String)"getItem(index)");
                    boolean bl = false;
                    item.setChecked(NavigationUI.matchDestination$navigation_ui_release(destination, item.getItemId()));
                    ++index$iv;
                }
            }
        });
    }

    @NavigationUiSaveStateControl
    @JvmStatic
    public static final void setupWithNavController(@NotNull NavigationView navigationView, @NotNull NavController navController, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)navigationView, (String)"navigationView");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        if (!(!saveState)) {
            boolean bl = false;
            String string2 = "Leave the saveState parameter out entirely to use the non-experimental version of this API, which saves the state by default";
            throw new IllegalStateException(string2.toString());
        }
        navigationView.setNavigationItemSelectedListener(arg_0 -> NavigationUI.setupWithNavController$lambda$5(navController, saveState, navigationView, arg_0));
        WeakReference<NavigationView> weakReference = new WeakReference<NavigationView>(navigationView);
        navController.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(weakReference, navController){
            final /* synthetic */ WeakReference<NavigationView> $weakReference;
            final /* synthetic */ NavController $navController;
            {
                this.$weakReference = $weakReference;
                this.$navController = $navController;
            }

            /*
             * WARNING - void declaration
             */
            public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
                Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                NavigationView view = (NavigationView)this.$weakReference.get();
                if (view == null) {
                    this.$navController.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
                    return;
                }
                if (destination instanceof FloatingWindow) {
                    return;
                }
                Menu menu = view.getMenu();
                Intrinsics.checkNotNullExpressionValue((Object)menu, (String)"view.menu");
                Menu $this$forEach$iv = menu;
                boolean $i$f$forEach = false;
                int n = 0;
                int n2 = $this$forEach$iv.size();
                while (n < n2) {
                    MenuItem item;
                    void index$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getItem((int)index$iv), (String)"getItem(index)");
                    boolean bl = false;
                    item.setChecked(NavigationUI.matchDestination$navigation_ui_release(destination, item.getItemId()));
                    ++index$iv;
                }
            }
        });
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final BottomSheetBehavior<?> findBottomSheetBehavior(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            ViewParent parent = view.getParent();
            return parent instanceof View ? NavigationUI.findBottomSheetBehavior((View)parent) : null;
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        return !(behavior instanceof BottomSheetBehavior) ? null : (BottomSheetBehavior)behavior;
    }

    @JvmStatic
    public static final void setupWithNavController(@NotNull NavigationBarView navigationBarView, @NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)navigationBarView, (String)"navigationBarView");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        navigationBarView.setOnItemSelectedListener(arg_0 -> NavigationUI.setupWithNavController$lambda$6(navController, arg_0));
        WeakReference<NavigationBarView> weakReference = new WeakReference<NavigationBarView>(navigationBarView);
        navController.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(weakReference, navController){
            final /* synthetic */ WeakReference<NavigationBarView> $weakReference;
            final /* synthetic */ NavController $navController;
            {
                this.$weakReference = $weakReference;
                this.$navController = $navController;
            }

            /*
             * WARNING - void declaration
             */
            public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
                Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                NavigationBarView view = (NavigationBarView)this.$weakReference.get();
                if (view == null) {
                    this.$navController.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
                    return;
                }
                if (destination instanceof FloatingWindow) {
                    return;
                }
                Menu menu = view.getMenu();
                Intrinsics.checkNotNullExpressionValue((Object)menu, (String)"view.menu");
                Menu $this$forEach$iv = menu;
                boolean $i$f$forEach = false;
                int n = 0;
                int n2 = $this$forEach$iv.size();
                while (n < n2) {
                    MenuItem item;
                    void index$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getItem((int)index$iv), (String)"getItem(index)");
                    boolean bl = false;
                    if (NavigationUI.matchDestination$navigation_ui_release(destination, item.getItemId())) {
                        item.setChecked(true);
                    }
                    ++index$iv;
                }
            }
        });
    }

    @NavigationUiSaveStateControl
    @JvmStatic
    public static final void setupWithNavController(@NotNull NavigationBarView navigationBarView, @NotNull NavController navController, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)navigationBarView, (String)"navigationBarView");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        if (!(!saveState)) {
            boolean bl = false;
            String string2 = "Leave the saveState parameter out entirely to use the non-experimental version of this API, which saves the state by default";
            throw new IllegalStateException(string2.toString());
        }
        navigationBarView.setOnItemSelectedListener(arg_0 -> NavigationUI.setupWithNavController$lambda$8(navController, saveState, arg_0));
        WeakReference<NavigationBarView> weakReference = new WeakReference<NavigationBarView>(navigationBarView);
        navController.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener(weakReference, navController){
            final /* synthetic */ WeakReference<NavigationBarView> $weakReference;
            final /* synthetic */ NavController $navController;
            {
                this.$weakReference = $weakReference;
                this.$navController = $navController;
            }

            /*
             * WARNING - void declaration
             */
            public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
                Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                NavigationBarView view = (NavigationBarView)this.$weakReference.get();
                if (view == null) {
                    this.$navController.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
                    return;
                }
                if (destination instanceof FloatingWindow) {
                    return;
                }
                Menu menu = view.getMenu();
                Intrinsics.checkNotNullExpressionValue((Object)menu, (String)"view.menu");
                Menu $this$forEach$iv = menu;
                boolean $i$f$forEach = false;
                int n = 0;
                int n2 = $this$forEach$iv.size();
                while (n < n2) {
                    MenuItem item;
                    void index$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getItem((int)index$iv), (String)"getItem(index)");
                    boolean bl = false;
                    if (NavigationUI.matchDestination$navigation_ui_release(destination, item.getItemId())) {
                        item.setChecked(true);
                    }
                    ++index$iv;
                }
            }
        });
    }

    @JvmStatic
    public static final boolean matchDestination$navigation_ui_release(@NotNull NavDestination $this$matchDestination, @IdRes int destId) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$matchDestination, (String)"<this>");
            Sequence $this$any$iv = NavDestination.Companion.getHierarchy($this$matchDestination);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                NavDestination it = (NavDestination)element$iv;
                boolean bl2 = false;
                if (!(it.getId() == destId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @JvmOverloads
    public static final void setupActionBarWithNavController(@NotNull AppCompatActivity activity, @NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationUI.setupActionBarWithNavController$default(activity, navController, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setupWithNavController(@NotNull Toolbar toolbar, @NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationUI.setupWithNavController$default(toolbar, navController, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setupWithNavController(@NotNull CollapsingToolbarLayout collapsingToolbarLayout, @NotNull Toolbar toolbar, @NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)collapsingToolbarLayout, (String)"collapsingToolbarLayout");
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationUI.setupWithNavController$default(collapsingToolbarLayout, toolbar, navController, null, 8, null);
    }

    private static final void setupWithNavController$lambda$1(NavController $navController, AppBarConfiguration $configuration, View it) {
        Intrinsics.checkNotNullParameter((Object)$navController, (String)"$navController");
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        NavigationUI.navigateUp($navController, $configuration);
    }

    private static final void setupWithNavController$lambda$2(NavController $navController, AppBarConfiguration $configuration, View it) {
        Intrinsics.checkNotNullParameter((Object)$navController, (String)"$navController");
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        NavigationUI.navigateUp($navController, $configuration);
    }

    private static final boolean setupWithNavController$lambda$3(NavController $navController, NavigationView $navigationView, MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)$navController, (String)"$navController");
        Intrinsics.checkNotNullParameter((Object)$navigationView, (String)"$navigationView");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean handled = NavigationUI.onNavDestinationSelected(item, $navController);
        if (handled) {
            ViewParent parent = $navigationView.getParent();
            if (parent instanceof Openable) {
                ((Openable)parent).close();
            } else {
                BottomSheetBehavior<?> bottomSheetBehavior = NavigationUI.findBottomSheetBehavior((View)$navigationView);
                if (bottomSheetBehavior != null) {
                    bottomSheetBehavior.setState(5);
                }
            }
        }
        return handled;
    }

    private static final boolean setupWithNavController$lambda$5(NavController $navController, boolean $saveState, NavigationView $navigationView, MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)$navController, (String)"$navController");
        Intrinsics.checkNotNullParameter((Object)$navigationView, (String)"$navigationView");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean handled = NavigationUI.onNavDestinationSelected(item, $navController, $saveState);
        if (handled) {
            ViewParent parent = $navigationView.getParent();
            if (parent instanceof Openable) {
                ((Openable)parent).close();
            } else {
                BottomSheetBehavior<?> bottomSheetBehavior = NavigationUI.findBottomSheetBehavior((View)$navigationView);
                if (bottomSheetBehavior != null) {
                    bottomSheetBehavior.setState(5);
                }
            }
        }
        return handled;
    }

    private static final boolean setupWithNavController$lambda$6(NavController $navController, MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)$navController, (String)"$navController");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return NavigationUI.onNavDestinationSelected(item, $navController);
    }

    private static final boolean setupWithNavController$lambda$8(NavController $navController, boolean $saveState, MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)$navController, (String)"$navController");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return NavigationUI.onNavDestinationSelected(item, $navController, $saveState);
    }
}

