/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.util;

import android.content.Context;
import android.graphics.Rect;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.core.view.WindowInsetsCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Landroidx/window/layout/util/ContextCompatHelper;", "", "()V", "currentWindowBounds", "Landroid/graphics/Rect;", "context", "Landroid/content/Context;", "currentWindowInsets", "Landroidx/core/view/WindowInsetsCompat;", "maximumWindowBounds", "window_release"})
@RequiresApi(value=30)
public final class ContextCompatHelper {
    @NotNull
    public static final ContextCompatHelper INSTANCE = new ContextCompatHelper();

    private ContextCompatHelper() {
    }

    @NotNull
    public final Rect currentWindowBounds(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        Rect rect = wm.getCurrentWindowMetrics().getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"wm.currentWindowMetrics.bounds");
        return rect;
    }

    @NotNull
    public final Rect maximumWindowBounds(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        Rect rect = wm.getMaximumWindowMetrics().getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"wm.maximumWindowMetrics.bounds");
        return rect;
    }

    @DoNotInline
    @NotNull
    public final WindowInsetsCompat currentWindowInsets(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        WindowInsets windowInsets = wm.getCurrentWindowMetrics().getWindowInsets();
        Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"wm.currentWindowMetrics.windowInsets");
        WindowInsets platformInsets = windowInsets;
        WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)platformInsets);
        Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"toWindowInsetsCompat(platformInsets)");
        return windowInsetsCompat;
    }
}

