/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.adapter.sidecar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.OnConfigurationChangedProvider;
import androidx.core.util.Consumer;
import androidx.window.core.Version;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.adapter.sidecar.DistinctElementSidecarCallback;
import androidx.window.layout.adapter.sidecar.ExtensionInterfaceCompat;
import androidx.window.layout.adapter.sidecar.SidecarAdapter;
import androidx.window.sidecar.SidecarDeviceState;
import androidx.window.sidecar.SidecarDisplayFeature;
import androidx.window.sidecar.SidecarInterface;
import androidx.window.sidecar.SidecarProvider;
import androidx.window.sidecar.SidecarWindowLayoutInfo;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 #2\u00020\u0001:\u0004#$%&B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0007\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\"H\u0017R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/window/layout/adapter/sidecar/SidecarCompat;", "Landroidx/window/layout/adapter/sidecar/ExtensionInterfaceCompat;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "sidecar", "Landroidx/window/sidecar/SidecarInterface;", "sidecarAdapter", "Landroidx/window/layout/adapter/sidecar/SidecarAdapter;", "(Landroidx/window/sidecar/SidecarInterface;Landroidx/window/layout/adapter/sidecar/SidecarAdapter;)V", "componentCallbackMap", "", "Landroid/app/Activity;", "Landroidx/core/util/Consumer;", "Landroid/content/res/Configuration;", "extensionCallback", "Landroidx/window/layout/adapter/sidecar/SidecarCompat$DistinctElementCallback;", "getSidecar", "()Landroidx/window/sidecar/SidecarInterface;", "windowListenerRegisteredContexts", "Landroid/os/IBinder;", "getWindowLayoutInfo", "Landroidx/window/layout/WindowLayoutInfo;", "activity", "onWindowLayoutChangeListenerAdded", "", "onWindowLayoutChangeListenerRemoved", "register", "windowToken", "registerConfigurationChangeListener", "setExtensionCallback", "Landroidx/window/layout/adapter/sidecar/ExtensionInterfaceCompat$ExtensionCallbackInterface;", "unregisterComponentCallback", "validateExtensionInterface", "", "Companion", "DistinctElementCallback", "FirstAttachAdapter", "TranslatingCallback", "window_release"})
public final class SidecarCompat
implements ExtensionInterfaceCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SidecarInterface sidecar;
    @NotNull
    private final SidecarAdapter sidecarAdapter;
    @NotNull
    private final Map<IBinder, Activity> windowListenerRegisteredContexts;
    @NotNull
    private final Map<Activity, Consumer<Configuration>> componentCallbackMap;
    @Nullable
    private DistinctElementCallback extensionCallback;
    @NotNull
    private static final String TAG = "SidecarCompat";

    @VisibleForTesting
    public SidecarCompat(@Nullable SidecarInterface sidecar, @NotNull SidecarAdapter sidecarAdapter) {
        Intrinsics.checkNotNullParameter((Object)sidecarAdapter, (String)"sidecarAdapter");
        this.sidecar = sidecar;
        this.sidecarAdapter = sidecarAdapter;
        this.windowListenerRegisteredContexts = new LinkedHashMap();
        this.componentCallbackMap = new LinkedHashMap();
    }

    @VisibleForTesting
    @Nullable
    public final SidecarInterface getSidecar() {
        return this.sidecar;
    }

    public SidecarCompat(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(Companion.getSidecarCompat$window_release(context), new SidecarAdapter(null, 1, null));
    }

    @Override
    public void setExtensionCallback(@NotNull ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)extensionCallback, (String)"extensionCallback");
            this.extensionCallback = new DistinctElementCallback(extensionCallback);
            SidecarInterface sidecarInterface = this.sidecar;
            if (sidecarInterface == null) break block0;
            sidecarInterface.setSidecarCallback((SidecarInterface.SidecarCallback)new DistinctElementSidecarCallback(this.sidecarAdapter, new TranslatingCallback()));
        }
    }

    @VisibleForTesting
    @NotNull
    public final WindowLayoutInfo getWindowLayoutInfo(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        IBinder iBinder = Companion.getActivityWindowToken$window_release(activity);
        if (iBinder == null) {
            return new WindowLayoutInfo(CollectionsKt.emptyList());
        }
        IBinder windowToken = iBinder;
        SidecarInterface sidecarInterface = this.sidecar;
        SidecarWindowLayoutInfo windowLayoutInfo2 = sidecarInterface != null ? sidecarInterface.getWindowLayoutInfo(windowToken) : null;
        SidecarInterface sidecarInterface2 = this.sidecar;
        if (sidecarInterface2 == null || (sidecarInterface2 = sidecarInterface2.getDeviceState()) == null) {
            sidecarInterface2 = new SidecarDeviceState();
        }
        return this.sidecarAdapter.translate(windowLayoutInfo2, (SidecarDeviceState)sidecarInterface2);
    }

    @Override
    public void onWindowLayoutChangeListenerAdded(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        IBinder windowToken = Companion.getActivityWindowToken$window_release(activity);
        if (windowToken != null) {
            this.register(windowToken, activity);
        } else {
            FirstAttachAdapter attachAdapter = new FirstAttachAdapter(this, activity);
            activity.getWindow().getDecorView().addOnAttachStateChangeListener((View.OnAttachStateChangeListener)attachAdapter);
        }
    }

    public final void register(@NotNull IBinder windowToken, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)windowToken, (String)"windowToken");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.windowListenerRegisteredContexts.put(windowToken, activity);
        SidecarInterface sidecarInterface = this.sidecar;
        if (sidecarInterface != null) {
            sidecarInterface.onWindowLayoutChangeListenerAdded(windowToken);
        }
        if (this.windowListenerRegisteredContexts.size() == 1) {
            SidecarInterface sidecarInterface2 = this.sidecar;
            if (sidecarInterface2 != null) {
                sidecarInterface2.onDeviceStateListenersChanged(false);
            }
        }
        DistinctElementCallback distinctElementCallback = this.extensionCallback;
        if (distinctElementCallback != null) {
            distinctElementCallback.onWindowLayoutChanged(activity, this.getWindowLayoutInfo(activity));
        }
        this.registerConfigurationChangeListener(activity);
    }

    private final void registerConfigurationChangeListener(Activity activity) {
        if (this.componentCallbackMap.get(activity) == null && activity instanceof OnConfigurationChangedProvider) {
            Consumer configChangeObserver = arg_0 -> SidecarCompat.registerConfigurationChangeListener$lambda$0(this, activity, arg_0);
            this.componentCallbackMap.put(activity, (Consumer<Configuration>)configChangeObserver);
            ((OnConfigurationChangedProvider)activity).addOnConfigurationChangedListener(configChangeObserver);
        }
    }

    @Override
    public void onWindowLayoutChangeListenerRemoved(@NotNull Activity activity) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            IBinder iBinder = Companion.getActivityWindowToken$window_release(activity);
            if (iBinder == null) {
                return;
            }
            IBinder windowToken = iBinder;
            SidecarInterface sidecarInterface = this.sidecar;
            if (sidecarInterface != null) {
                sidecarInterface.onWindowLayoutChangeListenerRemoved(windowToken);
            }
            this.unregisterComponentCallback(activity);
            DistinctElementCallback distinctElementCallback = this.extensionCallback;
            if (distinctElementCallback != null) {
                distinctElementCallback.clearWindowLayoutInfo(activity);
            }
            boolean isLast = this.windowListenerRegisteredContexts.size() == 1;
            this.windowListenerRegisteredContexts.remove(windowToken);
            if (!isLast) break block4;
            SidecarInterface sidecarInterface2 = this.sidecar;
            if (sidecarInterface2 != null) {
                sidecarInterface2.onDeviceStateListenersChanged(true);
            }
        }
    }

    private final void unregisterComponentCallback(Activity activity) {
        Consumer<Configuration> consumer = this.componentCallbackMap.get(activity);
        if (consumer == null) {
            return;
        }
        Consumer<Configuration> configChangeObserver = consumer;
        if (activity instanceof OnConfigurationChangedProvider) {
            ((OnConfigurationChangedProvider)activity).removeOnConfigurationChangedListener(configChangeObserver);
        }
        this.componentCallbackMap.remove(activity);
    }

    @Override
    @SuppressLint(value={"BanUncheckedReflection"})
    public boolean validateExtensionInterface() {
        boolean bl;
        try {
            block20: {
                block19: {
                    Class<?> rtUnregisterWindowLayoutChangeListener;
                    Method methodUnregisterWindowLayoutChangeListener;
                    Method method;
                    Class<?> clazz;
                    Class<?> rtRegisterWindowLayoutChangeListener;
                    Method methodRegisterWindowLayoutChangeListener;
                    Method method2;
                    SidecarInterface sidecarInterface;
                    Class<?> clazz2;
                    Class<?> rtGetWindowLayoutInfo;
                    Method methodGetWindowLayoutInfo;
                    Method method3;
                    SidecarInterface sidecarInterface2;
                    Class<?> clazz3;
                    Class<?> rSetSidecarCallback;
                    Method methodSetSidecarCallback;
                    Method method4;
                    Object object = this.sidecar;
                    if (object != null && (object = object.getClass()) != null) {
                        Class[] classArray = new Class[]{SidecarInterface.SidecarCallback.class};
                        method4 = ((Class)object).getMethod("setSidecarCallback", classArray);
                    } else {
                        method4 = null;
                    }
                    Method method5 = methodSetSidecarCallback = method4;
                    Class<Object> clazz4 = rSetSidecarCallback = method5 != null ? method5.getReturnType() : null;
                    if (!Intrinsics.areEqual(rSetSidecarCallback, Void.TYPE)) {
                        throw new NoSuchMethodException("Illegal return type for 'setSidecarCallback': " + rSetSidecarCallback);
                    }
                    SidecarInterface sidecarInterface3 = this.sidecar;
                    SidecarDeviceState tmpDeviceState = sidecarInterface3 != null ? sidecarInterface3.getDeviceState() : null;
                    SidecarInterface sidecarInterface4 = this.sidecar;
                    if (sidecarInterface4 != null) {
                        sidecarInterface4.onDeviceStateListenersChanged(true);
                    }
                    SidecarInterface sidecarInterface5 = this.sidecar;
                    if (sidecarInterface5 != null && (clazz3 = sidecarInterface5.getClass()) != null) {
                        sidecarInterface2 = new SidecarInterface[]{IBinder.class};
                        method3 = clazz3.getMethod("getWindowLayoutInfo", (Class<?>)sidecarInterface2);
                    } else {
                        method3 = null;
                    }
                    Method method6 = methodGetWindowLayoutInfo = method3;
                    Class<Object> clazz5 = rtGetWindowLayoutInfo = method6 != null ? method6.getReturnType() : null;
                    if (!Intrinsics.areEqual(rtGetWindowLayoutInfo, SidecarWindowLayoutInfo.class)) {
                        throw new NoSuchMethodException("Illegal return type for 'getWindowLayoutInfo': " + rtGetWindowLayoutInfo);
                    }
                    sidecarInterface2 = this.sidecar;
                    if (sidecarInterface2 != null && (clazz2 = sidecarInterface2.getClass()) != null) {
                        sidecarInterface = new SidecarInterface[]{IBinder.class};
                        method2 = clazz2.getMethod("onWindowLayoutChangeListenerAdded", (Class<?>)sidecarInterface);
                    } else {
                        method2 = null;
                    }
                    Method method7 = methodRegisterWindowLayoutChangeListener = method2;
                    Class<Object> clazz6 = rtRegisterWindowLayoutChangeListener = method7 != null ? method7.getReturnType() : null;
                    if (!Intrinsics.areEqual(rtRegisterWindowLayoutChangeListener, Void.TYPE)) {
                        throw new NoSuchMethodException("Illegal return type for 'onWindowLayoutChangeListenerAdded': " + rtRegisterWindowLayoutChangeListener);
                    }
                    sidecarInterface = this.sidecar;
                    if (sidecarInterface != null && (clazz = sidecarInterface.getClass()) != null) {
                        Class[] classArray = new Class[]{IBinder.class};
                        method = clazz.getMethod("onWindowLayoutChangeListenerRemoved", classArray);
                    } else {
                        method = null;
                    }
                    Method method8 = methodUnregisterWindowLayoutChangeListener = method;
                    Class<Object> clazz7 = rtUnregisterWindowLayoutChangeListener = method8 != null ? method8.getReturnType() : null;
                    if (!Intrinsics.areEqual(rtUnregisterWindowLayoutChangeListener, Void.TYPE)) {
                        throw new NoSuchMethodException("Illegal return type for 'onWindowLayoutChangeListenerRemoved': " + rtUnregisterWindowLayoutChangeListener);
                    }
                    tmpDeviceState = new SidecarDeviceState();
                    try {
                        tmpDeviceState.posture = 3;
                    }
                    catch (NoSuchFieldError error) {
                        Object[] objectArray = new Class[]{Integer.TYPE};
                        Method methodSetPosture = SidecarDeviceState.class.getMethod("setPosture", (Class<?>[])objectArray);
                        objectArray = new Object[]{3};
                        methodSetPosture.invoke((Object)tmpDeviceState, objectArray);
                        Method methodGetPosture = SidecarDeviceState.class.getMethod("getPosture", new Class[0]);
                        Object object2 = methodGetPosture.invoke((Object)tmpDeviceState, new Object[0]);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                        int posture = (Integer)object2;
                        if (posture == 3) break block19;
                        throw new Exception("Invalid device posture getter/setter");
                    }
                }
                SidecarDisplayFeature displayFeature = new SidecarDisplayFeature();
                Rect rect = displayFeature.getRect();
                Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"displayFeature.rect");
                Rect tmpRect = rect;
                displayFeature.setRect(tmpRect);
                int tmpType = displayFeature.getType();
                displayFeature.setType(1);
                SidecarWindowLayoutInfo windowLayoutInfo2 = new SidecarWindowLayoutInfo();
                try {
                    List list = windowLayoutInfo2.displayFeatures;
                }
                catch (NoSuchFieldError error) {
                    List featureList = new ArrayList();
                    featureList.add(displayFeature);
                    Object[] objectArray = new Class[]{List.class};
                    Method methodSetFeatures = SidecarWindowLayoutInfo.class.getMethod("setDisplayFeatures", (Class<?>[])objectArray);
                    objectArray = new Object[]{featureList};
                    methodSetFeatures.invoke((Object)windowLayoutInfo2, objectArray);
                    Method methodGetFeatures = SidecarWindowLayoutInfo.class.getMethod("getDisplayFeatures", new Class[0]);
                    Object object = methodGetFeatures.invoke((Object)windowLayoutInfo2, new Object[0]);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.window.sidecar.SidecarDisplayFeature>");
                    List resultDisplayFeatures = (List)object;
                    if (Intrinsics.areEqual((Object)featureList, (Object)resultDisplayFeatures)) break block20;
                    throw new Exception("Invalid display feature getter/setter");
                }
            }
            bl = true;
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    private static final void registerConfigurationChangeListener$lambda$0(SidecarCompat this$0, Activity $activity, Configuration it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$activity, (String)"$activity");
            DistinctElementCallback distinctElementCallback = this$0.extensionCallback;
            if (distinctElementCallback == null) break block0;
            distinctElementCallback.onWindowLayoutChanged($activity, this$0.getWindowLayoutInfo($activity));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Landroidx/window/layout/adapter/sidecar/SidecarCompat$Companion;", "", "()V", "TAG", "", "sidecarVersion", "Landroidx/window/core/Version;", "getSidecarVersion", "()Landroidx/window/core/Version;", "getActivityWindowToken", "Landroid/os/IBinder;", "activity", "Landroid/app/Activity;", "getActivityWindowToken$window_release", "getSidecarCompat", "Landroidx/window/sidecar/SidecarInterface;", "context", "Landroid/content/Context;", "getSidecarCompat$window_release", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Version getSidecarVersion() {
            Version version;
            try {
                String vendorVersion = SidecarProvider.getApiVersion();
                version = !TextUtils.isEmpty((CharSequence)vendorVersion) ? Version.Companion.parse(vendorVersion) : null;
            }
            catch (NoClassDefFoundError e) {
                version = null;
            }
            catch (UnsupportedOperationException e) {
                version = null;
            }
            return version;
        }

        @Nullable
        public final SidecarInterface getSidecarCompat$window_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return SidecarProvider.getSidecarImpl((Context)context.getApplicationContext());
        }

        @Nullable
        public final IBinder getActivityWindowToken$window_release(@Nullable Activity activity) {
            Activity activity2 = activity;
            return activity2 != null && (activity2 = activity2.getWindow()) != null && (activity2 = activity2.getAttributes()) != null ? activity2.token : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/window/layout/adapter/sidecar/SidecarCompat$DistinctElementCallback;", "Landroidx/window/layout/adapter/sidecar/ExtensionInterfaceCompat$ExtensionCallbackInterface;", "callbackInterface", "(Landroidx/window/layout/adapter/sidecar/ExtensionInterfaceCompat$ExtensionCallbackInterface;)V", "activityWindowLayoutInfo", "Ljava/util/WeakHashMap;", "Landroid/app/Activity;", "Landroidx/window/layout/WindowLayoutInfo;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "clearWindowLayoutInfo", "", "activity", "onWindowLayoutChanged", "newLayout", "window_release"})
    private static final class DistinctElementCallback
    implements ExtensionInterfaceCompat.ExtensionCallbackInterface {
        @NotNull
        private final ExtensionInterfaceCompat.ExtensionCallbackInterface callbackInterface;
        @NotNull
        private final ReentrantLock lock;
        @GuardedBy(value="mLock")
        @NotNull
        private final WeakHashMap<Activity, WindowLayoutInfo> activityWindowLayoutInfo;

        public DistinctElementCallback(@NotNull ExtensionInterfaceCompat.ExtensionCallbackInterface callbackInterface) {
            Intrinsics.checkNotNullParameter((Object)callbackInterface, (String)"callbackInterface");
            this.callbackInterface = callbackInterface;
            this.lock = new ReentrantLock();
            this.activityWindowLayoutInfo = new WeakHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowLayoutChanged(@NotNull Activity activity, @NotNull WindowLayoutInfo newLayout) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                WindowLayoutInfo lastInfo = this.activityWindowLayoutInfo.get(activity);
                if (Intrinsics.areEqual((Object)newLayout, (Object)lastInfo)) {
                    return;
                }
                WindowLayoutInfo windowLayoutInfo2 = this.activityWindowLayoutInfo.put(activity, newLayout);
            }
            finally {
                lock.unlock();
            }
            this.callbackInterface.onWindowLayoutChanged(activity, newLayout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearWindowLayoutInfo(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                ((Map)this.activityWindowLayoutInfo).put(activity, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/window/layout/adapter/sidecar/SidecarCompat$FirstAttachAdapter;", "Landroid/view/View$OnAttachStateChangeListener;", "sidecarCompat", "Landroidx/window/layout/adapter/sidecar/SidecarCompat;", "activity", "Landroid/app/Activity;", "(Landroidx/window/layout/adapter/sidecar/SidecarCompat;Landroid/app/Activity;)V", "activityWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "onViewAttachedToWindow", "", "view", "Landroid/view/View;", "onViewDetachedFromWindow", "window_release"})
    private static final class FirstAttachAdapter
    implements View.OnAttachStateChangeListener {
        @NotNull
        private final SidecarCompat sidecarCompat;
        @NotNull
        private final WeakReference<Activity> activityWeakReference;

        public FirstAttachAdapter(@NotNull SidecarCompat sidecarCompat, @NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)sidecarCompat, (String)"sidecarCompat");
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.sidecarCompat = sidecarCompat;
            this.activityWeakReference = new WeakReference<Activity>(activity);
        }

        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            Activity activity = (Activity)this.activityWeakReference.get();
            IBinder token = Companion.getActivityWindowToken$window_release(activity);
            if (activity == null) {
                return;
            }
            if (token == null) {
                return;
            }
            this.sidecarCompat.register(token, activity);
        }

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\f"}, d2={"Landroidx/window/layout/adapter/sidecar/SidecarCompat$TranslatingCallback;", "Landroidx/window/sidecar/SidecarInterface$SidecarCallback;", "(Landroidx/window/layout/adapter/sidecar/SidecarCompat;)V", "onDeviceStateChanged", "", "newDeviceState", "Landroidx/window/sidecar/SidecarDeviceState;", "onWindowLayoutChanged", "windowToken", "Landroid/os/IBinder;", "newLayout", "Landroidx/window/sidecar/SidecarWindowLayoutInfo;", "window_release"})
    @SourceDebugExtension(value={"SMAP\nSidecarCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SidecarCompat.kt\nandroidx/window/layout/adapter/sidecar/SidecarCompat$TranslatingCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,435:1\n1855#2:436\n1856#2:438\n1#3:437\n*S KotlinDebug\n*F\n+ 1 SidecarCompat.kt\nandroidx/window/layout/adapter/sidecar/SidecarCompat$TranslatingCallback\n*L\n335#1:436\n335#1:438\n*E\n"})
    public final class TranslatingCallback
    implements SidecarInterface.SidecarCallback {
        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"SyntheticAccessor"})
        public void onDeviceStateChanged(@NotNull SidecarDeviceState newDeviceState) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)newDeviceState, (String)"newDeviceState");
            Iterable iterable = SidecarCompat.this.windowListenerRegisteredContexts.values();
            SidecarCompat sidecarCompat = SidecarCompat.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Activity activity = (Activity)element$iv;
                boolean bl = false;
                IBinder iBinder = Companion.getActivityWindowToken$window_release(activity);
                if (iBinder != null) {
                    IBinder windowToken = iBinder;
                    boolean bl2 = false;
                    SidecarInterface sidecarInterface = sidecarCompat.getSidecar();
                    object = sidecarInterface != null ? sidecarInterface.getWindowLayoutInfo(windowToken) : null;
                } else {
                    object = null;
                }
                SidecarWindowLayoutInfo layoutInfo = object;
                DistinctElementCallback distinctElementCallback = sidecarCompat.extensionCallback;
                if (distinctElementCallback == null) continue;
                distinctElementCallback.onWindowLayoutChanged(activity, sidecarCompat.sidecarAdapter.translate(layoutInfo, newDeviceState));
            }
        }

        @SuppressLint(value={"SyntheticAccessor"})
        public void onWindowLayoutChanged(@NotNull IBinder windowToken, @NotNull SidecarWindowLayoutInfo newLayout) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)windowToken, (String)"windowToken");
                Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
                Activity activity = (Activity)SidecarCompat.this.windowListenerRegisteredContexts.get(windowToken);
                if (activity == null) {
                    Log.w((String)SidecarCompat.TAG, (String)"Unable to resolve activity from window token. Missing a call to #onWindowLayoutChangeListenerAdded()?");
                    return;
                }
                SidecarAdapter sidecarAdapter = SidecarCompat.this.sidecarAdapter;
                SidecarInterface sidecarInterface = SidecarCompat.this.getSidecar();
                if (sidecarInterface == null || (sidecarInterface = sidecarInterface.getDeviceState()) == null) {
                    sidecarInterface = new SidecarDeviceState();
                }
                WindowLayoutInfo layoutInfo = sidecarAdapter.translate(newLayout, (SidecarDeviceState)sidecarInterface);
                DistinctElementCallback distinctElementCallback = SidecarCompat.this.extensionCallback;
                if (distinctElementCallback == null) break block2;
                distinctElementCallback.onWindowLayoutChanged(activity, layoutInfo);
            }
        }
    }
}

