/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.adapter.sidecar;

import android.os.IBinder;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.window.layout.adapter.sidecar.SidecarAdapter;
import androidx.window.sidecar.SidecarDeviceState;
import androidx.window.sidecar.SidecarInterface;
import androidx.window.sidecar.SidecarWindowLayoutInfo;
import java.util.Map;
import java.util.WeakHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DistinctElementSidecarCallback
implements SidecarInterface.SidecarCallback {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private SidecarDeviceState mLastDeviceState;
    @GuardedBy(value="mLock")
    private final Map<IBinder, SidecarWindowLayoutInfo> mActivityWindowLayoutInfo = new WeakHashMap<IBinder, SidecarWindowLayoutInfo>();
    private final SidecarAdapter mAdapter;
    private final SidecarInterface.SidecarCallback mCallback;

    DistinctElementSidecarCallback(@NonNull SidecarAdapter adapter, @NonNull SidecarInterface.SidecarCallback callback) {
        this.mAdapter = adapter;
        this.mCallback = callback;
    }

    @VisibleForTesting
    public DistinctElementSidecarCallback(@NonNull SidecarInterface.SidecarCallback callback) {
        this.mAdapter = new SidecarAdapter();
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeviceStateChanged(@NonNull SidecarDeviceState newDeviceState) {
        if (newDeviceState == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdapter.isEqualSidecarDeviceState(this.mLastDeviceState, newDeviceState)) {
                return;
            }
            this.mLastDeviceState = newDeviceState;
            this.mCallback.onDeviceStateChanged(this.mLastDeviceState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowLayoutChanged(@NonNull IBinder windowToken, @NonNull SidecarWindowLayoutInfo newLayout) {
        Object object = this.mLock;
        synchronized (object) {
            SidecarWindowLayoutInfo lastInfo = this.mActivityWindowLayoutInfo.get(windowToken);
            if (this.mAdapter.isEqualSidecarWindowLayoutInfo(lastInfo, newLayout)) {
                return;
            }
            this.mActivityWindowLayoutInfo.put(windowToken, newLayout);
            this.mCallback.onWindowLayoutChanged(windowToken, newLayout);
        }
    }
}

