/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.adapter.extensions;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.window.core.ConsumerAdapter;
import androidx.window.core.ExtensionsUtil;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.adapter.WindowBackend;
import androidx.window.layout.adapter.extensions.ExtensionsWindowLayoutInfoAdapter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0007J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010\u001d\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u000f0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/window/layout/adapter/extensions/ExtensionWindowLayoutInfoBackend;", "Landroidx/window/layout/adapter/WindowBackend;", "component", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "consumerAdapter", "Landroidx/window/core/ConsumerAdapter;", "(Landroidx/window/extensions/layout/WindowLayoutComponent;Landroidx/window/core/ConsumerAdapter;)V", "consumerToOemConsumer", "", "Landroidx/window/layout/adapter/extensions/ExtensionWindowLayoutInfoBackend$MulticastConsumer;", "Landroidx/window/extensions/core/util/function/Consumer;", "Landroidx/window/extensions/layout/WindowLayoutInfo;", "consumerToToken", "Landroidx/window/core/ConsumerAdapter$Subscription;", "contextToListeners", "Landroid/content/Context;", "extensionWindowBackendLock", "Ljava/util/concurrent/locks/ReentrantLock;", "listenerToContext", "Landroidx/core/util/Consumer;", "Landroidx/window/layout/WindowLayoutInfo;", "hasRegisteredListeners", "", "registerLayoutChangeCallback", "", "context", "executor", "Ljava/util/concurrent/Executor;", "callback", "unregisterLayoutChangeCallback", "MulticastConsumer", "window_release"})
public final class ExtensionWindowLayoutInfoBackend
implements WindowBackend {
    @NotNull
    private final WindowLayoutComponent component;
    @NotNull
    private final ConsumerAdapter consumerAdapter;
    @NotNull
    private final ReentrantLock extensionWindowBackendLock;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<Context, MulticastConsumer> contextToListeners;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<androidx.core.util.Consumer<WindowLayoutInfo>, Context> listenerToContext;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<MulticastConsumer, ConsumerAdapter.Subscription> consumerToToken;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<MulticastConsumer, Consumer<androidx.window.extensions.layout.WindowLayoutInfo>> consumerToOemConsumer;

    public ExtensionWindowLayoutInfoBackend(@NotNull WindowLayoutComponent component, @NotNull ConsumerAdapter consumerAdapter) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)consumerAdapter, (String)"consumerAdapter");
        this.component = component;
        this.consumerAdapter = consumerAdapter;
        this.extensionWindowBackendLock = new ReentrantLock();
        this.contextToListeners = new LinkedHashMap();
        this.listenerToContext = new LinkedHashMap();
        this.consumerToToken = new LinkedHashMap();
        this.consumerToOemConsumer = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLayoutChangeCallback(@NotNull Context context, @NotNull Executor executor, @NotNull androidx.core.util.Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.extensionWindowBackendLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            MulticastConsumer multicastConsumer = this.contextToListeners.get(context);
            if (multicastConsumer != null) {
                MulticastConsumer listener = multicastConsumer;
                boolean bl2 = false;
                listener.addListener(callback);
                this.listenerToContext.put(callback, context);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                ExtensionWindowLayoutInfoBackend $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242 = this;
                boolean bl3 = false;
                MulticastConsumer consumer = new MulticastConsumer(context);
                $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.contextToListeners.put(context, consumer);
                $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.listenerToContext.put(callback, context);
                consumer.addListener(callback);
                if (ExtensionsUtil.INSTANCE.getSafeVendorApiLevel() < 2) {
                    Function1 consumeWindowLayoutInfo2 = (Function1)new Function1<androidx.window.extensions.layout.WindowLayoutInfo, Unit>(consumer){
                        final /* synthetic */ MulticastConsumer $consumer;
                        {
                            this.$consumer = $consumer;
                            super(1);
                        }

                        public final void invoke(@NotNull androidx.window.extensions.layout.WindowLayoutInfo value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            this.$consumer.accept(value);
                        }
                    };
                    if (!(context instanceof Activity)) {
                        consumer.accept(new androidx.window.extensions.layout.WindowLayoutInfo(CollectionsKt.emptyList()));
                        return;
                    }
                    ConsumerAdapter.Subscription disposableToken = $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.consumerAdapter.createSubscription((Object)$this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.component, Reflection.getOrCreateKotlinClass(androidx.window.extensions.layout.WindowLayoutInfo.class), "addWindowLayoutInfoListener", "removeWindowLayoutInfoListener", (Activity)context, consumeWindowLayoutInfo2);
                    $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.consumerToToken.put(consumer, disposableToken);
                } else {
                    Consumer oemConsumer = arg_0 -> ExtensionWindowLayoutInfoBackend.registerLayoutChangeCallback$lambda$3$lambda$2$lambda$1(consumer, arg_0);
                    $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.consumerToOemConsumer.put(consumer, (Consumer<androidx.window.extensions.layout.WindowLayoutInfo>)oemConsumer);
                    $this$registerLayoutChangeCallback_u24lambda_u243_u24lambda_u242.component.addWindowLayoutInfoListener(context, oemConsumer);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLayoutChangeCallback(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.extensionWindowBackendLock;
        lock.lock();
        try {
            MulticastConsumer multicastConsumer;
            Context context;
            boolean bl = false;
            if (this.listenerToContext.get(callback) == null) {
                return;
            }
            Context context2 = context;
            if (this.contextToListeners.get(context2) == null) {
                return;
            }
            MulticastConsumer multicastListener = multicastConsumer;
            multicastListener.removeListener(callback);
            this.listenerToContext.remove(callback);
            if (multicastListener.isEmpty()) {
                this.contextToListeners.remove(context2);
                if (ExtensionsUtil.INSTANCE.getSafeVendorApiLevel() < 2) {
                    ConsumerAdapter.Subscription subscription = this.consumerToToken.remove(multicastListener);
                    if (subscription != null) {
                        subscription.dispose();
                    }
                } else {
                    Consumer<androidx.window.extensions.layout.WindowLayoutInfo> oemConsumer = this.consumerToOemConsumer.remove(multicastListener);
                    if (oemConsumer != null) {
                        this.component.removeWindowLayoutInfoListener(oemConsumer);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @VisibleForTesting
    public final boolean hasRegisteredListeners() {
        return !this.contextToListeners.isEmpty() || !this.listenerToContext.isEmpty() || !this.consumerToToken.isEmpty();
    }

    private static final void registerLayoutChangeCallback$lambda$3$lambda$2$lambda$1(MulticastConsumer $consumer, androidx.window.extensions.layout.WindowLayoutInfo info) {
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        Intrinsics.checkNotNullExpressionValue((Object)info, (String)"info");
        $consumer.accept(info);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0014\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00010\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/window/layout/adapter/extensions/ExtensionWindowLayoutInfoBackend$MulticastConsumer;", "Landroidx/core/util/Consumer;", "Landroidx/window/extensions/layout/WindowLayoutInfo;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "lastKnownValue", "Landroidx/window/layout/WindowLayoutInfo;", "multicastConsumerLock", "Ljava/util/concurrent/locks/ReentrantLock;", "registeredListeners", "", "accept", "", "value", "addListener", "listener", "isEmpty", "", "removeListener", "window_release"})
    @SourceDebugExtension(value={"SMAP\nExtensionWindowLayoutInfoBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionWindowLayoutInfoBackend.kt\nandroidx/window/layout/adapter/extensions/ExtensionWindowLayoutInfoBackend$MulticastConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1855#2,2:204\n1#3:206\n*S KotlinDebug\n*F\n+ 1 ExtensionWindowLayoutInfoBackend.kt\nandroidx/window/layout/adapter/extensions/ExtensionWindowLayoutInfoBackend$MulticastConsumer\n*L\n182#1:204,2\n*E\n"})
    private static final class MulticastConsumer
    implements androidx.core.util.Consumer<androidx.window.extensions.layout.WindowLayoutInfo> {
        @NotNull
        private final Context context;
        @NotNull
        private final ReentrantLock multicastConsumerLock;
        @GuardedBy(value="lock")
        @Nullable
        private WindowLayoutInfo lastKnownValue;
        @GuardedBy(value="lock")
        @NotNull
        private final Set<androidx.core.util.Consumer<WindowLayoutInfo>> registeredListeners;

        public MulticastConsumer(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.multicastConsumerLock = new ReentrantLock();
            this.registeredListeners = new LinkedHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(@NotNull androidx.window.extensions.layout.WindowLayoutInfo value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Lock lock = this.multicastConsumerLock;
            lock.lock();
            try {
                boolean bl = false;
                this.lastKnownValue = ExtensionsWindowLayoutInfoAdapter.INSTANCE.translate$window_release(this.context, value);
                Iterable $this$forEach$iv = this.registeredListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    androidx.core.util.Consumer consumer = (androidx.core.util.Consumer)element$iv;
                    boolean bl2 = false;
                    consumer.accept((Object)this.lastKnownValue);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addListener(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            Lock lock = this.multicastConsumerLock;
            lock.lock();
            try {
                boolean bl = false;
                WindowLayoutInfo windowLayoutInfo2 = this.lastKnownValue;
                if (windowLayoutInfo2 != null) {
                    WindowLayoutInfo value = windowLayoutInfo2;
                    boolean bl2 = false;
                    listener.accept((Object)value);
                }
                boolean bl3 = this.registeredListeners.add(listener);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeListener(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            Lock lock = this.multicastConsumerLock;
            lock.lock();
            try {
                boolean bl = false;
                boolean bl2 = this.registeredListeners.remove(listener);
            }
            finally {
                lock.unlock();
            }
        }

        public final boolean isEmpty() {
            return this.registeredListeners.isEmpty();
        }
    }
}

