/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.graphics.Rect;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.view.WindowInsetsCompat;
import androidx.window.core.Bounds;
import androidx.window.core.ExperimentalWindowApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Landroidx/window/layout/WindowMetrics;", "", "bounds", "Landroid/graphics/Rect;", "insets", "Landroidx/core/view/WindowInsetsCompat;", "(Landroid/graphics/Rect;Landroidx/core/view/WindowInsetsCompat;)V", "_bounds", "Landroidx/window/core/Bounds;", "_windowInsetsCompat", "(Landroidx/window/core/Bounds;Landroidx/core/view/WindowInsetsCompat;)V", "getBounds", "()Landroid/graphics/Rect;", "equals", "", "other", "getWindowInsets", "hashCode", "", "toString", "", "window_release"})
public final class WindowMetrics {
    @NotNull
    private final Bounds _bounds;
    @NotNull
    private final WindowInsetsCompat _windowInsetsCompat;

    public WindowMetrics(@NotNull Bounds _bounds, @NotNull WindowInsetsCompat _windowInsetsCompat) {
        Intrinsics.checkNotNullParameter((Object)_bounds, (String)"_bounds");
        Intrinsics.checkNotNullParameter((Object)_windowInsetsCompat, (String)"_windowInsetsCompat");
        this._bounds = _bounds;
        this._windowInsetsCompat = _windowInsetsCompat;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public WindowMetrics(@NotNull Rect bounds, @NotNull WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        this(new Bounds(bounds), insets);
    }

    public /* synthetic */ WindowMetrics(Rect rect, WindowInsetsCompat windowInsetsCompat, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            WindowInsetsCompat windowInsetsCompat2 = new WindowInsetsCompat.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"Builder().build()");
            windowInsetsCompat = windowInsetsCompat2;
        }
        this(rect, windowInsetsCompat);
    }

    @NotNull
    public final Rect getBounds() {
        return this._bounds.toRect();
    }

    @NotNull
    public String toString() {
        return "WindowMetrics( bounds=" + this._bounds + ", windowInsetsCompat=" + this._windowInsetsCompat + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.window.layout.WindowMetrics");
        WindowMetrics cfr_ignored_0 = (WindowMetrics)other;
        if (!Intrinsics.areEqual((Object)this._bounds, (Object)((WindowMetrics)other)._bounds)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this._windowInsetsCompat, (Object)((WindowMetrics)other)._windowInsetsCompat);
    }

    public int hashCode() {
        int result = this._bounds.hashCode();
        result = 31 * result + this._windowInsetsCompat.hashCode();
        return result;
    }

    @ExperimentalWindowApi
    @RequiresApi(value=30)
    @NotNull
    public final WindowInsetsCompat getWindowInsets() {
        return this._windowInsetsCompat;
    }
}

