/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.core.util.Consumer;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.embedding.EmbeddingBackend;
import androidx.window.embedding.SplitAttributes;
import androidx.window.embedding.SplitAttributesCalculatorParams;
import androidx.window.embedding.SplitController;
import androidx.window.embedding.SplitInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007H\u0007J\b\u0010\u0018\u001a\u00020\u0012H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u001aH\u0007J\u001c\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007H\u0007J\u001c\u0010\u001d\u001a\u00020\u00122\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0007J\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0#2\u0006\u0010\u0013\u001a\u00020\u0014R(\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0004\u0012\u00020\n0\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Landroidx/window/embedding/SplitController;", "", "embeddingBackend", "Landroidx/window/embedding/EmbeddingBackend;", "(Landroidx/window/embedding/EmbeddingBackend;)V", "consumerToJobMap", "", "Landroidx/core/util/Consumer;", "", "Landroidx/window/embedding/SplitInfo;", "Lkotlinx/coroutines/Job;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "splitSupportStatus", "Landroidx/window/embedding/SplitController$SplitSupportStatus;", "getSplitSupportStatus", "()Landroidx/window/embedding/SplitController$SplitSupportStatus;", "addSplitListener", "", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "consumer", "clearSplitAttributesCalculator", "isSplitAttributesCalculatorSupported", "", "isSplitSupported", "removeSplitListener", "setSplitAttributesCalculator", "calculator", "Lkotlin/Function1;", "Landroidx/window/embedding/SplitAttributesCalculatorParams;", "Landroidx/window/embedding/SplitAttributes;", "splitInfoList", "Lkotlinx/coroutines/flow/Flow;", "Companion", "SplitSupportStatus", "window_release"})
public final class SplitController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmbeddingBackend embeddingBackend;
    @NotNull
    private final ReentrantLock lock;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<Consumer<List<SplitInfo>>, Job> consumerToJobMap;
    public static final boolean sDebug = false;

    public SplitController(@NotNull EmbeddingBackend embeddingBackend) {
        Intrinsics.checkNotNullParameter((Object)embeddingBackend, (String)"embeddingBackend");
        this.embeddingBackend = embeddingBackend;
        this.lock = new ReentrantLock();
        this.consumerToJobMap = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Replace to provide Flow API to get SplitInfo list", replaceWith=@ReplaceWith(expression="splitInfoList", imports={"androidx.window.embedding.SplitController"}))
    @ExperimentalWindowApi
    public final void addSplitListener(@NotNull Activity activity, @NotNull Executor executor, @NotNull Consumer<List<SplitInfo>> consumer) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.consumerToJobMap.get(consumer) != null) {
                return;
            }
            CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ExecutorsKt.from((Executor)executor)));
            this.consumerToJobMap.put(consumer, BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, activity, consumer, null){
                int label;
                final /* synthetic */ SplitController this$0;
                final /* synthetic */ Activity $activity;
                final /* synthetic */ Consumer<List<SplitInfo>> $consumer;
                {
                    this.this$0 = $receiver;
                    this.$activity = $activity;
                    this.$consumer = $consumer;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.splitInfoList(this.$activity).collect(new FlowCollector(this.$consumer){
                                final /* synthetic */ Consumer<List<SplitInfo>> $consumer;
                                {
                                    this.$consumer = $consumer;
                                }

                                @Nullable
                                public final Object emit(@NotNull List<SplitInfo> splitInfoList2, @NotNull Continuation<? super Unit> $completion) {
                                    this.$consumer.accept(splitInfoList2);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Replace to provide Flow API to get SplitInfo list", replaceWith=@ReplaceWith(expression="splitInfoList", imports={"androidx.window.embedding.SplitController"}))
    @ExperimentalWindowApi
    public final void removeSplitListener(@NotNull Consumer<List<SplitInfo>> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Job job = this.consumerToJobMap.get(consumer);
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            Job job2 = this.consumerToJobMap.remove(consumer);
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final Flow<List<SplitInfo>> splitInfoList(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super List<? extends SplitInfo>>, Continuation<? super Unit>, Object>(this, activity, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SplitController this$0;
            final /* synthetic */ Activity $activity;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Consumer listener = arg_0 -> splitInfoList.1.invokeSuspend$lambda$0($this$callbackFlow, arg_0);
                        SplitController.access$getEmbeddingBackend$p(this.this$0).addSplitListenerForActivity(this.$activity, Runnable::run, (Consumer<List<SplitInfo>>)listener);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0, (Consumer<List<SplitInfo>>)listener){
                            final /* synthetic */ SplitController this$0;
                            final /* synthetic */ Consumer<List<SplitInfo>> $listener;
                            {
                                this.this$0 = $receiver;
                                this.$listener = $listener;
                                super(0);
                            }

                            public final void invoke() {
                                SplitController.access$getEmbeddingBackend$p(this.this$0).removeSplitListenerForActivity(this.$listener);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super List<? extends SplitInfo>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super List<SplitInfo>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(ProducerScope $$this$callbackFlow, List info) {
                $$this$callbackFlow.trySend-JP2dKIU((Object)info);
            }
        }));
    }

    @Deprecated(message="Use splitSupportStatus instead", replaceWith=@ReplaceWith(expression="splitSupportStatus", imports={}))
    @ExperimentalWindowApi
    public final boolean isSplitSupported() {
        return Intrinsics.areEqual((Object)this.getSplitSupportStatus(), (Object)SplitSupportStatus.SPLIT_AVAILABLE);
    }

    @NotNull
    public final SplitSupportStatus getSplitSupportStatus() {
        return this.embeddingBackend.getSplitSupportStatus();
    }

    @ExperimentalWindowApi
    public final void setSplitAttributesCalculator(@NotNull Function1<? super SplitAttributesCalculatorParams, SplitAttributes> calculator) {
        Intrinsics.checkNotNullParameter(calculator, (String)"calculator");
        this.embeddingBackend.setSplitAttributesCalculator(calculator);
    }

    @ExperimentalWindowApi
    public final void clearSplitAttributesCalculator() {
        this.embeddingBackend.clearSplitAttributesCalculator();
    }

    @ExperimentalWindowApi
    public final boolean isSplitAttributesCalculatorSupported() {
        return this.embeddingBackend.isSplitAttributesCalculatorSupported();
    }

    @JvmStatic
    @NotNull
    public static final SplitController getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public static final /* synthetic */ EmbeddingBackend access$getEmbeddingBackend$p(SplitController $this) {
        return $this.embeddingBackend;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/window/embedding/SplitController$Companion;", "", "()V", "sDebug", "", "getInstance", "Landroidx/window/embedding/SplitController;", "context", "Landroid/content/Context;", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SplitController getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            EmbeddingBackend backend = EmbeddingBackend.Companion.getInstance(context);
            return new SplitController(backend);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/window/embedding/SplitController$SplitSupportStatus;", "", "rawValue", "", "(I)V", "toString", "", "Companion", "window_release"})
    public static final class SplitSupportStatus {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int rawValue;
        @JvmField
        @NotNull
        public static final SplitSupportStatus SPLIT_AVAILABLE = new SplitSupportStatus(0);
        @JvmField
        @NotNull
        public static final SplitSupportStatus SPLIT_UNAVAILABLE = new SplitSupportStatus(1);
        @JvmField
        @NotNull
        public static final SplitSupportStatus SPLIT_ERROR_PROPERTY_NOT_DECLARED = new SplitSupportStatus(2);

        private SplitSupportStatus(int rawValue) {
            this.rawValue = rawValue;
        }

        @NotNull
        public String toString() {
            String string;
            switch (this.rawValue) {
                case 0: {
                    string = "SplitSupportStatus: AVAILABLE";
                    break;
                }
                case 1: {
                    string = "SplitSupportStatus: UNAVAILABLE";
                    break;
                }
                case 2: {
                    string = "SplitSupportStatus: ERROR_SPLIT_PROPERTY_NOT_DECLARED";
                    break;
                }
                default: {
                    string = "UNKNOWN";
                }
            }
            return string;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/window/embedding/SplitController$SplitSupportStatus$Companion;", "", "()V", "SPLIT_AVAILABLE", "Landroidx/window/embedding/SplitController$SplitSupportStatus;", "SPLIT_ERROR_PROPERTY_NOT_DECLARED", "SPLIT_UNAVAILABLE", "window_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

