/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import androidx.annotation.XmlRes;
import androidx.window.R;
import androidx.window.embedding.ActivityFilter;
import androidx.window.embedding.ActivityRule;
import androidx.window.embedding.EmbeddingAspectRatio;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SplitAttributes;
import androidx.window.embedding.SplitPairFilter;
import androidx.window.embedding.SplitPairRule;
import androidx.window.embedding.SplitPlaceholderRule;
import androidx.window.embedding.SplitRule;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J'\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001d\u001a\u00020\u001e*\u0012\u0012\u0004\u0012\u00020\u00130\u001fj\b\u0012\u0004\u0012\u00020\u0013` 2\u0006\u0010!\u001a\u00020\u0013H\u0002\u00a8\u0006\""}, d2={"Landroidx/window/embedding/RuleParser;", "", "()V", "buildClassName", "Landroid/content/ComponentName;", "pkg", "", "clsSeq", "", "parseActivityFilter", "Landroidx/window/embedding/ActivityFilter;", "context", "Landroid/content/Context;", "parser", "Landroid/content/res/XmlResourceParser;", "parseActivityRule", "Landroidx/window/embedding/ActivityRule;", "parseRules", "", "Landroidx/window/embedding/EmbeddingRule;", "staticRuleResourceId", "", "parseRules$window_release", "parseSplitPairFilter", "Landroidx/window/embedding/SplitPairFilter;", "parseSplitPairRule", "Landroidx/window/embedding/SplitPairRule;", "parseSplitPlaceholderRule", "Landroidx/window/embedding/SplitPlaceholderRule;", "addRuleWithDuplicatedTagCheck", "", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "rule", "window_release"})
@SourceDebugExtension(value={"SMAP\nRuleParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleParser.kt\nandroidx/window/embedding/RuleParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1855#2,2:384\n*S KotlinDebug\n*F\n+ 1 RuleParser.kt\nandroidx/window/embedding/RuleParser\n*L\n123#1:384,2\n*E\n"})
public final class RuleParser {
    @NotNull
    public static final RuleParser INSTANCE = new RuleParser();

    private RuleParser() {
    }

    @Nullable
    public final Set<EmbeddingRule> parseRules$window_release(@NotNull Context context, @XmlRes int staticRuleResourceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        XmlResourceParser parser = null;
        try {
            XmlResourceParser xmlResourceParser = resources.getXml(staticRuleResourceId);
            Intrinsics.checkNotNullExpressionValue((Object)xmlResourceParser, (String)"resources.getXml(staticRuleResourceId)");
            parser = xmlResourceParser;
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
        HashSet<EmbeddingRule> rules = new HashSet<EmbeddingRule>();
        int depth = parser.getDepth();
        int type = parser.next();
        SplitPairRule lastSplitPairRule = null;
        SplitPlaceholderRule lastSplitPlaceholderRule = null;
        ActivityRule lastActivityRule = null;
        while (type != 1 && (type != 3 || parser.getDepth() > depth)) {
            block26: {
                if (parser.getEventType() != 2 || Intrinsics.areEqual((Object)"split-config", (Object)parser.getName())) {
                    type = parser.next();
                    continue;
                }
                String string = parser.getName();
                if (string == null) break block26;
                int n = -1;
                switch (string.hashCode()) {
                    case 520447504: {
                        if (string.equals("SplitPairRule")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2050988213: {
                        if (string.equals("SplitPlaceholderRule")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1793077963: {
                        if (string.equals("ActivityRule")) {
                            n = 3;
                        }
                        break;
                    }
                    case 511422343: {
                        if (string.equals("ActivityFilter")) {
                            n = 4;
                        }
                        break;
                    }
                    case 1579230604: {
                        if (string.equals("SplitPairFilter")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        SplitPairRule splitConfig;
                        lastSplitPairRule = splitConfig = this.parseSplitPairRule(context, parser);
                        this.addRuleWithDuplicatedTagCheck(rules, lastSplitPairRule);
                        lastSplitPlaceholderRule = null;
                        lastActivityRule = null;
                        break;
                    }
                    case 2: {
                        SplitPlaceholderRule placeholderConfig;
                        lastSplitPlaceholderRule = placeholderConfig = this.parseSplitPlaceholderRule(context, parser);
                        this.addRuleWithDuplicatedTagCheck(rules, lastSplitPlaceholderRule);
                        lastActivityRule = null;
                        lastSplitPairRule = null;
                        break;
                    }
                    case 5: {
                        if (lastSplitPairRule == null) {
                            throw new IllegalArgumentException("Found orphaned SplitPairFilter outside of SplitPairRule");
                        }
                        SplitPairFilter splitFilter = this.parseSplitPairFilter(context, parser);
                        rules.remove(lastSplitPairRule);
                        lastSplitPairRule = lastSplitPairRule.plus$window_release(splitFilter);
                        this.addRuleWithDuplicatedTagCheck(rules, lastSplitPairRule);
                        break;
                    }
                    case 3: {
                        ActivityRule activityConfig = this.parseActivityRule(context, parser);
                        this.addRuleWithDuplicatedTagCheck(rules, activityConfig);
                        lastSplitPairRule = null;
                        lastSplitPlaceholderRule = null;
                        lastActivityRule = activityConfig;
                        break;
                    }
                    case 4: {
                        if (lastActivityRule == null && lastSplitPlaceholderRule == null) {
                            throw new IllegalArgumentException("Found orphaned ActivityFilter");
                        }
                        ActivityFilter activityFilter = this.parseActivityFilter(context, parser);
                        if (lastActivityRule != null) {
                            rules.remove(lastActivityRule);
                            lastActivityRule = lastActivityRule.plus$window_release(activityFilter);
                            this.addRuleWithDuplicatedTagCheck(rules, lastActivityRule);
                            break;
                        }
                        if (lastSplitPlaceholderRule == null) break;
                        rules.remove(lastSplitPlaceholderRule);
                        lastSplitPlaceholderRule = lastSplitPlaceholderRule.plus$window_release(activityFilter);
                        this.addRuleWithDuplicatedTagCheck(rules, lastSplitPlaceholderRule);
                    }
                }
            }
            type = parser.next();
        }
        return rules;
    }

    private final void addRuleWithDuplicatedTagCheck(HashSet<EmbeddingRule> $this$addRuleWithDuplicatedTagCheck, EmbeddingRule rule) {
        String tag = rule.getTag();
        Iterable $this$forEach$iv = $this$addRuleWithDuplicatedTagCheck;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EmbeddingRule addedRule = (EmbeddingRule)element$iv;
            boolean bl = false;
            if (tag == null || !Intrinsics.areEqual((Object)tag, (Object)addedRule.getTag())) continue;
            throw new IllegalArgumentException("Duplicated tag: " + tag + " for " + rule + ". The tag must be unique in XML rule definition.");
        }
        $this$addRuleWithDuplicatedTagCheck.add(rule);
    }

    private final SplitPairRule parseSplitPairRule(Context context, XmlResourceParser parser) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.SplitPairRule, 0, 0);
        boolean bl = false;
        String tag = typedArray.getString(R.styleable.SplitPairRule_tag);
        float ratio2 = typedArray.getFloat(R.styleable.SplitPairRule_splitRatio, 0.5f);
        int minWidthDp = typedArray.getInteger(R.styleable.SplitPairRule_splitMinWidthDp, 600);
        int minHeightDp = typedArray.getInteger(R.styleable.SplitPairRule_splitMinHeightDp, 600);
        int minSmallestWidthDp = typedArray.getInteger(R.styleable.SplitPairRule_splitMinSmallestWidthDp, 600);
        float maxAspectRatioInPortrait = typedArray.getFloat(R.styleable.SplitPairRule_splitMaxAspectRatioInPortrait, SplitRule.SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT.getValue$window_release());
        float maxAspectRatioInLandscape = typedArray.getFloat(R.styleable.SplitPairRule_splitMaxAspectRatioInLandscape, SplitRule.SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT.getValue$window_release());
        int layoutDir = typedArray.getInt(R.styleable.SplitPairRule_splitLayoutDirection, SplitAttributes.LayoutDirection.LOCALE.getValue$window_release());
        int finishPrimaryWithSecondary = typedArray.getInt(R.styleable.SplitPairRule_finishPrimaryWithSecondary, SplitRule.FinishBehavior.NEVER.getValue$window_release());
        int finishSecondaryWithPrimary = typedArray.getInt(R.styleable.SplitPairRule_finishSecondaryWithPrimary, SplitRule.FinishBehavior.ALWAYS.getValue$window_release());
        boolean clearTop = typedArray.getBoolean(R.styleable.SplitPairRule_clearTop, false);
        SplitAttributes defaultAttrs = new SplitAttributes.Builder().setSplitType(SplitAttributes.SplitType.Companion.buildSplitTypeFromValue$window_release(ratio2)).setLayoutDirection(SplitAttributes.LayoutDirection.Companion.getLayoutDirectionFromValue$window_release(layoutDir)).build();
        return new SplitPairRule.Builder(SetsKt.emptySet()).setTag(tag).setMinWidthDp(minWidthDp).setMinHeightDp(minHeightDp).setMinSmallestWidthDp(minSmallestWidthDp).setMaxAspectRatioInPortrait(EmbeddingAspectRatio.Companion.buildAspectRatioFromValue$window_release(maxAspectRatioInPortrait)).setMaxAspectRatioInLandscape(EmbeddingAspectRatio.Companion.buildAspectRatioFromValue$window_release(maxAspectRatioInLandscape)).setFinishPrimaryWithSecondary(SplitRule.FinishBehavior.Companion.getFinishBehaviorFromValue$window_release(finishPrimaryWithSecondary)).setFinishSecondaryWithPrimary(SplitRule.FinishBehavior.Companion.getFinishBehaviorFromValue$window_release(finishSecondaryWithPrimary)).setClearTop(clearTop).setDefaultSplitAttributes(defaultAttrs).build();
    }

    private final SplitPlaceholderRule parseSplitPlaceholderRule(Context context, XmlResourceParser parser) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.SplitPlaceholderRule, 0, 0);
        boolean bl = false;
        String tag = typedArray.getString(R.styleable.SplitPlaceholderRule_tag);
        String placeholderActivityIntentName = typedArray.getString(R.styleable.SplitPlaceholderRule_placeholderActivityName);
        boolean stickyPlaceholder = typedArray.getBoolean(R.styleable.SplitPlaceholderRule_stickyPlaceholder, false);
        int finishPrimaryWithPlaceholder = typedArray.getInt(R.styleable.SplitPlaceholderRule_finishPrimaryWithPlaceholder, SplitRule.FinishBehavior.ALWAYS.getValue$window_release());
        if (finishPrimaryWithPlaceholder == SplitRule.FinishBehavior.NEVER.getValue$window_release()) {
            throw new IllegalArgumentException("Never is not a valid configuration for Placeholder activities. Please use FINISH_ALWAYS or FINISH_ADJACENT instead or refer to the current API");
        }
        float ratio2 = typedArray.getFloat(R.styleable.SplitPlaceholderRule_splitRatio, 0.5f);
        int minWidthDp = typedArray.getInteger(R.styleable.SplitPlaceholderRule_splitMinWidthDp, 600);
        int minHeightDp = typedArray.getInteger(R.styleable.SplitPlaceholderRule_splitMinHeightDp, 600);
        int minSmallestWidthDp = typedArray.getInteger(R.styleable.SplitPlaceholderRule_splitMinSmallestWidthDp, 600);
        float maxAspectRatioInPortrait = typedArray.getFloat(R.styleable.SplitPlaceholderRule_splitMaxAspectRatioInPortrait, SplitRule.SPLIT_MAX_ASPECT_RATIO_PORTRAIT_DEFAULT.getValue$window_release());
        float maxAspectRatioInLandscape = typedArray.getFloat(R.styleable.SplitPlaceholderRule_splitMaxAspectRatioInLandscape, SplitRule.SPLIT_MAX_ASPECT_RATIO_LANDSCAPE_DEFAULT.getValue$window_release());
        int layoutDir = typedArray.getInt(R.styleable.SplitPlaceholderRule_splitLayoutDirection, SplitAttributes.LayoutDirection.LOCALE.getValue$window_release());
        SplitAttributes defaultAttrs = new SplitAttributes.Builder().setSplitType(SplitAttributes.SplitType.Companion.buildSplitTypeFromValue$window_release(ratio2)).setLayoutDirection(SplitAttributes.LayoutDirection.Companion.getLayoutDirectionFromValue$window_release(layoutDir)).build();
        String packageName = context.getApplicationContext().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        ComponentName placeholderActivityClassName = INSTANCE.buildClassName(packageName, placeholderActivityIntentName);
        Set set = SetsKt.emptySet();
        Intent intent = new Intent().setComponent(placeholderActivityClassName);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent().setComponent(pl\u2026eholderActivityClassName)");
        return new SplitPlaceholderRule.Builder(set, intent).setTag(tag).setMinWidthDp(minWidthDp).setMinHeightDp(minHeightDp).setMinSmallestWidthDp(minSmallestWidthDp).setMaxAspectRatioInPortrait(EmbeddingAspectRatio.Companion.buildAspectRatioFromValue$window_release(maxAspectRatioInPortrait)).setMaxAspectRatioInLandscape(EmbeddingAspectRatio.Companion.buildAspectRatioFromValue$window_release(maxAspectRatioInLandscape)).setSticky(stickyPlaceholder).setFinishPrimaryWithPlaceholder(SplitRule.FinishBehavior.Companion.getFinishBehaviorFromValue$window_release(finishPrimaryWithPlaceholder)).setDefaultSplitAttributes(defaultAttrs).build();
    }

    private final SplitPairFilter parseSplitPairFilter(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        String primaryActivityName = null;
        String secondaryActivityIntentName = null;
        String secondaryActivityAction = null;
        TypedArray $this$parseSplitPairFilter_u24lambda_u243 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.SplitPairFilter, 0, 0);
        boolean bl = false;
        primaryActivityName = $this$parseSplitPairFilter_u24lambda_u243.getString(R.styleable.SplitPairFilter_primaryActivityName);
        secondaryActivityIntentName = $this$parseSplitPairFilter_u24lambda_u243.getString(R.styleable.SplitPairFilter_secondaryActivityName);
        secondaryActivityAction = $this$parseSplitPairFilter_u24lambda_u243.getString(R.styleable.SplitPairFilter_secondaryActivityAction);
        String packageName = context.getApplicationContext().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        ComponentName primaryActivityClassName = this.buildClassName(packageName, primaryActivityName);
        ComponentName secondaryActivityClassName = this.buildClassName(packageName, secondaryActivityIntentName);
        return new SplitPairFilter(primaryActivityClassName, secondaryActivityClassName, secondaryActivityAction);
    }

    private final ActivityRule parseActivityRule(Context context, XmlResourceParser parser) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.ActivityRule, 0, 0);
        boolean bl = false;
        String tag = typedArray.getString(R.styleable.ActivityRule_tag);
        boolean alwaysExpand = typedArray.getBoolean(R.styleable.ActivityRule_alwaysExpand, false);
        typedArray.recycle();
        ActivityRule.Builder builder = new ActivityRule.Builder(SetsKt.emptySet()).setAlwaysExpand(alwaysExpand);
        if (tag != null) {
            builder.setTag(tag);
        }
        return builder.build();
    }

    private final ActivityFilter parseActivityFilter(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        String activityName = null;
        String activityIntentAction = null;
        TypedArray $this$parseActivityFilter_u24lambda_u245 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.ActivityFilter, 0, 0);
        boolean bl = false;
        activityName = $this$parseActivityFilter_u24lambda_u245.getString(R.styleable.ActivityFilter_activityName);
        activityIntentAction = $this$parseActivityFilter_u24lambda_u245.getString(R.styleable.ActivityFilter_activityAction);
        String packageName = context.getApplicationContext().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        return new ActivityFilter(this.buildClassName(packageName, activityName), activityIntentAction);
    }

    private final ComponentName buildClassName(String pkg, CharSequence clsSeq) {
        CharSequence charSequence = clsSeq;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("Activity name must not be null");
        }
        String cls = ((Object)clsSeq).toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return new ComponentName(pkg, pkg + cls);
        }
        String pkgString = pkg;
        String clsString = cls;
        int pkgDividerIndex = StringsKt.indexOf$default((CharSequence)cls, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pkgDividerIndex > 0) {
            String string = cls.substring(0, pkgDividerIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            pkgString = string;
            String string2 = cls.substring(pkgDividerIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            clsString = string2;
        }
        if (!Intrinsics.areEqual((Object)clsString, (Object)"*") && StringsKt.indexOf$default((CharSequence)clsString, (char)'.', (int)0, (boolean)false, (int)6, null) < 0) {
            StringBuilder b = new StringBuilder(pkgString);
            b.append('.');
            b.append(clsString);
            return new ComponentName(pkgString, b.toString());
        }
        return new ComponentName(pkgString, clsString);
    }
}

