/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import androidx.window.core.ActivityComponentInfo;
import androidx.window.embedding.MatcherUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Landroidx/window/embedding/ActivityFilter;", "", "componentName", "Landroid/content/ComponentName;", "intentAction", "", "(Landroid/content/ComponentName;Ljava/lang/String;)V", "activityComponentInfo", "Landroidx/window/core/ActivityComponentInfo;", "(Landroidx/window/core/ActivityComponentInfo;Ljava/lang/String;)V", "getActivityComponentInfo$window_release", "()Landroidx/window/core/ActivityComponentInfo;", "getComponentName", "()Landroid/content/ComponentName;", "getIntentAction", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "matchesActivity", "activity", "Landroid/app/Activity;", "matchesIntent", "intent", "Landroid/content/Intent;", "toString", "window_release"})
public final class ActivityFilter {
    @NotNull
    private final ActivityComponentInfo activityComponentInfo;
    @Nullable
    private final String intentAction;

    public ActivityFilter(@NotNull ActivityComponentInfo activityComponentInfo, @Nullable String intentAction) {
        Intrinsics.checkNotNullParameter((Object)activityComponentInfo, (String)"activityComponentInfo");
        this.activityComponentInfo = activityComponentInfo;
        this.intentAction = intentAction;
        MatcherUtils.INSTANCE.validateComponentName$window_release(this.activityComponentInfo.getPackageName(), this.activityComponentInfo.getClassName());
    }

    @NotNull
    public final ActivityComponentInfo getActivityComponentInfo$window_release() {
        return this.activityComponentInfo;
    }

    @Nullable
    public final String getIntentAction() {
        return this.intentAction;
    }

    public ActivityFilter(@NotNull ComponentName componentName, @Nullable String intentAction) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this(new ActivityComponentInfo(componentName), intentAction);
    }

    public final boolean matchesIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        boolean match = !MatcherUtils.INSTANCE.isIntentMatching$window_release(intent, this.activityComponentInfo) ? false : this.intentAction == null || Intrinsics.areEqual((Object)this.intentAction, (Object)intent.getAction());
        return match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!MatcherUtils.INSTANCE.isActivityMatching$window_release(activity, this.activityComponentInfo)) return false;
        if (this.intentAction == null) return true;
        Intent intent = activity.getIntent();
        if (!Intrinsics.areEqual((Object)this.intentAction, (Object)(intent != null ? intent.getAction() : null))) return false;
        return true;
    }

    @NotNull
    public final ComponentName getComponentName() {
        return new ComponentName(this.activityComponentInfo.getPackageName(), this.activityComponentInfo.getClassName());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActivityFilter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.activityComponentInfo, (Object)((ActivityFilter)other).activityComponentInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.intentAction, (Object)((ActivityFilter)other).intentAction);
    }

    public int hashCode() {
        int result = this.activityComponentInfo.hashCode();
        String string = this.intentAction;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "ActivityFilter(componentName=" + this.activityComponentInfo + ", intentAction=" + this.intentAction + ')';
    }
}

