/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.CheckResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000eJ4\u0010\u000f\u001a\u00020\u0001\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0013\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012JJ\u0010\u0013\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000eJT\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000eH\u0007JT\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000eH\u0007JL\u0010\u001c\u001a\u00020\u0018\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000eH\u0007J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/window/core/ConsumerAdapter;", "", "loader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "addConsumer", "", "T", "obj", "clazz", "Lkotlin/reflect/KClass;", "methodName", "", "consumer", "Lkotlin/Function1;", "buildConsumer", "consumerClassOrNull", "Ljava/lang/Class;", "consumerClassOrNull$window_release", "createConsumer", "addMethodName", "activity", "Landroid/app/Activity;", "createSubscription", "Landroidx/window/core/ConsumerAdapter$Subscription;", "removeMethodName", "context", "Landroid/content/Context;", "createSubscriptionNoActivity", "unsafeConsumerClass", "ConsumerHandler", "Subscription", "window_release"})
@SuppressLint(value={"BanUncheckedReflection"})
public final class ConsumerAdapter {
    @NotNull
    private final ClassLoader loader;

    public ConsumerAdapter(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.loader = loader;
    }

    @Nullable
    public final Class<?> consumerClassOrNull$window_release() {
        Class<?> clazz;
        try {
            clazz = this.unsafeConsumerClass();
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        return clazz;
    }

    private final Class<?> unsafeConsumerClass() {
        Class<?> clazz = this.loader.loadClass("java.util.function.Consumer");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(\"java.util.function.Consumer\")");
        return clazz;
    }

    private final <T> Object buildConsumer(KClass<T> clazz, Function1<? super T, Unit> consumer) {
        ConsumerHandler<? super T> handler = new ConsumerHandler<T>(clazz, consumer);
        Class[] classArray = new Class[]{this.unsafeConsumerClass()};
        Object object = Proxy.newProxyInstance(this.loader, classArray, (InvocationHandler)handler);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newProxyInstance(loader,\u2026onsumerClass()), handler)");
        return object;
    }

    public final <T> void addConsumer(@NotNull Object obj, @NotNull KClass<T> clazz, @NotNull String methodName, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object[] objectArray = new Class[]{this.unsafeConsumerClass()};
        Method method = obj.getClass().getMethod(methodName, (Class<?>[])objectArray);
        objectArray = new Object[]{this.buildConsumer(clazz, consumer)};
        method.invoke(obj, objectArray);
    }

    @CheckResult
    @NotNull
    public final <T> Subscription createSubscription(@NotNull Object obj, @NotNull KClass<T> clazz, @NotNull String addMethodName, @NotNull String removeMethodName, @NotNull Activity activity, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)addMethodName, (String)"addMethodName");
        Intrinsics.checkNotNullParameter((Object)removeMethodName, (String)"removeMethodName");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object javaConsumer = this.buildConsumer(clazz, consumer);
        Object[] objectArray = new Class[]{Activity.class, this.unsafeConsumerClass()};
        Method method = obj.getClass().getMethod(addMethodName, (Class<?>[])objectArray);
        objectArray = new Object[]{activity, javaConsumer};
        method.invoke(obj, objectArray);
        Class[] classArray = new Class[]{this.unsafeConsumerClass()};
        Method removeMethod = obj.getClass().getMethod(removeMethodName, classArray);
        return new Subscription(removeMethod, obj, javaConsumer){
            final /* synthetic */ Method $removeMethod;
            final /* synthetic */ Object $obj;
            final /* synthetic */ Object $javaConsumer;
            {
                this.$removeMethod = $removeMethod;
                this.$obj = $obj;
                this.$javaConsumer = $javaConsumer;
            }

            public void dispose() {
                Object[] objectArray = new Object[]{this.$javaConsumer};
                this.$removeMethod.invoke(this.$obj, objectArray);
            }
        };
    }

    @CheckResult
    @NotNull
    public final <T> Subscription createSubscriptionNoActivity(@NotNull Object obj, @NotNull KClass<T> clazz, @NotNull String addMethodName, @NotNull String removeMethodName, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)addMethodName, (String)"addMethodName");
        Intrinsics.checkNotNullParameter((Object)removeMethodName, (String)"removeMethodName");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object javaConsumer = this.buildConsumer(clazz, consumer);
        Object[] objectArray = new Class[]{this.unsafeConsumerClass()};
        Method method = obj.getClass().getMethod(addMethodName, (Class<?>[])objectArray);
        objectArray = new Object[]{javaConsumer};
        method.invoke(obj, objectArray);
        Class[] classArray = new Class[]{this.unsafeConsumerClass()};
        Method removeMethod = obj.getClass().getMethod(removeMethodName, classArray);
        return new Subscription(removeMethod, obj, javaConsumer){
            final /* synthetic */ Method $removeMethod;
            final /* synthetic */ Object $obj;
            final /* synthetic */ Object $javaConsumer;
            {
                this.$removeMethod = $removeMethod;
                this.$obj = $obj;
                this.$javaConsumer = $javaConsumer;
            }

            public void dispose() {
                Object[] objectArray = new Object[]{this.$javaConsumer};
                this.$removeMethod.invoke(this.$obj, objectArray);
            }
        };
    }

    @CheckResult
    @NotNull
    public final <T> Subscription createSubscription(@NotNull Object obj, @NotNull KClass<T> clazz, @NotNull String addMethodName, @NotNull String removeMethodName, @NotNull Context context, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)addMethodName, (String)"addMethodName");
        Intrinsics.checkNotNullParameter((Object)removeMethodName, (String)"removeMethodName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object javaConsumer = this.buildConsumer(clazz, consumer);
        Object[] objectArray = new Class[]{Context.class, this.unsafeConsumerClass()};
        Method method = obj.getClass().getMethod(addMethodName, (Class<?>[])objectArray);
        objectArray = new Object[]{context, javaConsumer};
        method.invoke(obj, objectArray);
        Class[] classArray = new Class[]{this.unsafeConsumerClass()};
        Method removeMethod = obj.getClass().getMethod(removeMethodName, classArray);
        return new Subscription(removeMethod, obj, javaConsumer){
            final /* synthetic */ Method $removeMethod;
            final /* synthetic */ Object $obj;
            final /* synthetic */ Object $javaConsumer;
            {
                this.$removeMethod = $removeMethod;
                this.$obj = $obj;
                this.$javaConsumer = $javaConsumer;
            }

            public void dispose() {
                Object[] objectArray = new Object[]{this.$javaConsumer};
                this.$removeMethod.invoke(this.$obj, objectArray);
            }
        };
    }

    public final <T> void createConsumer(@NotNull Object obj, @NotNull KClass<T> clazz, @NotNull String addMethodName, @NotNull Activity activity, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)addMethodName, (String)"addMethodName");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object javaConsumer = this.buildConsumer(clazz, consumer);
        Object[] objectArray = new Class[]{Activity.class, this.unsafeConsumerClass()};
        Method method = obj.getClass().getMethod(addMethodName, (Class<?>[])objectArray);
        objectArray = new Object[]{activity, javaConsumer};
        method.invoke(obj, objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ0\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u00020\u0015*\u00020\r2\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u00020\u0015*\u00020\r2\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0019\u001a\u00020\u0015*\u00020\r2\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017J#\u0010\u001a\u001a\u00020\u0015*\u00020\r2\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/window/core/ConsumerAdapter$ConsumerHandler;", "T", "", "Ljava/lang/reflect/InvocationHandler;", "clazz", "Lkotlin/reflect/KClass;", "consumer", "Lkotlin/Function1;", "", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)V", "invoke", "obj", "method", "Ljava/lang/reflect/Method;", "parameters", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeAccept", "parameter", "(Ljava/lang/Object;)V", "isAccept", "", "args", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Z", "isEquals", "isHashCode", "isToString", "window_release"})
    private static final class ConsumerHandler<T>
    implements InvocationHandler {
        @NotNull
        private final KClass<T> clazz;
        @NotNull
        private final Function1<T, Unit> consumer;

        public ConsumerHandler(@NotNull KClass<T> clazz, @NotNull Function1<? super T, Unit> consumer) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.clazz = clazz;
            this.consumer = consumer;
        }

        @Override
        @NotNull
        public Object invoke(@NotNull Object obj, @NotNull Method method, @Nullable Object[] parameters) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (this.isAccept(method, parameters)) {
                Object argument = KClasses.cast(this.clazz, (Object)(parameters != null ? parameters[0] : null));
                this.invokeAccept(argument);
                object = Unit.INSTANCE;
            } else if (this.isEquals(method, parameters)) {
                object = obj == (parameters != null ? parameters[0] : null);
            } else if (this.isHashCode(method, parameters)) {
                object = this.consumer.hashCode();
            } else if (this.isToString(method, parameters)) {
                object = this.consumer.toString();
            } else {
                throw new UnsupportedOperationException("Unexpected method call object:" + obj + ", method: " + method + ", args: " + parameters);
            }
            return object;
        }

        public final void invokeAccept(@NotNull T parameter) {
            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
            this.consumer.invoke(parameter);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEquals(Method $this$isEquals, Object[] args) {
            if (!Intrinsics.areEqual((Object)$this$isEquals.getName(), (Object)"equals")) return false;
            if (!$this$isEquals.getReturnType().equals(Boolean.TYPE)) return false;
            if (args == null) return false;
            if (args.length != 1) return false;
            return true;
        }

        private final boolean isHashCode(Method $this$isHashCode, Object[] args) {
            return Intrinsics.areEqual((Object)$this$isHashCode.getName(), (Object)"hashCode") && $this$isHashCode.getReturnType().equals(Integer.TYPE) && args == null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAccept(Method $this$isAccept, Object[] args) {
            if (!Intrinsics.areEqual((Object)$this$isAccept.getName(), (Object)"accept")) return false;
            if (args == null) return false;
            if (args.length != 1) return false;
            return true;
        }

        private final boolean isToString(Method $this$isToString, Object[] args) {
            return Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)"toString") && $this$isToString.getReturnType().equals(String.class) && args == null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Landroidx/window/core/ConsumerAdapter$Subscription;", "", "dispose", "", "window_release"})
    public static interface Subscription {
        public void dispose();
    }
}

