/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core;

import android.content.ComponentName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0012"}, d2={"Landroidx/window/core/ActivityComponentInfo;", "", "componentName", "Landroid/content/ComponentName;", "(Landroid/content/ComponentName;)V", "packageName", "", "className", "(Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getPackageName", "equals", "", "other", "hashCode", "", "toString", "window_release"})
public final class ActivityComponentInfo {
    @NotNull
    private final String packageName;
    @NotNull
    private final String className;

    public ActivityComponentInfo(@NotNull String packageName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.packageName = packageName;
        this.className = className;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public ActivityComponentInfo(@NotNull ComponentName componentName) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        String string = componentName.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentName.packageName");
        String string2 = componentName.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"componentName.className");
        this(string, string2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.window.core.ActivityComponentInfo");
        ActivityComponentInfo cfr_ignored_0 = (ActivityComponentInfo)other;
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)((ActivityComponentInfo)other).packageName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.className, (Object)((ActivityComponentInfo)other).className);
    }

    public int hashCode() {
        int result = this.packageName.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "ClassInfo { packageName: " + this.packageName + ", className: " + this.className + " }";
    }
}

