/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transformation;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.animation.Positioning;
import com.google.android.material.transformation.FabTransformationBehavior;
import com.google.android.material.transformation.FabTransformationScrimBehavior;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class FabTransformationSheetBehavior
extends FabTransformationBehavior {
    @Nullable
    private Map<View, Integer> importantForAccessibilityMap;

    public FabTransformationSheetBehavior() {
    }

    public FabTransformationSheetBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @NonNull
    protected FabTransformationBehavior.FabTransformationSpec onCreateMotionSpec(Context context, boolean expanded) {
        int specRes = expanded ? R.animator.mtrl_fab_transformation_sheet_expand_spec : R.animator.mtrl_fab_transformation_sheet_collapse_spec;
        FabTransformationBehavior.FabTransformationSpec spec = new FabTransformationBehavior.FabTransformationSpec();
        spec.timings = MotionSpec.createFromResource(context, specRes);
        spec.positioning = new Positioning(17, 0.0f, 0.0f);
        return spec;
    }

    @Override
    @CallSuper
    protected boolean onExpandedStateChange(@NonNull View dependency, @NonNull View child, boolean expanded, boolean animated) {
        this.updateImportantForAccessibility(child, expanded);
        return super.onExpandedStateChange(dependency, child, expanded, animated);
    }

    private void updateImportantForAccessibility(@NonNull View sheet, boolean expanded) {
        ViewParent viewParent = sheet.getParent();
        if (!(viewParent instanceof CoordinatorLayout)) {
            return;
        }
        CoordinatorLayout parent = (CoordinatorLayout)viewParent;
        int childCount = parent.getChildCount();
        if (Build.VERSION.SDK_INT >= 16 && expanded) {
            this.importantForAccessibilityMap = new HashMap<View, Integer>(childCount);
        }
        for (int i = 0; i < childCount; ++i) {
            boolean hasScrimBehavior;
            View child = parent.getChildAt(i);
            boolean bl = hasScrimBehavior = child.getLayoutParams() instanceof CoordinatorLayout.LayoutParams && ((CoordinatorLayout.LayoutParams)child.getLayoutParams()).getBehavior() instanceof FabTransformationScrimBehavior;
            if (child == sheet || hasScrimBehavior) continue;
            if (!expanded) {
                if (this.importantForAccessibilityMap == null || !this.importantForAccessibilityMap.containsKey(child)) continue;
                ViewCompat.setImportantForAccessibility((View)child, (int)this.importantForAccessibilityMap.get(child));
                continue;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.importantForAccessibilityMap.put(child, child.getImportantForAccessibility());
            }
            ViewCompat.setImportantForAccessibility((View)child, (int)4);
        }
        if (!expanded) {
            this.importantForAccessibilityMap = null;
        }
    }
}

