/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.text.Editable;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.textfield.EndCompoundLayout;
import com.google.android.material.textfield.EndIconDelegate;

class ClearTextEndIconDelegate
extends EndIconDelegate {
    private static final int DEFAULT_ANIMATION_FADE_DURATION = 100;
    private static final int DEFAULT_ANIMATION_SCALE_DURATION = 150;
    private static final float ANIMATION_SCALE_FROM_VALUE = 0.8f;
    private final int animationFadeDuration;
    private final int animationScaleDuration;
    @NonNull
    private final TimeInterpolator animationFadeInterpolator;
    @NonNull
    private final TimeInterpolator animationScaleInterpolator;
    @Nullable
    private EditText editText;
    private final View.OnClickListener onIconClickListener = view -> {
        if (this.editText == null) {
            return;
        }
        Editable text = this.editText.getText();
        if (text != null) {
            text.clear();
        }
        this.refreshIconState();
    };
    private final View.OnFocusChangeListener onFocusChangeListener = (view, hasFocus) -> this.animateIcon(this.shouldBeVisible());
    private AnimatorSet iconInAnim;
    private ValueAnimator iconOutAnim;

    ClearTextEndIconDelegate(@NonNull EndCompoundLayout endLayout) {
        super(endLayout);
        this.animationFadeDuration = MotionUtils.resolveThemeDuration(endLayout.getContext(), R.attr.motionDurationShort3, 100);
        this.animationScaleDuration = MotionUtils.resolveThemeDuration(endLayout.getContext(), R.attr.motionDurationShort3, 150);
        this.animationFadeInterpolator = MotionUtils.resolveThemeInterpolator(endLayout.getContext(), R.attr.motionEasingLinearInterpolator, AnimationUtils.LINEAR_INTERPOLATOR);
        this.animationScaleInterpolator = MotionUtils.resolveThemeInterpolator(endLayout.getContext(), R.attr.motionEasingEmphasizedInterpolator, AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
    }

    @Override
    void setUp() {
        this.initAnimators();
    }

    @Override
    void tearDown() {
        if (this.editText != null) {
            this.editText.post(() -> this.animateIcon(true));
        }
    }

    @Override
    int getIconDrawableResId() {
        return R.drawable.mtrl_ic_cancel;
    }

    @Override
    int getIconContentDescriptionResId() {
        return R.string.clear_text_end_icon_content_description;
    }

    @Override
    void onSuffixVisibilityChanged(boolean visible) {
        if (this.endLayout.getSuffixText() == null) {
            return;
        }
        this.animateIcon(visible);
    }

    @Override
    View.OnClickListener getOnIconClickListener() {
        return this.onIconClickListener;
    }

    @Override
    public void onEditTextAttached(@Nullable EditText editText) {
        this.editText = editText;
        this.textInputLayout.setEndIconVisible(this.shouldBeVisible());
    }

    @Override
    void afterEditTextChanged(@NonNull Editable s) {
        if (this.endLayout.getSuffixText() != null) {
            return;
        }
        this.animateIcon(this.shouldBeVisible());
    }

    @Override
    View.OnFocusChangeListener getOnEditTextFocusChangeListener() {
        return this.onFocusChangeListener;
    }

    @Override
    View.OnFocusChangeListener getOnIconViewFocusChangeListener() {
        return this.onFocusChangeListener;
    }

    private void animateIcon(boolean show) {
        boolean shouldSkipAnimation;
        boolean bl = shouldSkipAnimation = this.endLayout.isEndIconVisible() == show;
        if (show && !this.iconInAnim.isRunning()) {
            this.iconOutAnim.cancel();
            this.iconInAnim.start();
            if (shouldSkipAnimation) {
                this.iconInAnim.end();
            }
        } else if (!show) {
            this.iconInAnim.cancel();
            this.iconOutAnim.start();
            if (shouldSkipAnimation) {
                this.iconOutAnim.end();
            }
        }
    }

    private void initAnimators() {
        ValueAnimator scaleAnimator = this.getScaleAnimator();
        ValueAnimator fadeAnimator = this.getAlphaAnimator(0.0f, 1.0f);
        this.iconInAnim = new AnimatorSet();
        this.iconInAnim.playTogether(new Animator[]{scaleAnimator, fadeAnimator});
        this.iconInAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ClearTextEndIconDelegate.this.endLayout.setEndIconVisible(true);
            }
        });
        this.iconOutAnim = this.getAlphaAnimator(1.0f, 0.0f);
        this.iconOutAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ClearTextEndIconDelegate.this.endLayout.setEndIconVisible(false);
            }
        });
    }

    private ValueAnimator getAlphaAnimator(float ... values) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])values);
        animator2.setInterpolator(this.animationFadeInterpolator);
        animator2.setDuration((long)this.animationFadeDuration);
        animator2.addUpdateListener(animation -> {
            float alpha = ((Float)animation.getAnimatedValue()).floatValue();
            this.endIconView.setAlpha(alpha);
        });
        return animator2;
    }

    private ValueAnimator getScaleAnimator() {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.8f, 1.0f});
        animator2.setInterpolator(this.animationScaleInterpolator);
        animator2.setDuration((long)this.animationScaleDuration);
        animator2.addUpdateListener(animation -> {
            float scale = ((Float)animation.getAnimatedValue()).floatValue();
            this.endIconView.setScaleX(scale);
            this.endIconView.setScaleY(scale);
        });
        return animator2;
    }

    private boolean shouldBeVisible() {
        return this.editText != null && (this.editText.hasFocus() || this.endIconView.hasFocus()) && this.editText.getText().length() > 0;
    }
}

