/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.sidesheet;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.customview.widget.ViewDragHelper;
import com.google.android.material.sidesheet.SheetDelegate;
import com.google.android.material.sidesheet.SheetUtils;
import com.google.android.material.sidesheet.SideSheetBehavior;

final class RightSheetDelegate
extends SheetDelegate {
    final SideSheetBehavior<? extends View> sheetBehavior;

    RightSheetDelegate(@NonNull SideSheetBehavior<? extends View> sheetBehavior) {
        this.sheetBehavior = sheetBehavior;
    }

    @Override
    int getSheetEdge() {
        return 0;
    }

    @Override
    int getHiddenOffset() {
        return this.sheetBehavior.getParentWidth();
    }

    @Override
    int getExpandedOffset() {
        return Math.max(0, this.getHiddenOffset() - this.sheetBehavior.getChildWidth() - this.sheetBehavior.getInnerMargin());
    }

    private boolean isReleasedCloseToOriginEdge(@NonNull View releasedChild) {
        return releasedChild.getLeft() > (this.getHiddenOffset() - this.getExpandedOffset()) / 2;
    }

    @Override
    int calculateTargetStateOnViewReleased(@NonNull View releasedChild, float xVelocity, float yVelocity) {
        int currentLeft;
        int targetState = xVelocity < 0.0f ? 3 : (this.shouldHide(releasedChild, xVelocity) ? (this.isSwipeSignificant(xVelocity, yVelocity) || this.isReleasedCloseToOriginEdge(releasedChild) ? 5 : 3) : (xVelocity == 0.0f || !SheetUtils.isSwipeMostlyHorizontal(xVelocity, yVelocity) ? (Math.abs((currentLeft = releasedChild.getLeft()) - this.getExpandedOffset()) < Math.abs(currentLeft - this.getHiddenOffset()) ? 3 : 5) : 5));
        return targetState;
    }

    private boolean isSwipeSignificant(float xVelocity, float yVelocity) {
        return SheetUtils.isSwipeMostlyHorizontal(xVelocity, yVelocity) && yVelocity > (float)this.sheetBehavior.getSignificantVelocityThreshold();
    }

    @Override
    boolean shouldHide(@NonNull View child, float velocity) {
        float newRight = (float)child.getRight() + velocity * this.sheetBehavior.getHideFriction();
        return Math.abs(newRight) > this.sheetBehavior.getHideThreshold();
    }

    @Override
    boolean isSettling(View child, int state, boolean isReleasingView) {
        int left = this.sheetBehavior.getOuterEdgeOffsetForState(state);
        ViewDragHelper viewDragHelper = this.sheetBehavior.getViewDragHelper();
        return viewDragHelper != null && (isReleasingView ? viewDragHelper.settleCapturedViewAt(left, child.getTop()) : viewDragHelper.smoothSlideViewTo(child, left, child.getTop()));
    }

    @Override
    <V extends View> int getOuterEdge(@NonNull V child) {
        return child.getLeft() - this.sheetBehavior.getInnerMargin();
    }

    @Override
    float calculateSlideOffset(int left) {
        float hiddenOffset = this.getHiddenOffset();
        float sheetWidth = hiddenOffset - (float)this.getExpandedOffset();
        return (hiddenOffset - (float)left) / sheetWidth;
    }

    @Override
    void updateCoplanarSiblingLayoutParams(@NonNull ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams, int sheetLeft, int sheetRight) {
        int parentWidth = this.sheetBehavior.getParentWidth();
        if (sheetLeft <= parentWidth) {
            coplanarSiblingLayoutParams.rightMargin = parentWidth - sheetLeft;
        }
    }

    @Override
    int calculateInnerMargin(@NonNull ViewGroup.MarginLayoutParams marginLayoutParams) {
        return marginLayoutParams.rightMargin;
    }
}

