/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.ripple;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.Log;
import android.util.StateSet;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.ColorInt;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RippleUtils {
    @ChecksSdkIntAtLeast(api=21)
    public static final boolean USE_FRAMEWORK_RIPPLE = Build.VERSION.SDK_INT >= 21;
    private static final int[] PRESSED_STATE_SET = new int[]{16842919};
    private static final int[] HOVERED_FOCUSED_STATE_SET = new int[]{16843623, 16842908};
    private static final int[] FOCUSED_STATE_SET = new int[]{16842908};
    private static final int[] HOVERED_STATE_SET = new int[]{16843623};
    private static final int[] SELECTED_PRESSED_STATE_SET = new int[]{0x10100A1, 16842919};
    private static final int[] SELECTED_HOVERED_FOCUSED_STATE_SET = new int[]{0x10100A1, 16843623, 16842908};
    private static final int[] SELECTED_FOCUSED_STATE_SET = new int[]{0x10100A1, 16842908};
    private static final int[] SELECTED_HOVERED_STATE_SET = new int[]{0x10100A1, 16843623};
    private static final int[] SELECTED_STATE_SET = new int[]{0x10100A1};
    private static final int[] ENABLED_PRESSED_STATE_SET = new int[]{16842910, 16842919};
    @VisibleForTesting
    static final String LOG_TAG = RippleUtils.class.getSimpleName();
    @VisibleForTesting
    static final String TRANSPARENT_DEFAULT_COLOR_WARNING = "Use a non-transparent color for the default color as it will be used to finish ripple animations.";

    private RippleUtils() {
    }

    @NonNull
    public static ColorStateList convertToRippleDrawableColor(@Nullable ColorStateList rippleColor) {
        if (USE_FRAMEWORK_RIPPLE) {
            int size = 3;
            int[][] states = new int[size][];
            int[] colors = new int[size];
            int i = 0;
            states[i] = SELECTED_STATE_SET;
            colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_PRESSED_STATE_SET);
            states[++i] = FOCUSED_STATE_SET;
            colors[i] = RippleUtils.getColorForState(rippleColor, FOCUSED_STATE_SET);
            states[++i] = StateSet.NOTHING;
            colors[i] = RippleUtils.getColorForState(rippleColor, PRESSED_STATE_SET);
            ++i;
            return new ColorStateList((int[][])states, colors);
        }
        int size = 10;
        int[][] states = new int[size][];
        int[] colors = new int[size];
        int i = 0;
        states[i] = SELECTED_PRESSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_PRESSED_STATE_SET);
        states[++i] = SELECTED_HOVERED_FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_HOVERED_FOCUSED_STATE_SET);
        states[++i] = SELECTED_FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_FOCUSED_STATE_SET);
        states[++i] = SELECTED_HOVERED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_HOVERED_STATE_SET);
        states[++i] = SELECTED_STATE_SET;
        colors[i] = 0;
        states[++i] = PRESSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, PRESSED_STATE_SET);
        states[++i] = HOVERED_FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, HOVERED_FOCUSED_STATE_SET);
        states[++i] = FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, FOCUSED_STATE_SET);
        states[++i] = HOVERED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, HOVERED_STATE_SET);
        states[++i] = StateSet.NOTHING;
        colors[i] = 0;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    @NonNull
    public static ColorStateList sanitizeRippleDrawableColor(@Nullable ColorStateList rippleColor) {
        if (rippleColor != null) {
            if (Build.VERSION.SDK_INT >= 22 && Build.VERSION.SDK_INT <= 27 && Color.alpha((int)rippleColor.getDefaultColor()) == 0 && Color.alpha((int)rippleColor.getColorForState(ENABLED_PRESSED_STATE_SET, 0)) != 0) {
                Log.w((String)LOG_TAG, (String)TRANSPARENT_DEFAULT_COLOR_WARNING);
            }
            return rippleColor;
        }
        return ColorStateList.valueOf((int)0);
    }

    public static boolean shouldDrawRippleCompat(@NonNull int[] stateSet) {
        boolean enabled = false;
        boolean interactedState = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
                continue;
            }
            if (state == 16842908) {
                interactedState = true;
                continue;
            }
            if (state == 16842919) {
                interactedState = true;
                continue;
            }
            if (state != 16843623) continue;
            interactedState = true;
        }
        return enabled && interactedState;
    }

    @RequiresApi(value=21)
    @NonNull
    public static Drawable createOvalRippleLollipop(@NonNull Context context, @Px int padding) {
        return RippleUtilsLollipop.createOvalRipple(context, padding);
    }

    @ColorInt
    private static int getColorForState(@Nullable ColorStateList rippleColor, int[] state) {
        int color2 = rippleColor != null ? rippleColor.getColorForState(state, rippleColor.getDefaultColor()) : 0;
        return USE_FRAMEWORK_RIPPLE ? RippleUtils.doubleAlpha(color2) : color2;
    }

    @ColorInt
    @TargetApi(value=21)
    private static int doubleAlpha(@ColorInt int color2) {
        int alpha = Math.min(2 * Color.alpha((int)color2), 255);
        return ColorUtils.setAlphaComponent((int)color2, (int)alpha);
    }

    @RequiresApi(value=21)
    private static class RippleUtilsLollipop {
        private RippleUtilsLollipop() {
        }

        @DoNotInline
        private static Drawable createOvalRipple(@NonNull Context context, @Px int padding) {
            GradientDrawable maskDrawable = new GradientDrawable();
            maskDrawable.setColor(-1);
            maskDrawable.setShape(1);
            InsetDrawable maskWithPaddings = new InsetDrawable((Drawable)maskDrawable, padding, padding, padding, padding);
            return new RippleDrawable(MaterialColors.getColorStateList(context, R.attr.colorControlHighlight, ColorStateList.valueOf((int)0)), null, (Drawable)maskWithPaddings);
        }
    }
}

