/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import androidx.annotation.NonNull;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularDrawingDelegate;
import com.google.android.material.progressindicator.CircularIndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.LinearDrawingDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateContiguousAnimatorDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateDisjointAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

public final class IndeterminateDrawable<S extends BaseProgressIndicatorSpec>
extends DrawableWithAnimatedVisibilityChange {
    private DrawingDelegate<S> drawingDelegate;
    private IndeterminateAnimatorDelegate<ObjectAnimator> animatorDelegate;

    IndeterminateDrawable(@NonNull Context context, @NonNull BaseProgressIndicatorSpec baseSpec, @NonNull DrawingDelegate<S> drawingDelegate, @NonNull IndeterminateAnimatorDelegate<ObjectAnimator> animatorDelegate) {
        super(context, baseSpec);
        this.setDrawingDelegate(drawingDelegate);
        this.setAnimatorDelegate(animatorDelegate);
    }

    @NonNull
    public static IndeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec) {
        return new IndeterminateDrawable<LinearProgressIndicatorSpec>(context, spec, new LinearDrawingDelegate(spec), spec.indeterminateAnimationType == 0 ? new LinearIndeterminateContiguousAnimatorDelegate(spec) : new LinearIndeterminateDisjointAnimatorDelegate(context, spec));
    }

    @NonNull
    public static IndeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(@NonNull Context context, @NonNull CircularProgressIndicatorSpec spec) {
        return new IndeterminateDrawable<CircularProgressIndicatorSpec>(context, spec, new CircularDrawingDelegate(spec), new CircularIndeterminateAnimatorDelegate(spec));
    }

    @Override
    boolean setVisibleInternal(boolean visible, boolean restart, boolean animate) {
        boolean changed = super.setVisibleInternal(visible, restart, animate);
        if (!this.isRunning()) {
            this.animatorDelegate.cancelAnimatorImmediately();
        }
        float systemAnimatorDurationScale = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
        if (visible && (animate || Build.VERSION.SDK_INT <= 22 && systemAnimatorDurationScale > 0.0f)) {
            this.animatorDelegate.startAnimator();
        }
        return changed;
    }

    public int getIntrinsicWidth() {
        return this.drawingDelegate.getPreferredWidth();
    }

    public int getIntrinsicHeight() {
        return this.drawingDelegate.getPreferredHeight();
    }

    public void draw(@NonNull Canvas canvas) {
        Rect clipBounds = new Rect();
        if (this.getBounds().isEmpty() || !this.isVisible() || !canvas.getClipBounds(clipBounds)) {
            return;
        }
        canvas.save();
        this.drawingDelegate.validateSpecAndAdjustCanvas(canvas, this.getBounds(), this.getGrowFraction());
        this.drawingDelegate.fillTrack(canvas, this.paint);
        for (int segmentIndex = 0; segmentIndex < this.animatorDelegate.segmentColors.length; ++segmentIndex) {
            this.drawingDelegate.fillIndicator(canvas, this.paint, this.animatorDelegate.segmentPositions[2 * segmentIndex], this.animatorDelegate.segmentPositions[2 * segmentIndex + 1], this.animatorDelegate.segmentColors[segmentIndex]);
        }
        canvas.restore();
    }

    @NonNull
    IndeterminateAnimatorDelegate<ObjectAnimator> getAnimatorDelegate() {
        return this.animatorDelegate;
    }

    void setAnimatorDelegate(@NonNull IndeterminateAnimatorDelegate<ObjectAnimator> animatorDelegate) {
        this.animatorDelegate = animatorDelegate;
        animatorDelegate.registerDrawable(this);
    }

    @NonNull
    DrawingDelegate<S> getDrawingDelegate() {
        return this.drawingDelegate;
    }

    void setDrawingDelegate(@NonNull DrawingDelegate<S> drawingDelegate) {
        this.drawingDelegate = drawingDelegate;
        drawingDelegate.registerDrawable(this);
    }
}

