/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.view.MenuItem;
import android.view.SubMenu;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NavigationBarMenu
extends MenuBuilder {
    @NonNull
    private final Class<?> viewClass;
    private final int maxItemCount;

    public NavigationBarMenu(@NonNull Context context, @NonNull Class<?> viewClass, int maxItemCount) {
        super(context);
        this.viewClass = viewClass;
        this.maxItemCount = maxItemCount;
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    @NonNull
    public SubMenu addSubMenu(int group, int id2, int categoryOrder, @NonNull CharSequence title) {
        throw new UnsupportedOperationException(this.viewClass.getSimpleName() + " does not support submenus");
    }

    @NonNull
    protected MenuItem addInternal(int group, int id2, int categoryOrder, @NonNull CharSequence title) {
        if (this.size() + 1 > this.maxItemCount) {
            String viewClassName = this.viewClass.getSimpleName();
            throw new IllegalArgumentException("Maximum number of items supported by " + viewClassName + " is " + this.maxItemCount + ". Limit can be checked with " + viewClassName + "#getMaxItemCount()");
        }
        this.stopDispatchingItemsChanged();
        MenuItem item = super.addInternal(group, id2, categoryOrder, title);
        if (item instanceof MenuItemImpl) {
            ((MenuItemImpl)item).setExclusiveCheckable(true);
        }
        this.startDispatchingItemsChanged();
        return item;
    }
}

