/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ToolbarUtils {
    private static final Comparator<View> VIEW_TOP_COMPARATOR = new Comparator<View>(){

        @Override
        public int compare(View view1, View view2) {
            return view1.getTop() - view2.getTop();
        }
    };

    private ToolbarUtils() {
    }

    @Nullable
    public static TextView getTitleTextView(@NonNull Toolbar toolbar) {
        List<TextView> textViews = ToolbarUtils.getTextViewsWithText(toolbar, toolbar.getTitle());
        return textViews.isEmpty() ? null : (TextView)Collections.min(textViews, VIEW_TOP_COMPARATOR);
    }

    @Nullable
    public static TextView getSubtitleTextView(@NonNull Toolbar toolbar) {
        List<TextView> textViews = ToolbarUtils.getTextViewsWithText(toolbar, toolbar.getSubtitle());
        return textViews.isEmpty() ? null : (TextView)Collections.max(textViews, VIEW_TOP_COMPARATOR);
    }

    private static List<TextView> getTextViewsWithText(@NonNull Toolbar toolbar, CharSequence text) {
        ArrayList<TextView> textViews = new ArrayList<TextView>();
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            TextView textView;
            View child = toolbar.getChildAt(i);
            if (!(child instanceof TextView) || !TextUtils.equals((CharSequence)(textView = (TextView)child).getText(), (CharSequence)text)) continue;
            textViews.add(textView);
        }
        return textViews;
    }

    @Nullable
    public static ImageView getLogoImageView(@NonNull Toolbar toolbar) {
        return ToolbarUtils.getImageView(toolbar, toolbar.getLogo());
    }

    @Nullable
    private static ImageView getImageView(@NonNull Toolbar toolbar, @Nullable Drawable content) {
        if (content == null) {
            return null;
        }
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            ImageView imageView;
            Drawable drawable2;
            View child = toolbar.getChildAt(i);
            if (!(child instanceof ImageView) || (drawable2 = (imageView = (ImageView)child).getDrawable()) == null || drawable2.getConstantState() == null || !drawable2.getConstantState().equals(content.getConstantState())) continue;
            return imageView;
        }
        return null;
    }

    @Nullable
    public static View getSecondaryActionMenuItemView(@NonNull Toolbar toolbar) {
        ActionMenuView actionMenuView = ToolbarUtils.getActionMenuView(toolbar);
        if (actionMenuView != null && actionMenuView.getChildCount() > 1) {
            return actionMenuView.getChildAt(0);
        }
        return null;
    }

    @Nullable
    public static ActionMenuView getActionMenuView(@NonNull Toolbar toolbar) {
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            View child = toolbar.getChildAt(i);
            if (!(child instanceof ActionMenuView)) continue;
            return (ActionMenuView)child;
        }
        return null;
    }

    @Nullable
    public static ImageButton getNavigationIconButton(@NonNull Toolbar toolbar) {
        Drawable navigationIcon = toolbar.getNavigationIcon();
        if (navigationIcon == null) {
            return null;
        }
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            ImageButton imageButton;
            View child = toolbar.getChildAt(i);
            if (!(child instanceof ImageButton) || (imageButton = (ImageButton)child).getDrawable() != navigationIcon) continue;
            return imageButton;
        }
        return null;
    }

    @Nullable
    public static ActionMenuItemView getActionMenuItemView(@NonNull Toolbar toolbar, @IdRes int menuItemId) {
        ActionMenuView actionMenuView = ToolbarUtils.getActionMenuView(toolbar);
        if (actionMenuView != null) {
            for (int i = 0; i < actionMenuView.getChildCount(); ++i) {
                ActionMenuItemView actionMenuItemView;
                View child = actionMenuView.getChildAt(i);
                if (!(child instanceof ActionMenuItemView) || (actionMenuItemView = (ActionMenuItemView)child).getItemData().getItemId() != menuItemId) continue;
                return actionMenuItemView;
            }
        }
        return null;
    }
}

