/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.R;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ForegroundLinearLayout;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NavigationMenuItemView
extends ForegroundLinearLayout
implements MenuView.ItemView {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private int iconSize;
    private boolean needsEmptyIcon;
    boolean checkable;
    private final CheckedTextView textView;
    private FrameLayout actionArea;
    private MenuItemImpl itemData;
    private ColorStateList iconTintList;
    private boolean hasIconTintList;
    private Drawable emptyDrawable;
    private final AccessibilityDelegateCompat accessibilityDelegate = new AccessibilityDelegateCompat(){

        public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setCheckable(NavigationMenuItemView.this.checkable);
        }
    };

    public NavigationMenuItemView(@NonNull Context context) {
        this(context, null);
    }

    public NavigationMenuItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NavigationMenuItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.design_navigation_menu_item, (ViewGroup)this, true);
        this.setIconSize(context.getResources().getDimensionPixelSize(R.dimen.design_navigation_icon_size));
        this.textView = (CheckedTextView)this.findViewById(R.id.design_menu_item_text);
        this.textView.setDuplicateParentStateEnabled(true);
        ViewCompat.setAccessibilityDelegate((View)this.textView, (AccessibilityDelegateCompat)this.accessibilityDelegate);
    }

    public void initialize(@NonNull MenuItemImpl itemData, int menuType) {
        this.itemData = itemData;
        if (itemData.getItemId() > 0) {
            this.setId(itemData.getItemId());
        }
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        if (this.getBackground() == null) {
            ViewCompat.setBackground((View)this, (Drawable)this.createDefaultBackground());
        }
        this.setCheckable(itemData.isCheckable());
        this.setChecked(itemData.isChecked());
        this.setEnabled(itemData.isEnabled());
        this.setTitle(itemData.getTitle());
        this.setIcon(itemData.getIcon());
        this.setActionView(itemData.getActionView());
        this.setContentDescription(itemData.getContentDescription());
        TooltipCompat.setTooltipText((View)this, (CharSequence)itemData.getTooltipText());
        this.adjustAppearance();
    }

    private boolean shouldExpandActionArea() {
        return this.itemData.getTitle() == null && this.itemData.getIcon() == null && this.itemData.getActionView() != null;
    }

    private void adjustAppearance() {
        if (this.shouldExpandActionArea()) {
            this.textView.setVisibility(8);
            if (this.actionArea != null) {
                LinearLayoutCompat.LayoutParams params = (LinearLayoutCompat.LayoutParams)this.actionArea.getLayoutParams();
                params.width = -1;
                this.actionArea.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else {
            this.textView.setVisibility(0);
            if (this.actionArea != null) {
                LinearLayoutCompat.LayoutParams params = (LinearLayoutCompat.LayoutParams)this.actionArea.getLayoutParams();
                params.width = -2;
                this.actionArea.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    public void recycle() {
        if (this.actionArea != null) {
            this.actionArea.removeAllViews();
        }
        this.textView.setCompoundDrawables(null, null, null, null);
    }

    private void setActionView(@Nullable View actionView) {
        if (actionView != null) {
            if (this.actionArea == null) {
                this.actionArea = (FrameLayout)((ViewStub)this.findViewById(R.id.design_menu_item_action_area_stub)).inflate();
            }
            this.actionArea.removeAllViews();
            this.actionArea.addView(actionView);
        }
    }

    @Nullable
    private StateListDrawable createDefaultBackground() {
        TypedValue value = new TypedValue();
        if (this.getContext().getTheme().resolveAttribute(R.attr.colorControlHighlight, value, true)) {
            StateListDrawable drawable2 = new StateListDrawable();
            drawable2.addState(CHECKED_STATE_SET, (Drawable)new ColorDrawable(value.data));
            drawable2.addState(EMPTY_STATE_SET, (Drawable)new ColorDrawable(0));
            return drawable2;
        }
        return null;
    }

    public MenuItemImpl getItemData() {
        return this.itemData;
    }

    public void setTitle(CharSequence title) {
        this.textView.setText(title);
    }

    public void setCheckable(boolean checkable) {
        this.refreshDrawableState();
        if (this.checkable != checkable) {
            this.checkable = checkable;
            this.accessibilityDelegate.sendAccessibilityEvent((View)this.textView, 2048);
        }
    }

    public void setChecked(boolean checked) {
        this.refreshDrawableState();
        this.textView.setChecked(checked);
        this.textView.setTypeface(this.textView.getTypeface(), checked ? 1 : 0);
    }

    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    public void setIcon(@Nullable Drawable icon) {
        if (icon != null) {
            if (this.hasIconTintList) {
                Drawable.ConstantState state = icon.getConstantState();
                icon = DrawableCompat.wrap((Drawable)(state == null ? icon : state.newDrawable())).mutate();
                DrawableCompat.setTintList((Drawable)icon, (ColorStateList)this.iconTintList);
            }
            icon.setBounds(0, 0, this.iconSize, this.iconSize);
        } else if (this.needsEmptyIcon) {
            if (this.emptyDrawable == null) {
                this.emptyDrawable = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.navigation_empty_icon, (Resources.Theme)this.getContext().getTheme());
                if (this.emptyDrawable != null) {
                    this.emptyDrawable.setBounds(0, 0, this.iconSize, this.iconSize);
                }
            }
            icon = this.emptyDrawable;
        }
        TextViewCompat.setCompoundDrawablesRelative((TextView)this.textView, (Drawable)icon, null, null, null);
    }

    public void setIconSize(@Dimension int iconSize) {
        this.iconSize = iconSize;
    }

    public boolean prefersCondensedTitle() {
        return false;
    }

    public boolean showsIcon() {
        return true;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.itemData != null && this.itemData.isCheckable() && this.itemData.isChecked()) {
            NavigationMenuItemView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    void setIconTintList(ColorStateList tintList) {
        this.iconTintList = tintList;
        boolean bl = this.hasIconTintList = this.iconTintList != null;
        if (this.itemData != null) {
            this.setIcon(this.itemData.getIcon());
        }
    }

    public void setTextAppearance(int textAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.textView, (int)textAppearance);
    }

    public void setTextColor(ColorStateList colors) {
        this.textView.setTextColor(colors);
    }

    public void setNeedsEmptyIcon(boolean needsEmptyIcon) {
        this.needsEmptyIcon = needsEmptyIcon;
    }

    public void setHorizontalPadding(int padding) {
        this.setPadding(padding, this.getPaddingTop(), padding, this.getPaddingBottom());
    }

    public void setIconPadding(int padding) {
        this.textView.setCompoundDrawablePadding(padding);
    }

    public void setMaxLines(int maxLines) {
        this.textView.setMaxLines(maxLines);
    }
}

