/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.StateListAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.Property;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import com.google.android.material.R;
import com.google.android.material.floatingactionbutton.BorderDrawable;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.floatingactionbutton.FloatingActionButtonImpl;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shadow.ShadowViewDelegate;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.util.ArrayList;

@RequiresApi(value=21)
class FloatingActionButtonImplLollipop
extends FloatingActionButtonImpl {
    @Nullable
    private StateListAnimator stateListAnimator;

    FloatingActionButtonImplLollipop(FloatingActionButton view, ShadowViewDelegate shadowViewDelegate) {
        super(view, shadowViewDelegate);
    }

    @Override
    void initializeBackgroundDrawable(ColorStateList backgroundTint, @Nullable PorterDuff.Mode backgroundTintMode, ColorStateList rippleColor, int borderWidth) {
        MaterialShapeDrawable rippleContent;
        this.shapeDrawable = this.createShapeDrawable();
        this.shapeDrawable.setTintList(backgroundTint);
        if (backgroundTintMode != null) {
            this.shapeDrawable.setTintMode(backgroundTintMode);
        }
        this.shapeDrawable.initializeElevationOverlay(this.view.getContext());
        if (borderWidth > 0) {
            this.borderDrawable = this.createBorderDrawable(borderWidth, backgroundTint);
            rippleContent = new LayerDrawable(new Drawable[]{(Drawable)Preconditions.checkNotNull((Object)((Object)this.borderDrawable)), (Drawable)Preconditions.checkNotNull((Object)this.shapeDrawable)});
        } else {
            this.borderDrawable = null;
            rippleContent = this.shapeDrawable;
        }
        this.contentBackground = this.rippleDrawable = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(rippleColor), (Drawable)rippleContent, null);
    }

    @Override
    void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.rippleDrawable instanceof RippleDrawable) {
            ((RippleDrawable)this.rippleDrawable).setColor(RippleUtils.sanitizeRippleDrawableColor(rippleColor));
        } else {
            super.setRippleColor(rippleColor);
        }
    }

    @Override
    void onElevationsChanged(float elevation, float hoveredFocusedTranslationZ, float pressedTranslationZ) {
        if (Build.VERSION.SDK_INT == 21) {
            this.view.refreshDrawableState();
        } else if (this.view.getStateListAnimator() == this.stateListAnimator) {
            this.stateListAnimator = this.createDefaultStateListAnimator(elevation, hoveredFocusedTranslationZ, pressedTranslationZ);
            this.view.setStateListAnimator(this.stateListAnimator);
        }
        if (this.shouldAddPadding()) {
            this.updatePadding();
        }
    }

    @NonNull
    private StateListAnimator createDefaultStateListAnimator(float elevation, float hoveredFocusedTranslationZ, float pressedTranslationZ) {
        StateListAnimator stateListAnimator = new StateListAnimator();
        stateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.createElevationAnimator(elevation, pressedTranslationZ));
        stateListAnimator.addState(HOVERED_FOCUSED_ENABLED_STATE_SET, this.createElevationAnimator(elevation, hoveredFocusedTranslationZ));
        stateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, this.createElevationAnimator(elevation, hoveredFocusedTranslationZ));
        stateListAnimator.addState(HOVERED_ENABLED_STATE_SET, this.createElevationAnimator(elevation, hoveredFocusedTranslationZ));
        AnimatorSet set = new AnimatorSet();
        ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
        animators.add(ObjectAnimator.ofFloat((Object)this.view, (String)"elevation", (float[])new float[]{elevation}).setDuration(0L));
        if (Build.VERSION.SDK_INT >= 22 && Build.VERSION.SDK_INT <= 24) {
            animators.add(ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_Z, (float[])new float[]{this.view.getTranslationZ()}).setDuration(100L));
        }
        animators.add(ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(100L));
        set.playSequentially(animators.toArray(new Animator[0]));
        set.setInterpolator(ELEVATION_ANIM_INTERPOLATOR);
        stateListAnimator.addState(ENABLED_STATE_SET, (Animator)set);
        stateListAnimator.addState(EMPTY_STATE_SET, this.createElevationAnimator(0.0f, 0.0f));
        return stateListAnimator;
    }

    @NonNull
    private Animator createElevationAnimator(float elevation, float translationZ) {
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)ObjectAnimator.ofFloat((Object)this.view, (String)"elevation", (float[])new float[]{elevation}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat((Object)this.view, (Property)View.TRANSLATION_Z, (float[])new float[]{translationZ}).setDuration(100L));
        set.setInterpolator(ELEVATION_ANIM_INTERPOLATOR);
        return set;
    }

    @Override
    public float getElevation() {
        return this.view.getElevation();
    }

    @Override
    void onCompatShadowChanged() {
        this.updatePadding();
    }

    @Override
    boolean shouldAddPadding() {
        return this.shadowViewDelegate.isCompatPaddingEnabled() || !this.shouldExpandBoundsForA11y();
    }

    @Override
    void onDrawableStateChanged(int[] state) {
        if (Build.VERSION.SDK_INT == 21) {
            if (this.view.isEnabled()) {
                this.view.setElevation(this.elevation);
                if (this.view.isPressed()) {
                    this.view.setTranslationZ(this.pressedTranslationZ);
                } else if (this.view.isFocused() || this.view.isHovered()) {
                    this.view.setTranslationZ(this.hoveredFocusedTranslationZ);
                } else {
                    this.view.setTranslationZ(0.0f);
                }
            } else {
                this.view.setElevation(0.0f);
                this.view.setTranslationZ(0.0f);
            }
        }
    }

    @Override
    void jumpDrawableToCurrentState() {
    }

    @Override
    void updateFromViewRotation() {
    }

    @Override
    boolean requirePreDrawListener() {
        return false;
    }

    @NonNull
    BorderDrawable createBorderDrawable(int borderWidth, ColorStateList backgroundTint) {
        Context context = this.view.getContext();
        BorderDrawable borderDrawable = new BorderDrawable((ShapeAppearanceModel)Preconditions.checkNotNull((Object)this.shapeAppearance));
        borderDrawable.setGradientColors(ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_top_outer_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_top_inner_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_end_inner_color), ContextCompat.getColor((Context)context, (int)R.color.design_fab_stroke_end_outer_color));
        borderDrawable.setBorderWidth(borderWidth);
        borderDrawable.setBorderTint(backgroundTint);
        return borderDrawable;
    }

    @Override
    @NonNull
    MaterialShapeDrawable createShapeDrawable() {
        ShapeAppearanceModel shapeAppearance = (ShapeAppearanceModel)Preconditions.checkNotNull((Object)this.shapeAppearance);
        return new AlwaysStatefulMaterialShapeDrawable(shapeAppearance);
    }

    @Override
    void getPadding(@NonNull Rect rect) {
        if (this.shadowViewDelegate.isCompatPaddingEnabled()) {
            super.getPadding(rect);
        } else if (!this.shouldExpandBoundsForA11y()) {
            int minPadding = (this.minTouchTargetSize - this.view.getSizeDimension()) / 2;
            rect.set(minPadding, minPadding, minPadding, minPadding);
        } else {
            rect.set(0, 0, 0, 0);
        }
    }

    static class AlwaysStatefulMaterialShapeDrawable
    extends MaterialShapeDrawable {
        AlwaysStatefulMaterialShapeDrawable(ShapeAppearanceModel shapeAppearanceModel) {
            super(shapeAppearanceModel);
        }

        @Override
        public boolean isStateful() {
            return true;
        }
    }
}

