/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.AnimatorRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.AppCompatImageHelper;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.TintableBackgroundView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TintableImageSourceView;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.animation.TransformationCallback;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.expandable.ExpandableTransformationWidget;
import com.google.android.material.expandable.ExpandableWidgetHelper;
import com.google.android.material.floatingactionbutton.FloatingActionButtonImpl;
import com.google.android.material.floatingactionbutton.FloatingActionButtonImplLollipop;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.internal.VisibilityAwareImageButton;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shadow.ShadowViewDelegate;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.stateful.ExtendableSavedState;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class FloatingActionButton
extends VisibilityAwareImageButton
implements TintableBackgroundView,
TintableImageSourceView,
ExpandableTransformationWidget,
Shapeable,
CoordinatorLayout.AttachedBehavior {
    private static final String LOG_TAG = "FloatingActionButton";
    private static final String EXPANDABLE_WIDGET_HELPER_KEY = "expandableWidgetHelper";
    private static final int DEF_STYLE_RES = R.style.Widget_Design_FloatingActionButton;
    public static final int SIZE_MINI = 1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_AUTO = -1;
    public static final int NO_CUSTOM_SIZE = 0;
    private static final int AUTO_MINI_LARGEST_SCREEN_WIDTH = 470;
    @Nullable
    private ColorStateList backgroundTint;
    @Nullable
    private PorterDuff.Mode backgroundTintMode;
    @Nullable
    private ColorStateList imageTint;
    @Nullable
    private PorterDuff.Mode imageMode;
    @Nullable
    private ColorStateList rippleColor;
    private int borderWidth;
    private int size;
    private int customSize;
    private int imagePadding;
    private int maxImageSize;
    boolean compatPadding;
    final Rect shadowPadding = new Rect();
    private final Rect touchArea = new Rect();
    @NonNull
    private final AppCompatImageHelper imageHelper;
    @NonNull
    private final ExpandableWidgetHelper expandableWidgetHelper;
    private FloatingActionButtonImpl impl;

    public FloatingActionButton(@NonNull Context context) {
        this(context, null);
    }

    public FloatingActionButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.floatingActionButtonStyle);
    }

    public FloatingActionButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.FloatingActionButton, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.backgroundTint = MaterialResources.getColorStateList(context, a, R.styleable.FloatingActionButton_backgroundTint);
        this.backgroundTintMode = ViewUtils.parseTintMode(a.getInt(R.styleable.FloatingActionButton_backgroundTintMode, -1), null);
        this.rippleColor = MaterialResources.getColorStateList(context, a, R.styleable.FloatingActionButton_rippleColor);
        this.size = a.getInt(R.styleable.FloatingActionButton_fabSize, -1);
        this.customSize = a.getDimensionPixelSize(R.styleable.FloatingActionButton_fabCustomSize, 0);
        this.borderWidth = a.getDimensionPixelSize(R.styleable.FloatingActionButton_borderWidth, 0);
        float elevation = a.getDimension(R.styleable.FloatingActionButton_elevation, 0.0f);
        float hoveredFocusedTranslationZ = a.getDimension(R.styleable.FloatingActionButton_hoveredFocusedTranslationZ, 0.0f);
        float pressedTranslationZ = a.getDimension(R.styleable.FloatingActionButton_pressedTranslationZ, 0.0f);
        this.compatPadding = a.getBoolean(R.styleable.FloatingActionButton_useCompatPadding, false);
        int minTouchTargetSize = this.getResources().getDimensionPixelSize(R.dimen.mtrl_fab_min_touch_target);
        this.setMaxImageSize(a.getDimensionPixelSize(R.styleable.FloatingActionButton_maxImageSize, 0));
        MotionSpec showMotionSpec = MotionSpec.createFromAttribute(context, a, R.styleable.FloatingActionButton_showMotionSpec);
        MotionSpec hideMotionSpec = MotionSpec.createFromAttribute(context, a, R.styleable.FloatingActionButton_hideMotionSpec);
        ShapeAppearanceModel shapeAppearance = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES, ShapeAppearanceModel.PILL).build();
        boolean ensureMinTouchTargetSize = a.getBoolean(R.styleable.FloatingActionButton_ensureMinTouchTargetSize, false);
        this.setEnabled(a.getBoolean(R.styleable.FloatingActionButton_android_enabled, true));
        a.recycle();
        this.imageHelper = new AppCompatImageHelper((ImageView)this);
        this.imageHelper.loadFromAttributes(attrs, defStyleAttr);
        this.expandableWidgetHelper = new ExpandableWidgetHelper(this);
        this.getImpl().setShapeAppearance(shapeAppearance);
        this.getImpl().initializeBackgroundDrawable(this.backgroundTint, this.backgroundTintMode, this.rippleColor, this.borderWidth);
        this.getImpl().setMinTouchTargetSize(minTouchTargetSize);
        this.getImpl().setElevation(elevation);
        this.getImpl().setHoveredFocusedTranslationZ(hoveredFocusedTranslationZ);
        this.getImpl().setPressedTranslationZ(pressedTranslationZ);
        this.getImpl().setShowMotionSpec(showMotionSpec);
        this.getImpl().setHideMotionSpec(hideMotionSpec);
        this.getImpl().setEnsureMinTouchTargetSize(ensureMinTouchTargetSize);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int preferredSize = this.getSizeDimension();
        this.imagePadding = (preferredSize - this.maxImageSize) / 2;
        this.getImpl().updatePadding();
        int w = View.resolveSize((int)preferredSize, (int)widthMeasureSpec);
        int h = View.resolveSize((int)preferredSize, (int)heightMeasureSpec);
        int d = Math.min(w, h);
        this.setMeasuredDimension(d + this.shadowPadding.left + this.shadowPadding.right, d + this.shadowPadding.top + this.shadowPadding.bottom);
    }

    @Deprecated
    @ColorInt
    public int getRippleColor() {
        return this.rippleColor != null ? this.rippleColor.getDefaultColor() : 0;
    }

    @Nullable
    public ColorStateList getRippleColorStateList() {
        return this.rippleColor;
    }

    public void setRippleColor(@ColorInt int color2) {
        this.setRippleColor(ColorStateList.valueOf((int)color2));
    }

    public void setRippleColor(@Nullable ColorStateList color2) {
        if (this.rippleColor != color2) {
            this.rippleColor = color2;
            this.getImpl().setRippleColor(this.rippleColor);
        }
    }

    @NonNull
    public CoordinatorLayout.Behavior<FloatingActionButton> getBehavior() {
        return new Behavior();
    }

    @Nullable
    public ColorStateList getBackgroundTintList() {
        return this.backgroundTint;
    }

    public void setBackgroundTintList(@Nullable ColorStateList tint) {
        if (this.backgroundTint != tint) {
            this.backgroundTint = tint;
            this.getImpl().setBackgroundTintList(tint);
        }
    }

    @Nullable
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    public void setBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.backgroundTintMode != tintMode) {
            this.backgroundTintMode = tintMode;
            this.getImpl().setBackgroundTintMode(tintMode);
        }
    }

    public void setSupportBackgroundTintList(@Nullable ColorStateList tint) {
        this.setBackgroundTintList(tint);
    }

    @Nullable
    public ColorStateList getSupportBackgroundTintList() {
        return this.getBackgroundTintList();
    }

    public void setSupportBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.setBackgroundTintMode(tintMode);
    }

    @Nullable
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        return this.getBackgroundTintMode();
    }

    public void setSupportImageTintList(@Nullable ColorStateList tint) {
        if (this.imageTint != tint) {
            this.imageTint = tint;
            this.onApplySupportImageTint();
        }
    }

    @Nullable
    public ColorStateList getSupportImageTintList() {
        return this.imageTint;
    }

    public void setSupportImageTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.imageMode != tintMode) {
            this.imageMode = tintMode;
            this.onApplySupportImageTint();
        }
    }

    @Nullable
    public PorterDuff.Mode getSupportImageTintMode() {
        return this.imageMode;
    }

    private void onApplySupportImageTint() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        if (this.imageTint == null) {
            DrawableCompat.clearColorFilter((Drawable)drawable2);
            return;
        }
        int color2 = this.imageTint.getColorForState(this.getDrawableState(), 0);
        PorterDuff.Mode mode = this.imageMode;
        if (mode == null) {
            mode = PorterDuff.Mode.SRC_IN;
        }
        drawable2.mutate().setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)color2, (PorterDuff.Mode)mode));
    }

    public void setBackgroundDrawable(Drawable background) {
        Log.i((String)LOG_TAG, (String)"Setting a custom background is not supported.");
    }

    public void setBackgroundResource(int resid) {
        Log.i((String)LOG_TAG, (String)"Setting a custom background is not supported.");
    }

    public void setBackgroundColor(int color2) {
        Log.i((String)LOG_TAG, (String)"Setting a custom background is not supported.");
    }

    public void setImageResource(@DrawableRes int resId) {
        this.imageHelper.setImageResource(resId);
        this.onApplySupportImageTint();
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        if (this.getDrawable() != drawable2) {
            super.setImageDrawable(drawable2);
            this.getImpl().updateImageMatrixScale();
            if (this.imageTint != null) {
                this.onApplySupportImageTint();
            }
        }
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearance) {
        this.getImpl().setShapeAppearance(shapeAppearance);
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return (ShapeAppearanceModel)Preconditions.checkNotNull((Object)this.getImpl().getShapeAppearance());
    }

    public boolean shouldEnsureMinTouchTargetSize() {
        return this.getImpl().getEnsureMinTouchTargetSize();
    }

    public void setEnsureMinTouchTargetSize(boolean flag) {
        if (flag != this.getImpl().getEnsureMinTouchTargetSize()) {
            this.getImpl().setEnsureMinTouchTargetSize(flag);
            this.requestLayout();
        }
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
    }

    public void setMaxImageSize(int imageSize) {
        this.maxImageSize = imageSize;
        this.getImpl().setMaxImageSize(imageSize);
    }

    public void show() {
        this.show(null);
    }

    public void show(@Nullable OnVisibilityChangedListener listener) {
        this.show(listener, true);
    }

    void show(@Nullable OnVisibilityChangedListener listener, boolean fromUser) {
        this.getImpl().show(this.wrapOnVisibilityChangedListener(listener), fromUser);
    }

    public void addOnShowAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.getImpl().addOnShowAnimationListener(listener);
    }

    public void removeOnShowAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.getImpl().removeOnShowAnimationListener(listener);
    }

    public void hide() {
        this.hide(null);
    }

    public void hide(@Nullable OnVisibilityChangedListener listener) {
        this.hide(listener, true);
    }

    void hide(@Nullable OnVisibilityChangedListener listener, boolean fromUser) {
        this.getImpl().hide(this.wrapOnVisibilityChangedListener(listener), fromUser);
    }

    public void addOnHideAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.getImpl().addOnHideAnimationListener(listener);
    }

    public void removeOnHideAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.getImpl().removeOnHideAnimationListener(listener);
    }

    @Override
    public boolean setExpanded(boolean expanded) {
        return this.expandableWidgetHelper.setExpanded(expanded);
    }

    @Override
    public boolean isExpanded() {
        return this.expandableWidgetHelper.isExpanded();
    }

    @Override
    public void setExpandedComponentIdHint(@IdRes int expandedComponentIdHint) {
        this.expandableWidgetHelper.setExpandedComponentIdHint(expandedComponentIdHint);
    }

    @Override
    public int getExpandedComponentIdHint() {
        return this.expandableWidgetHelper.getExpandedComponentIdHint();
    }

    public void setUseCompatPadding(boolean useCompatPadding) {
        if (this.compatPadding != useCompatPadding) {
            this.compatPadding = useCompatPadding;
            this.getImpl().onCompatShadowChanged();
        }
    }

    public boolean getUseCompatPadding() {
        return this.compatPadding;
    }

    public void setSize(int size) {
        this.customSize = 0;
        if (size != this.size) {
            this.size = size;
            this.requestLayout();
        }
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    private FloatingActionButtonImpl.InternalVisibilityChangedListener wrapOnVisibilityChangedListener(final @Nullable OnVisibilityChangedListener listener) {
        if (listener == null) {
            return null;
        }
        return new FloatingActionButtonImpl.InternalVisibilityChangedListener(){

            @Override
            public void onShown() {
                listener.onShown(FloatingActionButton.this);
            }

            @Override
            public void onHidden() {
                listener.onHidden(FloatingActionButton.this);
            }
        };
    }

    public boolean isOrWillBeHidden() {
        return this.getImpl().isOrWillBeHidden();
    }

    public boolean isOrWillBeShown() {
        return this.getImpl().isOrWillBeShown();
    }

    public void setCustomSize(@Px int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Custom size must be non-negative");
        }
        if (size != this.customSize) {
            this.customSize = size;
            this.requestLayout();
        }
    }

    @Px
    public int getCustomSize() {
        return this.customSize;
    }

    public void clearCustomSize() {
        this.setCustomSize(0);
    }

    int getSizeDimension() {
        return this.getSizeDimension(this.size);
    }

    private int getSizeDimension(int size) {
        if (this.customSize != 0) {
            return this.customSize;
        }
        Resources res = this.getResources();
        switch (size) {
            case -1: {
                int width = res.getConfiguration().screenWidthDp;
                int height = res.getConfiguration().screenHeightDp;
                return Math.max(width, height) < 470 ? this.getSizeDimension(1) : this.getSizeDimension(0);
            }
            case 1: {
                return res.getDimensionPixelSize(R.dimen.design_fab_size_mini);
            }
        }
        return res.getDimensionPixelSize(R.dimen.design_fab_size_normal);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getImpl().onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getImpl().onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.getImpl().onDrawableStateChanged(this.getDrawableState());
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        this.getImpl().jumpDrawableToCurrentState();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (superState == null) {
            superState = new Bundle();
        }
        ExtendableSavedState state = new ExtendableSavedState(superState);
        state.extendableStates.put((Object)EXPANDABLE_WIDGET_HELPER_KEY, (Object)this.expandableWidgetHelper.onSaveInstanceState());
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ExtendableSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ExtendableSavedState ess = (ExtendableSavedState)state;
        super.onRestoreInstanceState(ess.getSuperState());
        this.expandableWidgetHelper.onRestoreInstanceState((Bundle)Preconditions.checkNotNull((Object)((Bundle)ess.extendableStates.get((Object)EXPANDABLE_WIDGET_HELPER_KEY))));
    }

    @Deprecated
    public boolean getContentRect(@NonNull Rect rect) {
        if (ViewCompat.isLaidOut((View)this)) {
            rect.set(0, 0, this.getWidth(), this.getHeight());
            this.offsetRectWithShadow(rect);
            return true;
        }
        return false;
    }

    public void getMeasuredContentRect(@NonNull Rect rect) {
        rect.set(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        this.offsetRectWithShadow(rect);
    }

    private void offsetRectWithShadow(@NonNull Rect rect) {
        rect.left += this.shadowPadding.left;
        rect.top += this.shadowPadding.top;
        rect.right -= this.shadowPadding.right;
        rect.bottom -= this.shadowPadding.bottom;
    }

    @Nullable
    public Drawable getContentBackground() {
        return this.getImpl().getContentBackground();
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (ev.getAction() == 0 && this.getContentRect(this.touchArea) && !this.touchArea.contains((int)ev.getX(), (int)ev.getY())) {
            return false;
        }
        return super.onTouchEvent(ev);
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        this.getImpl().updateShapeElevation(elevation);
    }

    public float getCompatElevation() {
        return this.getImpl().getElevation();
    }

    public void setCompatElevation(float elevation) {
        this.getImpl().setElevation(elevation);
    }

    public void setCompatElevationResource(@DimenRes int id2) {
        this.setCompatElevation(this.getResources().getDimension(id2));
    }

    public float getCompatHoveredFocusedTranslationZ() {
        return this.getImpl().getHoveredFocusedTranslationZ();
    }

    public void setCompatHoveredFocusedTranslationZ(float translationZ) {
        this.getImpl().setHoveredFocusedTranslationZ(translationZ);
    }

    public void setCompatHoveredFocusedTranslationZResource(@DimenRes int id2) {
        this.setCompatHoveredFocusedTranslationZ(this.getResources().getDimension(id2));
    }

    public float getCompatPressedTranslationZ() {
        return this.getImpl().getPressedTranslationZ();
    }

    public void setCompatPressedTranslationZ(float translationZ) {
        this.getImpl().setPressedTranslationZ(translationZ);
    }

    public void setCompatPressedTranslationZResource(@DimenRes int id2) {
        this.setCompatPressedTranslationZ(this.getResources().getDimension(id2));
    }

    @Nullable
    public MotionSpec getShowMotionSpec() {
        return this.getImpl().getShowMotionSpec();
    }

    public void setShowMotionSpec(@Nullable MotionSpec spec) {
        this.getImpl().setShowMotionSpec(spec);
    }

    public void setShowMotionSpecResource(@AnimatorRes int id2) {
        this.setShowMotionSpec(MotionSpec.createFromResource(this.getContext(), id2));
    }

    @Nullable
    public MotionSpec getHideMotionSpec() {
        return this.getImpl().getHideMotionSpec();
    }

    public void setHideMotionSpec(@Nullable MotionSpec spec) {
        this.getImpl().setHideMotionSpec(spec);
    }

    public void setHideMotionSpecResource(@AnimatorRes int id2) {
        this.setHideMotionSpec(MotionSpec.createFromResource(this.getContext(), id2));
    }

    public void addTransformationCallback(@NonNull TransformationCallback<? extends FloatingActionButton> listener) {
        this.getImpl().addTransformationCallback(new TransformationCallbackWrapper<FloatingActionButton>(listener));
    }

    public void removeTransformationCallback(@NonNull TransformationCallback<? extends FloatingActionButton> listener) {
        this.getImpl().removeTransformationCallback(new TransformationCallbackWrapper<FloatingActionButton>(listener));
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.getImpl().onTranslationChanged();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.getImpl().onTranslationChanged();
    }

    public void setTranslationZ(float translationZ) {
        super.setTranslationZ(translationZ);
        this.getImpl().onTranslationChanged();
    }

    public void setScaleX(float scaleX) {
        super.setScaleX(scaleX);
        this.getImpl().onScaleChanged();
    }

    public void setScaleY(float scaleY) {
        super.setScaleY(scaleY);
        this.getImpl().onScaleChanged();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public void setShadowPaddingEnabled(boolean shadowPaddingEnabled) {
        this.getImpl().setShadowPaddingEnabled(shadowPaddingEnabled);
    }

    private FloatingActionButtonImpl getImpl() {
        if (this.impl == null) {
            this.impl = this.createImpl();
        }
        return this.impl;
    }

    @NonNull
    private FloatingActionButtonImpl createImpl() {
        if (Build.VERSION.SDK_INT >= 21) {
            return new FloatingActionButtonImplLollipop(this, new ShadowDelegateImpl());
        }
        return new FloatingActionButtonImpl(this, new ShadowDelegateImpl());
    }

    private class ShadowDelegateImpl
    implements ShadowViewDelegate {
        ShadowDelegateImpl() {
        }

        @Override
        public float getRadius() {
            return (float)FloatingActionButton.this.getSizeDimension() / 2.0f;
        }

        @Override
        public void setShadowPadding(int left, int top, int right, int bottom) {
            FloatingActionButton.this.shadowPadding.set(left, top, right, bottom);
            FloatingActionButton.this.setPadding(left + FloatingActionButton.this.imagePadding, top + FloatingActionButton.this.imagePadding, right + FloatingActionButton.this.imagePadding, bottom + FloatingActionButton.this.imagePadding);
        }

        @Override
        public void setBackgroundDrawable(@Nullable Drawable background) {
            if (background != null) {
                FloatingActionButton.super.setBackgroundDrawable(background);
            }
        }

        @Override
        public boolean isCompatPaddingEnabled() {
            return FloatingActionButton.this.compatPadding;
        }
    }

    class TransformationCallbackWrapper<T extends FloatingActionButton>
    implements FloatingActionButtonImpl.InternalTransformationCallback {
        @NonNull
        private final TransformationCallback<T> listener;

        TransformationCallbackWrapper(TransformationCallback<T> listener) {
            this.listener = listener;
        }

        @Override
        public void onTranslationChanged() {
            this.listener.onTranslationChanged(FloatingActionButton.this);
        }

        @Override
        public void onScaleChanged() {
            this.listener.onScaleChanged(FloatingActionButton.this);
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof TransformationCallbackWrapper && ((TransformationCallbackWrapper)obj).listener.equals(this.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    protected static class BaseBehavior<T extends FloatingActionButton>
    extends CoordinatorLayout.Behavior<T> {
        private static final boolean AUTO_HIDE_DEFAULT = true;
        private Rect tmpRect;
        private OnVisibilityChangedListener internalAutoHideListener;
        private boolean autoHideEnabled;

        public BaseBehavior() {
            this.autoHideEnabled = true;
        }

        public BaseBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionButton_Behavior_Layout);
            this.autoHideEnabled = a.getBoolean(R.styleable.FloatingActionButton_Behavior_Layout_behavior_autoHide, true);
            a.recycle();
        }

        public void setAutoHideEnabled(boolean autoHide) {
            this.autoHideEnabled = autoHide;
        }

        public boolean isAutoHideEnabled() {
            return this.autoHideEnabled;
        }

        public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams lp) {
            if (lp.dodgeInsetEdges == 0) {
                lp.dodgeInsetEdges = 80;
            }
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, @NonNull FloatingActionButton child, View dependency) {
            if (dependency instanceof AppBarLayout) {
                this.updateFabVisibilityForAppBarLayout(parent, (AppBarLayout)dependency, child);
            } else if (BaseBehavior.isBottomSheet(dependency)) {
                this.updateFabVisibilityForBottomSheet(dependency, child);
            }
            return false;
        }

        private static boolean isBottomSheet(@NonNull View view) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                return ((CoordinatorLayout.LayoutParams)lp).getBehavior() instanceof BottomSheetBehavior;
            }
            return false;
        }

        @VisibleForTesting
        public void setInternalAutoHideListener(OnVisibilityChangedListener listener) {
            this.internalAutoHideListener = listener;
        }

        private boolean shouldUpdateVisibility(@NonNull View dependency, @NonNull FloatingActionButton child) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (!this.autoHideEnabled) {
                return false;
            }
            if (lp.getAnchorId() != dependency.getId()) {
                return false;
            }
            return child.getUserSetVisibility() == 0;
        }

        private boolean updateFabVisibilityForAppBarLayout(CoordinatorLayout parent, @NonNull AppBarLayout appBarLayout, @NonNull FloatingActionButton child) {
            if (!this.shouldUpdateVisibility((View)appBarLayout, child)) {
                return false;
            }
            if (this.tmpRect == null) {
                this.tmpRect = new Rect();
            }
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect((ViewGroup)parent, (View)appBarLayout, rect);
            if (rect.bottom <= appBarLayout.getMinimumHeightForVisibleOverlappingContent()) {
                child.hide(this.internalAutoHideListener, false);
            } else {
                child.show(this.internalAutoHideListener, false);
            }
            return true;
        }

        private boolean updateFabVisibilityForBottomSheet(@NonNull View bottomSheet, @NonNull FloatingActionButton child) {
            if (!this.shouldUpdateVisibility(bottomSheet, child)) {
                return false;
            }
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (bottomSheet.getTop() < child.getHeight() / 2 + lp.topMargin) {
                child.hide(this.internalAutoHideListener, false);
            } else {
                child.show(this.internalAutoHideListener, false);
            }
            return true;
        }

        public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull FloatingActionButton child, int layoutDirection) {
            View dependency;
            List dependencies = parent.getDependencies((View)child);
            int count = dependencies.size();
            for (int i = 0; i < count && !((dependency = (View)dependencies.get(i)) instanceof AppBarLayout ? this.updateFabVisibilityForAppBarLayout(parent, (AppBarLayout)dependency, child) : BaseBehavior.isBottomSheet(dependency) && this.updateFabVisibilityForBottomSheet(dependency, child)); ++i) {
            }
            parent.onLayoutChild((View)child, layoutDirection);
            this.offsetIfNeeded(parent, child);
            return true;
        }

        public boolean getInsetDodgeRect(@NonNull CoordinatorLayout parent, @NonNull FloatingActionButton child, @NonNull Rect rect) {
            Rect shadowPadding = child.shadowPadding;
            rect.set(child.getLeft() + shadowPadding.left, child.getTop() + shadowPadding.top, child.getRight() - shadowPadding.right, child.getBottom() - shadowPadding.bottom);
            return true;
        }

        private void offsetIfNeeded(@NonNull CoordinatorLayout parent, @NonNull FloatingActionButton fab) {
            Rect padding = fab.shadowPadding;
            if (padding != null && padding.centerX() > 0 && padding.centerY() > 0) {
                CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)fab.getLayoutParams();
                int offsetTB = 0;
                int offsetLR = 0;
                if (fab.getRight() >= parent.getWidth() - lp.rightMargin) {
                    offsetLR = padding.right;
                } else if (fab.getLeft() <= lp.leftMargin) {
                    offsetLR = -padding.left;
                }
                if (fab.getBottom() >= parent.getHeight() - lp.bottomMargin) {
                    offsetTB = padding.bottom;
                } else if (fab.getTop() <= lp.topMargin) {
                    offsetTB = -padding.top;
                }
                if (offsetTB != 0) {
                    ViewCompat.offsetTopAndBottom((View)fab, (int)offsetTB);
                }
                if (offsetLR != 0) {
                    ViewCompat.offsetLeftAndRight((View)fab, (int)offsetLR);
                }
            }
        }
    }

    public static class Behavior
    extends BaseBehavior<FloatingActionButton> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Size {
    }

    public static abstract class OnVisibilityChangedListener {
        public void onShown(FloatingActionButton fab) {
        }

        public void onHidden(FloatingActionButton fab) {
        }
    }
}

