/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InsetDialogOnTouchListener
implements View.OnTouchListener {
    @NonNull
    private final Dialog dialog;
    private final int leftInset;
    private final int topInset;
    private final int prePieSlop;

    public InsetDialogOnTouchListener(@NonNull Dialog dialog, @NonNull Rect insets) {
        this.dialog = dialog;
        this.leftInset = insets.left;
        this.topInset = insets.top;
        this.prePieSlop = ViewConfiguration.get((Context)dialog.getContext()).getScaledWindowTouchSlop();
    }

    public boolean onTouch(@NonNull View view, @NonNull MotionEvent event) {
        int insetBottom;
        View insetView = view.findViewById(0x1020002);
        int insetLeft = this.leftInset + insetView.getLeft();
        int insetRight = insetLeft + insetView.getWidth();
        int insetTop = this.topInset + insetView.getTop();
        RectF dialogWindow = new RectF((float)insetLeft, (float)insetTop, (float)insetRight, (float)(insetBottom = insetTop + insetView.getHeight()));
        if (dialogWindow.contains(event.getX(), event.getY())) {
            return false;
        }
        MotionEvent outsideEvent = MotionEvent.obtain((MotionEvent)event);
        if (event.getAction() == 1) {
            outsideEvent.setAction(4);
        }
        if (Build.VERSION.SDK_INT < 28) {
            outsideEvent.setAction(0);
            outsideEvent.setLocation((float)(-this.prePieSlop - 1), (float)(-this.prePieSlop - 1));
        }
        view.performClick();
        return this.dialog.onTouchEvent(outsideEvent);
    }
}

