/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.PickerFragment;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialTextInputPicker<S>
extends PickerFragment<S> {
    private static final String THEME_RES_ID_KEY = "THEME_RES_ID_KEY";
    private static final String DATE_SELECTOR_KEY = "DATE_SELECTOR_KEY";
    private static final String CALENDAR_CONSTRAINTS_KEY = "CALENDAR_CONSTRAINTS_KEY";
    @StyleRes
    private int themeResId;
    @Nullable
    private DateSelector<S> dateSelector;
    @Nullable
    private CalendarConstraints calendarConstraints;

    @NonNull
    static <T> MaterialTextInputPicker<T> newInstance(DateSelector<T> dateSelector, @StyleRes int themeResId, @NonNull CalendarConstraints calendarConstraints) {
        MaterialTextInputPicker materialCalendar = new MaterialTextInputPicker();
        Bundle args = new Bundle();
        args.putInt(THEME_RES_ID_KEY, themeResId);
        args.putParcelable(DATE_SELECTOR_KEY, dateSelector);
        args.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)calendarConstraints);
        materialCalendar.setArguments(args);
        return materialCalendar;
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(THEME_RES_ID_KEY, this.themeResId);
        bundle.putParcelable(DATE_SELECTOR_KEY, this.dateSelector);
        bundle.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)this.calendarConstraints);
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Bundle activeBundle = bundle == null ? this.getArguments() : bundle;
        this.themeResId = activeBundle.getInt(THEME_RES_ID_KEY);
        this.dateSelector = (DateSelector)activeBundle.getParcelable(DATE_SELECTOR_KEY);
        this.calendarConstraints = (CalendarConstraints)activeBundle.getParcelable(CALENDAR_CONSTRAINTS_KEY);
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        ContextThemeWrapper themedContext = new ContextThemeWrapper(this.getContext(), this.themeResId);
        LayoutInflater themedInflater = layoutInflater.cloneInContext((Context)themedContext);
        return this.dateSelector.onCreateTextInputView(themedInflater, viewGroup, bundle, this.calendarConstraints, new OnSelectionChangedListener<S>(){

            @Override
            public void onSelectionChanged(S selection) {
                for (OnSelectionChangedListener listener : MaterialTextInputPicker.this.onSelectionChangedListeners) {
                    listener.onSelectionChanged(selection);
                }
            }

            @Override
            public void onIncompleteSelectionChanged() {
                for (OnSelectionChangedListener listener : MaterialTextInputPicker.this.onSelectionChangedListeners) {
                    listener.onIncompleteSelectionChanged();
                }
            }
        });
    }

    @Override
    @NonNull
    public DateSelector<S> getDateSelector() {
        if (this.dateSelector == null) {
            throw new IllegalStateException("dateSelector should not be null. Use MaterialTextInputPicker#newInstance() to create this fragment with a DateSelector, and call this method after the fragment has been created.");
        }
        return this.dateSelector;
    }
}

