/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.android.material.datepicker.CalendarConstraints;
import java.util.ArrayList;
import java.util.List;

public final class CompositeDateValidator
implements CalendarConstraints.DateValidator {
    @NonNull
    private final Operator operator;
    @NonNull
    private final List<CalendarConstraints.DateValidator> validators;
    private static final int COMPARATOR_ANY_ID = 1;
    private static final int COMPARATOR_ALL_ID = 2;
    private static final Operator ANY_OPERATOR = new Operator(){

        @Override
        public boolean isValid(@NonNull List<CalendarConstraints.DateValidator> validators, long date) {
            for (CalendarConstraints.DateValidator validator : validators) {
                if (validator == null || !validator.isValid(date)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getId() {
            return 1;
        }
    };
    private static final Operator ALL_OPERATOR = new Operator(){

        @Override
        public boolean isValid(@NonNull List<CalendarConstraints.DateValidator> validators, long date) {
            for (CalendarConstraints.DateValidator validator : validators) {
                if (validator == null || validator.isValid(date)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getId() {
            return 2;
        }
    };
    public static final Parcelable.Creator<CompositeDateValidator> CREATOR = new Parcelable.Creator<CompositeDateValidator>(){

        @NonNull
        public CompositeDateValidator createFromParcel(@NonNull Parcel source) {
            ArrayList validators = source.readArrayList(CalendarConstraints.DateValidator.class.getClassLoader());
            int id2 = source.readInt();
            Operator operator = null;
            operator = id2 == 2 ? ALL_OPERATOR : (id2 == 1 ? ANY_OPERATOR : ALL_OPERATOR);
            return new CompositeDateValidator((List)Preconditions.checkNotNull((Object)validators), operator);
        }

        @NonNull
        public CompositeDateValidator[] newArray(int size) {
            return new CompositeDateValidator[size];
        }
    };

    private CompositeDateValidator(@NonNull List<CalendarConstraints.DateValidator> validators, Operator operator) {
        this.validators = validators;
        this.operator = operator;
    }

    @NonNull
    public static CalendarConstraints.DateValidator allOf(@NonNull List<CalendarConstraints.DateValidator> validators) {
        return new CompositeDateValidator(validators, ALL_OPERATOR);
    }

    @NonNull
    public static CalendarConstraints.DateValidator anyOf(@NonNull List<CalendarConstraints.DateValidator> validators) {
        return new CompositeDateValidator(validators, ANY_OPERATOR);
    }

    @Override
    public boolean isValid(long date) {
        return this.operator.isValid(this.validators, date);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeList(this.validators);
        dest.writeInt(this.operator.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeDateValidator)) {
            return false;
        }
        CompositeDateValidator that = (CompositeDateValidator)o;
        return this.validators.equals(that.validators) && this.operator.getId() == that.operator.getId();
    }

    public int hashCode() {
        return this.validators.hashCode();
    }

    private static interface Operator {
        public boolean isValid(@NonNull List<CalendarConstraints.DateValidator> var1, long var2);

        public int getId();
    }
}

