/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.ColorUtils;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TemperatureCache {
    private final Hct input;
    private Hct precomputedComplement;
    private List<Hct> precomputedHctsByTemp;
    private List<Hct> precomputedHctsByHue;
    private Map<Hct, Double> precomputedTempsByHct;

    private TemperatureCache() {
        throw new UnsupportedOperationException();
    }

    public TemperatureCache(Hct input) {
        this.input = input;
    }

    public Hct getComplement() {
        if (this.precomputedComplement != null) {
            return this.precomputedComplement;
        }
        double coldestHue = this.getColdest().getHue();
        double coldestTemp = this.getTempsByHct().get(this.getColdest());
        double warmestHue = this.getWarmest().getHue();
        double warmestTemp = this.getTempsByHct().get(this.getWarmest());
        double range = warmestTemp - coldestTemp;
        boolean startHueIsColdestToWarmest = TemperatureCache.isBetween(this.input.getHue(), coldestHue, warmestHue);
        double startHue = startHueIsColdestToWarmest ? warmestHue : coldestHue;
        double endHue = startHueIsColdestToWarmest ? coldestHue : warmestHue;
        double directionOfRotation = 1.0;
        double smallestError = 1000.0;
        Hct answer = this.getHctsByHue().get((int)Math.round(this.input.getHue()));
        double complementRelativeTemp = 1.0 - this.getRelativeTemperature(this.input);
        for (double hueAddend = 0.0; hueAddend <= 360.0; hueAddend += 1.0) {
            double hue = MathUtils.sanitizeDegreesDouble(startHue + directionOfRotation * hueAddend);
            if (!TemperatureCache.isBetween(hue, startHue, endHue)) continue;
            Hct possibleAnswer = this.getHctsByHue().get((int)Math.round(hue));
            double relativeTemp = (this.getTempsByHct().get(possibleAnswer) - coldestTemp) / range;
            double error = Math.abs(complementRelativeTemp - relativeTemp);
            if (!(error < smallestError)) continue;
            smallestError = error;
            answer = possibleAnswer;
        }
        this.precomputedComplement = answer;
        return this.precomputedComplement;
    }

    public List<Hct> getAnalogousColors() {
        return this.getAnalogousColors(5, 12);
    }

    public List<Hct> getAnalogousColors(int count, int divisions) {
        int startHue = (int)Math.round(this.input.getHue());
        Hct startHct = this.getHctsByHue().get(startHue);
        double lastTemp = this.getRelativeTemperature(startHct);
        ArrayList<Hct> allColors = new ArrayList<Hct>();
        allColors.add(startHct);
        double absoluteTotalTempDelta = 0.0;
        for (int i = 0; i < 360; ++i) {
            int hue = MathUtils.sanitizeDegreesInt(startHue + i);
            Hct hct = this.getHctsByHue().get(hue);
            double temp = this.getRelativeTemperature(hct);
            double tempDelta = Math.abs(temp - lastTemp);
            lastTemp = temp;
            absoluteTotalTempDelta += tempDelta;
        }
        int hueAddend = 1;
        double tempStep = absoluteTotalTempDelta / (double)divisions;
        double totalTempDelta = 0.0;
        lastTemp = this.getRelativeTemperature(startHct);
        while (allColors.size() < divisions) {
            double desiredTotalTempDeltaForIndex;
            int hue = MathUtils.sanitizeDegreesInt(startHue + hueAddend);
            Hct hct = this.getHctsByHue().get(hue);
            double temp = this.getRelativeTemperature(hct);
            double tempDelta = Math.abs(temp - lastTemp);
            boolean indexSatisfied = (totalTempDelta += tempDelta) >= (desiredTotalTempDeltaForIndex = (double)allColors.size() * tempStep);
            int indexAddend = 1;
            while (indexSatisfied && allColors.size() < divisions) {
                allColors.add(hct);
                desiredTotalTempDeltaForIndex = (double)(allColors.size() + indexAddend) * tempStep;
                indexSatisfied = totalTempDelta >= desiredTotalTempDeltaForIndex;
                ++indexAddend;
            }
            lastTemp = temp;
            if (++hueAddend <= 360) continue;
            while (allColors.size() < divisions) {
                allColors.add(hct);
            }
            break block1;
        }
        ArrayList<Hct> answers = new ArrayList<Hct>();
        answers.add(this.input);
        int ccwCount = (int)Math.floor(((double)count - 1.0) / 2.0);
        for (int i = 1; i < ccwCount + 1; ++i) {
            int index = 0 - i;
            while (index < 0) {
                index = allColors.size() + index;
            }
            if (index >= allColors.size()) {
                index %= allColors.size();
            }
            answers.add(0, (Hct)allColors.get(index));
        }
        int cwCount = count - ccwCount - 1;
        for (int i = 1; i < cwCount + 1; ++i) {
            int index = i;
            while (index < 0) {
                index = allColors.size() + index;
            }
            if (index >= allColors.size()) {
                index %= allColors.size();
            }
            answers.add((Hct)allColors.get(index));
        }
        return answers;
    }

    public double getRelativeTemperature(Hct hct) {
        double range = this.getTempsByHct().get(this.getWarmest()) - this.getTempsByHct().get(this.getColdest());
        double differenceFromColdest = this.getTempsByHct().get(hct) - this.getTempsByHct().get(this.getColdest());
        if (range == 0.0) {
            return 0.5;
        }
        return differenceFromColdest / range;
    }

    public static double rawTemperature(Hct color2) {
        double[] lab = ColorUtils.labFromArgb(color2.toInt());
        double hue = MathUtils.sanitizeDegreesDouble(Math.toDegrees(Math.atan2(lab[2], lab[1])));
        double chroma = Math.hypot(lab[1], lab[2]);
        return -0.5 + 0.02 * Math.pow(chroma, 1.07) * Math.cos(Math.toRadians(MathUtils.sanitizeDegreesDouble(hue - 50.0)));
    }

    private Hct getColdest() {
        return this.getHctsByTemp().get(0);
    }

    private List<Hct> getHctsByHue() {
        if (this.precomputedHctsByHue != null) {
            return this.precomputedHctsByHue;
        }
        ArrayList<Hct> hcts = new ArrayList<Hct>();
        for (double hue = 0.0; hue <= 360.0; hue += 1.0) {
            Hct colorAtHue = Hct.from(hue, this.input.getChroma(), this.input.getTone());
            hcts.add(colorAtHue);
        }
        this.precomputedHctsByHue = Collections.unmodifiableList(hcts);
        return this.precomputedHctsByHue;
    }

    private List<Hct> getHctsByTemp() {
        if (this.precomputedHctsByTemp != null) {
            return this.precomputedHctsByTemp;
        }
        ArrayList<Hct> hcts = new ArrayList<Hct>(this.getHctsByHue());
        hcts.add(this.input);
        Comparator<Hct> temperaturesComparator = Comparator.comparing(arg -> this.getTempsByHct().get(arg), Double::compareTo);
        Collections.sort(hcts, temperaturesComparator);
        this.precomputedHctsByTemp = hcts;
        return this.precomputedHctsByTemp;
    }

    private Map<Hct, Double> getTempsByHct() {
        if (this.precomputedTempsByHct != null) {
            return this.precomputedTempsByHct;
        }
        ArrayList<Hct> allHcts = new ArrayList<Hct>(this.getHctsByHue());
        allHcts.add(this.input);
        HashMap<Hct, Double> temperaturesByHct = new HashMap<Hct, Double>();
        for (Hct hct : allHcts) {
            temperaturesByHct.put(hct, TemperatureCache.rawTemperature(hct));
        }
        this.precomputedTempsByHct = temperaturesByHct;
        return this.precomputedTempsByHct;
    }

    private Hct getWarmest() {
        return this.getHctsByTemp().get(this.getHctsByTemp().size() - 1);
    }

    private static boolean isBetween(double angle, double a, double b) {
        if (a < b) {
            return a <= angle && angle <= b;
        }
        return a <= angle || angle <= b;
    }
}

