/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Cam16;
import com.google.android.material.color.utilities.ColorUtils;
import com.google.android.material.color.utilities.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Score {
    private static final double CUTOFF_CHROMA = 15.0;
    private static final double CUTOFF_EXCITED_PROPORTION = 0.01;
    private static final double CUTOFF_TONE = 10.0;
    private static final double TARGET_CHROMA = 48.0;
    private static final double WEIGHT_PROPORTION = 0.7;
    private static final double WEIGHT_CHROMA_ABOVE = 0.3;
    private static final double WEIGHT_CHROMA_BELOW = 0.1;

    private Score() {
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation) {
        double populationSum = 0.0;
        for (Map.Entry<Integer, Integer> entry : colorsToPopulation.entrySet()) {
            populationSum += (double)entry.getValue().intValue();
        }
        HashMap<Integer, Cam16> colorsToCam = new HashMap<Integer, Cam16>();
        double[] hueProportions = new double[361];
        for (Map.Entry<Integer, Integer> entry : colorsToPopulation.entrySet()) {
            int hue;
            int n = entry.getKey();
            double population = entry.getValue().intValue();
            double proportion = population / populationSum;
            Cam16 cam16 = Cam16.fromInt(n);
            colorsToCam.put(n, cam16);
            int n2 = hue = (int)Math.round(cam16.getHue());
            hueProportions[n2] = hueProportions[n2] + proportion;
        }
        HashMap<Integer, Double> colorsToExcitedProportion = new HashMap<Integer, Double>();
        for (Map.Entry entry : colorsToCam.entrySet()) {
            int color3 = (Integer)entry.getKey();
            Cam16 cam = (Cam16)entry.getValue();
            int hue = (int)Math.round(cam.getHue());
            double excitedProportion = 0.0;
            for (int j = hue - 15; j < hue + 15; ++j) {
                int neighborHue = MathUtils.sanitizeDegreesInt(j);
                excitedProportion += hueProportions[neighborHue];
            }
            colorsToExcitedProportion.put(color3, excitedProportion);
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        for (Map.Entry entry : colorsToCam.entrySet()) {
            int color4 = (Integer)entry.getKey();
            Cam16 cam = (Cam16)entry.getValue();
            double proportion = (Double)colorsToExcitedProportion.get(color4);
            double proportionScore = proportion * 100.0 * 0.7;
            double chromaWeight = cam.getChroma() < 48.0 ? 0.1 : 0.3;
            double chromaScore = (cam.getChroma() - 48.0) * chromaWeight;
            double score = proportionScore + chromaScore;
            hashMap.put(color4, score);
        }
        List<Integer> list = Score.filter(colorsToExcitedProportion, colorsToCam);
        HashMap<Integer, Double> filteredColorsToScore = new HashMap<Integer, Double>();
        for (int color5 : list) {
            filteredColorsToScore.put(color5, (Double)hashMap.get(color5));
        }
        ArrayList entryList = new ArrayList(filteredColorsToScore.entrySet());
        Collections.sort(entryList, new ScoredComparator());
        ArrayList<Integer> colorsByScoreDescending = new ArrayList<Integer>();
        for (Map.Entry entry : entryList) {
            int color6 = (Integer)entry.getKey();
            Cam16 cam = (Cam16)colorsToCam.get(color6);
            boolean duplicateHue = false;
            for (Integer alreadyChosenColor : colorsByScoreDescending) {
                Cam16 alreadyChosenCam = (Cam16)colorsToCam.get(alreadyChosenColor);
                if (!(MathUtils.differenceDegrees(cam.getHue(), alreadyChosenCam.getHue()) < 15.0)) continue;
                duplicateHue = true;
                break;
            }
            if (duplicateHue) continue;
            colorsByScoreDescending.add((Integer)entry.getKey());
        }
        if (colorsByScoreDescending.isEmpty()) {
            colorsByScoreDescending.add(-12417548);
        }
        return colorsByScoreDescending;
    }

    private static List<Integer> filter(Map<Integer, Double> colorsToExcitedProportion, Map<Integer, Cam16> colorsToCam) {
        ArrayList<Integer> filtered = new ArrayList<Integer>();
        for (Map.Entry<Integer, Cam16> entry : colorsToCam.entrySet()) {
            int color2 = entry.getKey();
            Cam16 cam = entry.getValue();
            double proportion = colorsToExcitedProportion.get(color2);
            if (!(cam.getChroma() >= 15.0) || !(ColorUtils.lstarFromArgb(color2) >= 10.0) || !(proportion >= 0.01)) continue;
            filtered.add(color2);
        }
        return filtered;
    }

    static class ScoredComparator
    implements Comparator<Map.Entry<Integer, Double>> {
        @Override
        public int compare(Map.Entry<Integer, Double> entry1, Map.Entry<Integer, Double> entry2) {
            return -entry1.getValue().compareTo(entry2.getValue());
        }
    }
}

