/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.DynamicScheme;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.MathUtils;
import com.google.android.material.color.utilities.TonalPalette;
import com.google.android.material.color.utilities.Variant;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SchemeExpressive
extends DynamicScheme {
    private static final double[] HUES = new double[]{0.0, 21.0, 51.0, 121.0, 151.0, 191.0, 271.0, 321.0, 360.0};
    private static final double[] SECONDARY_ROTATIONS = new double[]{45.0, 95.0, 45.0, 20.0, 45.0, 90.0, 45.0, 45.0, 45.0};
    private static final double[] TERTIARY_ROTATIONS = new double[]{120.0, 120.0, 20.0, 45.0, 20.0, 15.0, 20.0, 120.0, 120.0};

    public SchemeExpressive(Hct sourceColorHct, boolean isDark, double contrastLevel) {
        super(sourceColorHct, Variant.EXPRESSIVE, isDark, contrastLevel, TonalPalette.fromHueAndChroma(MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + 120.0), 40.0), TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, HUES, SECONDARY_ROTATIONS), 24.0), TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, HUES, TERTIARY_ROTATIONS), 32.0), TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 8.0), TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 12.0));
    }
}

