/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.CorePalette;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;

@CheckReturnValue
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Scheme {
    private int primary;
    private int onPrimary;
    private int primaryContainer;
    private int onPrimaryContainer;
    private int secondary;
    private int onSecondary;
    private int secondaryContainer;
    private int onSecondaryContainer;
    private int tertiary;
    private int onTertiary;
    private int tertiaryContainer;
    private int onTertiaryContainer;
    private int error;
    private int onError;
    private int errorContainer;
    private int onErrorContainer;
    private int background;
    private int onBackground;
    private int surface;
    private int onSurface;
    private int surfaceVariant;
    private int onSurfaceVariant;
    private int outline;
    private int outlineVariant;
    private int shadow;
    private int scrim;
    private int inverseSurface;
    private int inverseOnSurface;
    private int inversePrimary;

    public Scheme() {
    }

    public Scheme(int primary, int onPrimary, int primaryContainer, int onPrimaryContainer, int secondary, int onSecondary, int secondaryContainer, int onSecondaryContainer, int tertiary, int onTertiary, int tertiaryContainer, int onTertiaryContainer, int error, int onError, int errorContainer, int onErrorContainer, int background, int onBackground, int surface, int onSurface, int surfaceVariant, int onSurfaceVariant, int outline, int outlineVariant, int shadow, int scrim, int inverseSurface, int inverseOnSurface, int inversePrimary) {
        this.primary = primary;
        this.onPrimary = onPrimary;
        this.primaryContainer = primaryContainer;
        this.onPrimaryContainer = onPrimaryContainer;
        this.secondary = secondary;
        this.onSecondary = onSecondary;
        this.secondaryContainer = secondaryContainer;
        this.onSecondaryContainer = onSecondaryContainer;
        this.tertiary = tertiary;
        this.onTertiary = onTertiary;
        this.tertiaryContainer = tertiaryContainer;
        this.onTertiaryContainer = onTertiaryContainer;
        this.error = error;
        this.onError = onError;
        this.errorContainer = errorContainer;
        this.onErrorContainer = onErrorContainer;
        this.background = background;
        this.onBackground = onBackground;
        this.surface = surface;
        this.onSurface = onSurface;
        this.surfaceVariant = surfaceVariant;
        this.onSurfaceVariant = onSurfaceVariant;
        this.outline = outline;
        this.outlineVariant = outlineVariant;
        this.shadow = shadow;
        this.scrim = scrim;
        this.inverseSurface = inverseSurface;
        this.inverseOnSurface = inverseOnSurface;
        this.inversePrimary = inversePrimary;
    }

    public static Scheme light(int argb) {
        return Scheme.lightFromCorePalette(CorePalette.of(argb));
    }

    public static Scheme dark(int argb) {
        return Scheme.darkFromCorePalette(CorePalette.of(argb));
    }

    public static Scheme lightContent(int argb) {
        return Scheme.lightFromCorePalette(CorePalette.contentOf(argb));
    }

    public static Scheme darkContent(int argb) {
        return Scheme.darkFromCorePalette(CorePalette.contentOf(argb));
    }

    private static Scheme lightFromCorePalette(CorePalette core) {
        return new Scheme().withPrimary(core.a1.tone(40)).withOnPrimary(core.a1.tone(100)).withPrimaryContainer(core.a1.tone(90)).withOnPrimaryContainer(core.a1.tone(10)).withSecondary(core.a2.tone(40)).withOnSecondary(core.a2.tone(100)).withSecondaryContainer(core.a2.tone(90)).withOnSecondaryContainer(core.a2.tone(10)).withTertiary(core.a3.tone(40)).withOnTertiary(core.a3.tone(100)).withTertiaryContainer(core.a3.tone(90)).withOnTertiaryContainer(core.a3.tone(10)).withError(core.error.tone(40)).withOnError(core.error.tone(100)).withErrorContainer(core.error.tone(90)).withOnErrorContainer(core.error.tone(10)).withBackground(core.n1.tone(99)).withOnBackground(core.n1.tone(10)).withSurface(core.n1.tone(99)).withOnSurface(core.n1.tone(10)).withSurfaceVariant(core.n2.tone(90)).withOnSurfaceVariant(core.n2.tone(30)).withOutline(core.n2.tone(50)).withOutlineVariant(core.n2.tone(80)).withShadow(core.n1.tone(0)).withScrim(core.n1.tone(0)).withInverseSurface(core.n1.tone(20)).withInverseOnSurface(core.n1.tone(95)).withInversePrimary(core.a1.tone(80));
    }

    private static Scheme darkFromCorePalette(CorePalette core) {
        return new Scheme().withPrimary(core.a1.tone(80)).withOnPrimary(core.a1.tone(20)).withPrimaryContainer(core.a1.tone(30)).withOnPrimaryContainer(core.a1.tone(90)).withSecondary(core.a2.tone(80)).withOnSecondary(core.a2.tone(20)).withSecondaryContainer(core.a2.tone(30)).withOnSecondaryContainer(core.a2.tone(90)).withTertiary(core.a3.tone(80)).withOnTertiary(core.a3.tone(20)).withTertiaryContainer(core.a3.tone(30)).withOnTertiaryContainer(core.a3.tone(90)).withError(core.error.tone(80)).withOnError(core.error.tone(20)).withErrorContainer(core.error.tone(30)).withOnErrorContainer(core.error.tone(80)).withBackground(core.n1.tone(10)).withOnBackground(core.n1.tone(90)).withSurface(core.n1.tone(10)).withOnSurface(core.n1.tone(90)).withSurfaceVariant(core.n2.tone(30)).withOnSurfaceVariant(core.n2.tone(80)).withOutline(core.n2.tone(60)).withOutlineVariant(core.n2.tone(30)).withShadow(core.n1.tone(0)).withScrim(core.n1.tone(0)).withInverseSurface(core.n1.tone(90)).withInverseOnSurface(core.n1.tone(20)).withInversePrimary(core.a1.tone(40));
    }

    public int getPrimary() {
        return this.primary;
    }

    public void setPrimary(int primary) {
        this.primary = primary;
    }

    @CanIgnoreReturnValue
    public Scheme withPrimary(int primary) {
        this.primary = primary;
        return this;
    }

    public int getOnPrimary() {
        return this.onPrimary;
    }

    public void setOnPrimary(int onPrimary) {
        this.onPrimary = onPrimary;
    }

    @CanIgnoreReturnValue
    public Scheme withOnPrimary(int onPrimary) {
        this.onPrimary = onPrimary;
        return this;
    }

    public int getPrimaryContainer() {
        return this.primaryContainer;
    }

    public void setPrimaryContainer(int primaryContainer) {
        this.primaryContainer = primaryContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withPrimaryContainer(int primaryContainer) {
        this.primaryContainer = primaryContainer;
        return this;
    }

    public int getOnPrimaryContainer() {
        return this.onPrimaryContainer;
    }

    public void setOnPrimaryContainer(int onPrimaryContainer) {
        this.onPrimaryContainer = onPrimaryContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withOnPrimaryContainer(int onPrimaryContainer) {
        this.onPrimaryContainer = onPrimaryContainer;
        return this;
    }

    public int getSecondary() {
        return this.secondary;
    }

    public void setSecondary(int secondary) {
        this.secondary = secondary;
    }

    @CanIgnoreReturnValue
    public Scheme withSecondary(int secondary) {
        this.secondary = secondary;
        return this;
    }

    public int getOnSecondary() {
        return this.onSecondary;
    }

    public void setOnSecondary(int onSecondary) {
        this.onSecondary = onSecondary;
    }

    @CanIgnoreReturnValue
    public Scheme withOnSecondary(int onSecondary) {
        this.onSecondary = onSecondary;
        return this;
    }

    public int getSecondaryContainer() {
        return this.secondaryContainer;
    }

    public void setSecondaryContainer(int secondaryContainer) {
        this.secondaryContainer = secondaryContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withSecondaryContainer(int secondaryContainer) {
        this.secondaryContainer = secondaryContainer;
        return this;
    }

    public int getOnSecondaryContainer() {
        return this.onSecondaryContainer;
    }

    public void setOnSecondaryContainer(int onSecondaryContainer) {
        this.onSecondaryContainer = onSecondaryContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withOnSecondaryContainer(int onSecondaryContainer) {
        this.onSecondaryContainer = onSecondaryContainer;
        return this;
    }

    public int getTertiary() {
        return this.tertiary;
    }

    public void setTertiary(int tertiary) {
        this.tertiary = tertiary;
    }

    @CanIgnoreReturnValue
    public Scheme withTertiary(int tertiary) {
        this.tertiary = tertiary;
        return this;
    }

    public int getOnTertiary() {
        return this.onTertiary;
    }

    public void setOnTertiary(int onTertiary) {
        this.onTertiary = onTertiary;
    }

    @CanIgnoreReturnValue
    public Scheme withOnTertiary(int onTertiary) {
        this.onTertiary = onTertiary;
        return this;
    }

    public int getTertiaryContainer() {
        return this.tertiaryContainer;
    }

    public void setTertiaryContainer(int tertiaryContainer) {
        this.tertiaryContainer = tertiaryContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withTertiaryContainer(int tertiaryContainer) {
        this.tertiaryContainer = tertiaryContainer;
        return this;
    }

    public int getOnTertiaryContainer() {
        return this.onTertiaryContainer;
    }

    public void setOnTertiaryContainer(int onTertiaryContainer) {
        this.onTertiaryContainer = onTertiaryContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withOnTertiaryContainer(int onTertiaryContainer) {
        this.onTertiaryContainer = onTertiaryContainer;
        return this;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    @CanIgnoreReturnValue
    public Scheme withError(int error) {
        this.error = error;
        return this;
    }

    public int getOnError() {
        return this.onError;
    }

    public void setOnError(int onError) {
        this.onError = onError;
    }

    @CanIgnoreReturnValue
    public Scheme withOnError(int onError) {
        this.onError = onError;
        return this;
    }

    public int getErrorContainer() {
        return this.errorContainer;
    }

    public void setErrorContainer(int errorContainer) {
        this.errorContainer = errorContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withErrorContainer(int errorContainer) {
        this.errorContainer = errorContainer;
        return this;
    }

    public int getOnErrorContainer() {
        return this.onErrorContainer;
    }

    public void setOnErrorContainer(int onErrorContainer) {
        this.onErrorContainer = onErrorContainer;
    }

    @CanIgnoreReturnValue
    public Scheme withOnErrorContainer(int onErrorContainer) {
        this.onErrorContainer = onErrorContainer;
        return this;
    }

    public int getBackground() {
        return this.background;
    }

    public void setBackground(int background) {
        this.background = background;
    }

    @CanIgnoreReturnValue
    public Scheme withBackground(int background) {
        this.background = background;
        return this;
    }

    public int getOnBackground() {
        return this.onBackground;
    }

    public void setOnBackground(int onBackground) {
        this.onBackground = onBackground;
    }

    @CanIgnoreReturnValue
    public Scheme withOnBackground(int onBackground) {
        this.onBackground = onBackground;
        return this;
    }

    public int getSurface() {
        return this.surface;
    }

    public void setSurface(int surface) {
        this.surface = surface;
    }

    @CanIgnoreReturnValue
    public Scheme withSurface(int surface) {
        this.surface = surface;
        return this;
    }

    public int getOnSurface() {
        return this.onSurface;
    }

    public void setOnSurface(int onSurface) {
        this.onSurface = onSurface;
    }

    @CanIgnoreReturnValue
    public Scheme withOnSurface(int onSurface) {
        this.onSurface = onSurface;
        return this;
    }

    public int getSurfaceVariant() {
        return this.surfaceVariant;
    }

    public void setSurfaceVariant(int surfaceVariant) {
        this.surfaceVariant = surfaceVariant;
    }

    @CanIgnoreReturnValue
    public Scheme withSurfaceVariant(int surfaceVariant) {
        this.surfaceVariant = surfaceVariant;
        return this;
    }

    public int getOnSurfaceVariant() {
        return this.onSurfaceVariant;
    }

    public void setOnSurfaceVariant(int onSurfaceVariant) {
        this.onSurfaceVariant = onSurfaceVariant;
    }

    @CanIgnoreReturnValue
    public Scheme withOnSurfaceVariant(int onSurfaceVariant) {
        this.onSurfaceVariant = onSurfaceVariant;
        return this;
    }

    public int getOutline() {
        return this.outline;
    }

    public void setOutline(int outline) {
        this.outline = outline;
    }

    @CanIgnoreReturnValue
    public Scheme withOutline(int outline) {
        this.outline = outline;
        return this;
    }

    public int getOutlineVariant() {
        return this.outlineVariant;
    }

    public void setOutlineVariant(int outlineVariant) {
        this.outlineVariant = outlineVariant;
    }

    @CanIgnoreReturnValue
    public Scheme withOutlineVariant(int outlineVariant) {
        this.outlineVariant = outlineVariant;
        return this;
    }

    public int getShadow() {
        return this.shadow;
    }

    public void setShadow(int shadow) {
        this.shadow = shadow;
    }

    @CanIgnoreReturnValue
    public Scheme withShadow(int shadow) {
        this.shadow = shadow;
        return this;
    }

    public int getScrim() {
        return this.scrim;
    }

    public void setScrim(int scrim) {
        this.scrim = scrim;
    }

    @CanIgnoreReturnValue
    public Scheme withScrim(int scrim) {
        this.scrim = scrim;
        return this;
    }

    public int getInverseSurface() {
        return this.inverseSurface;
    }

    public void setInverseSurface(int inverseSurface) {
        this.inverseSurface = inverseSurface;
    }

    @CanIgnoreReturnValue
    public Scheme withInverseSurface(int inverseSurface) {
        this.inverseSurface = inverseSurface;
        return this;
    }

    public int getInverseOnSurface() {
        return this.inverseOnSurface;
    }

    public void setInverseOnSurface(int inverseOnSurface) {
        this.inverseOnSurface = inverseOnSurface;
    }

    @CanIgnoreReturnValue
    public Scheme withInverseOnSurface(int inverseOnSurface) {
        this.inverseOnSurface = inverseOnSurface;
        return this;
    }

    public int getInversePrimary() {
        return this.inversePrimary;
    }

    public void setInversePrimary(int inversePrimary) {
        this.inversePrimary = inversePrimary;
    }

    @CanIgnoreReturnValue
    public Scheme withInversePrimary(int inversePrimary) {
        this.inversePrimary = inversePrimary;
        return this;
    }

    public String toString() {
        return "Scheme{primary=" + this.primary + ", onPrimary=" + this.onPrimary + ", primaryContainer=" + this.primaryContainer + ", onPrimaryContainer=" + this.onPrimaryContainer + ", secondary=" + this.secondary + ", onSecondary=" + this.onSecondary + ", secondaryContainer=" + this.secondaryContainer + ", onSecondaryContainer=" + this.onSecondaryContainer + ", tertiary=" + this.tertiary + ", onTertiary=" + this.onTertiary + ", tertiaryContainer=" + this.tertiaryContainer + ", onTertiaryContainer=" + this.onTertiaryContainer + ", error=" + this.error + ", onError=" + this.onError + ", errorContainer=" + this.errorContainer + ", onErrorContainer=" + this.onErrorContainer + ", background=" + this.background + ", onBackground=" + this.onBackground + ", surface=" + this.surface + ", onSurface=" + this.onSurface + ", surfaceVariant=" + this.surfaceVariant + ", onSurfaceVariant=" + this.onSurfaceVariant + ", outline=" + this.outline + ", outlineVariant=" + this.outlineVariant + ", shadow=" + this.shadow + ", scrim=" + this.scrim + ", inverseSurface=" + this.inverseSurface + ", inverseOnSurface=" + this.inverseOnSurface + ", inversePrimary=" + this.inversePrimary + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scheme)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Scheme scheme = (Scheme)object;
        if (this.primary != scheme.primary) {
            return false;
        }
        if (this.onPrimary != scheme.onPrimary) {
            return false;
        }
        if (this.primaryContainer != scheme.primaryContainer) {
            return false;
        }
        if (this.onPrimaryContainer != scheme.onPrimaryContainer) {
            return false;
        }
        if (this.secondary != scheme.secondary) {
            return false;
        }
        if (this.onSecondary != scheme.onSecondary) {
            return false;
        }
        if (this.secondaryContainer != scheme.secondaryContainer) {
            return false;
        }
        if (this.onSecondaryContainer != scheme.onSecondaryContainer) {
            return false;
        }
        if (this.tertiary != scheme.tertiary) {
            return false;
        }
        if (this.onTertiary != scheme.onTertiary) {
            return false;
        }
        if (this.tertiaryContainer != scheme.tertiaryContainer) {
            return false;
        }
        if (this.onTertiaryContainer != scheme.onTertiaryContainer) {
            return false;
        }
        if (this.error != scheme.error) {
            return false;
        }
        if (this.onError != scheme.onError) {
            return false;
        }
        if (this.errorContainer != scheme.errorContainer) {
            return false;
        }
        if (this.onErrorContainer != scheme.onErrorContainer) {
            return false;
        }
        if (this.background != scheme.background) {
            return false;
        }
        if (this.onBackground != scheme.onBackground) {
            return false;
        }
        if (this.surface != scheme.surface) {
            return false;
        }
        if (this.onSurface != scheme.onSurface) {
            return false;
        }
        if (this.surfaceVariant != scheme.surfaceVariant) {
            return false;
        }
        if (this.onSurfaceVariant != scheme.onSurfaceVariant) {
            return false;
        }
        if (this.outline != scheme.outline) {
            return false;
        }
        if (this.outlineVariant != scheme.outlineVariant) {
            return false;
        }
        if (this.shadow != scheme.shadow) {
            return false;
        }
        if (this.scrim != scheme.scrim) {
            return false;
        }
        if (this.inverseSurface != scheme.inverseSurface) {
            return false;
        }
        if (this.inverseOnSurface != scheme.inverseOnSurface) {
            return false;
        }
        return this.inversePrimary == scheme.inversePrimary;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.primary;
        result = 31 * result + this.onPrimary;
        result = 31 * result + this.primaryContainer;
        result = 31 * result + this.onPrimaryContainer;
        result = 31 * result + this.secondary;
        result = 31 * result + this.onSecondary;
        result = 31 * result + this.secondaryContainer;
        result = 31 * result + this.onSecondaryContainer;
        result = 31 * result + this.tertiary;
        result = 31 * result + this.onTertiary;
        result = 31 * result + this.tertiaryContainer;
        result = 31 * result + this.onTertiaryContainer;
        result = 31 * result + this.error;
        result = 31 * result + this.onError;
        result = 31 * result + this.errorContainer;
        result = 31 * result + this.onErrorContainer;
        result = 31 * result + this.background;
        result = 31 * result + this.onBackground;
        result = 31 * result + this.surface;
        result = 31 * result + this.onSurface;
        result = 31 * result + this.surfaceVariant;
        result = 31 * result + this.onSurfaceVariant;
        result = 31 * result + this.outline;
        result = 31 * result + this.outlineVariant;
        result = 31 * result + this.shadow;
        result = 31 * result + this.scrim;
        result = 31 * result + this.inverseSurface;
        result = 31 * result + this.inverseOnSurface;
        result = 31 * result + this.inversePrimary;
        return result;
    }
}

