/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.MathUtils;
import com.google.android.material.color.utilities.TonalPalette;
import com.google.android.material.color.utilities.Variant;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DynamicScheme {
    public final int sourceColorArgb;
    public final Hct sourceColorHct;
    public final Variant variant;
    public final boolean isDark;
    public final double contrastLevel;
    public final TonalPalette primaryPalette;
    public final TonalPalette secondaryPalette;
    public final TonalPalette tertiaryPalette;
    public final TonalPalette neutralPalette;
    public final TonalPalette neutralVariantPalette;
    public final TonalPalette errorPalette;

    public DynamicScheme(Hct sourceColorHct, Variant variant, boolean isDark, double contrastLevel, TonalPalette primaryPalette, TonalPalette secondaryPalette, TonalPalette tertiaryPalette, TonalPalette neutralPalette, TonalPalette neutralVariantPalette) {
        this.sourceColorArgb = sourceColorHct.toInt();
        this.sourceColorHct = sourceColorHct;
        this.variant = variant;
        this.isDark = isDark;
        this.contrastLevel = contrastLevel;
        this.primaryPalette = primaryPalette;
        this.secondaryPalette = secondaryPalette;
        this.tertiaryPalette = tertiaryPalette;
        this.neutralPalette = neutralPalette;
        this.neutralVariantPalette = neutralVariantPalette;
        this.errorPalette = TonalPalette.fromHueAndChroma(25.0, 84.0);
    }

    public static double getRotatedHue(Hct sourceColorHct, double[] hues, double[] rotations) {
        double sourceHue = sourceColorHct.getHue();
        if (rotations.length == 1) {
            return MathUtils.sanitizeDegreesDouble(sourceHue + rotations[0]);
        }
        int size = hues.length;
        for (int i = 0; i <= size - 2; ++i) {
            double thisHue = hues[i];
            double nextHue = hues[i + 1];
            if (!(thisHue < sourceHue) || !(sourceHue < nextHue)) continue;
            return MathUtils.sanitizeDegreesDouble(sourceHue + rotations[i]);
        }
        return sourceHue;
    }
}

