/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Contrast;
import com.google.android.material.color.utilities.DynamicScheme;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.MathUtils;
import com.google.android.material.color.utilities.TonalPalette;
import com.google.android.material.color.utilities.ToneDeltaConstraint;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DynamicColor {
    public final Function<DynamicScheme, Double> hue;
    public final Function<DynamicScheme, Double> chroma;
    public final Function<DynamicScheme, Double> tone;
    public final Function<DynamicScheme, Double> opacity;
    public final Function<DynamicScheme, DynamicColor> background;
    public final Function<DynamicScheme, Double> toneMinContrast;
    public final Function<DynamicScheme, Double> toneMaxContrast;
    public final Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint;
    private final HashMap<DynamicScheme, Hct> hctCache = new HashMap();

    public DynamicColor(Function<DynamicScheme, Double> hue, Function<DynamicScheme, Double> chroma, Function<DynamicScheme, Double> tone, Function<DynamicScheme, Double> opacity, Function<DynamicScheme, DynamicColor> background, Function<DynamicScheme, Double> toneMinContrast, Function<DynamicScheme, Double> toneMaxContrast, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint) {
        this.hue = hue;
        this.chroma = chroma;
        this.tone = tone;
        this.opacity = opacity;
        this.background = background;
        this.toneMinContrast = toneMinContrast;
        this.toneMaxContrast = toneMaxContrast;
        this.toneDeltaConstraint = toneDeltaConstraint;
    }

    public static DynamicColor fromArgb(int argb) {
        Hct hct = Hct.fromInt(argb);
        TonalPalette palette = TonalPalette.fromInt(argb);
        return DynamicColor.fromPalette(s -> palette, s -> hct.getTone());
    }

    public static DynamicColor fromArgb(int argb, Function<DynamicScheme, Double> tone) {
        return DynamicColor.fromPalette(s -> TonalPalette.fromInt(argb), tone);
    }

    public static DynamicColor fromArgb(int argb, Function<DynamicScheme, Double> tone, Function<DynamicScheme, DynamicColor> background) {
        return DynamicColor.fromPalette(s -> TonalPalette.fromInt(argb), tone, background);
    }

    public static DynamicColor fromArgb(int argb, Function<DynamicScheme, Double> tone, Function<DynamicScheme, DynamicColor> background, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint) {
        return DynamicColor.fromPalette(s -> TonalPalette.fromInt(argb), tone, background, toneDeltaConstraint);
    }

    public static DynamicColor fromPalette(Function<DynamicScheme, TonalPalette> palette, Function<DynamicScheme, Double> tone) {
        return DynamicColor.fromPalette(palette, tone, null, null);
    }

    public static DynamicColor fromPalette(Function<DynamicScheme, TonalPalette> palette, Function<DynamicScheme, Double> tone, Function<DynamicScheme, DynamicColor> background) {
        return DynamicColor.fromPalette(palette, tone, background, null);
    }

    public static DynamicColor fromPalette(Function<DynamicScheme, TonalPalette> palette, Function<DynamicScheme, Double> tone, Function<DynamicScheme, DynamicColor> background, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint) {
        return new DynamicColor(scheme -> ((TonalPalette)palette.apply((DynamicScheme)scheme)).getHue(), scheme -> ((TonalPalette)palette.apply((DynamicScheme)scheme)).getChroma(), tone, null, background, scheme -> DynamicColor.toneMinContrastDefault(tone, background, scheme, toneDeltaConstraint), scheme -> DynamicColor.toneMaxContrastDefault(tone, background, scheme, toneDeltaConstraint), toneDeltaConstraint);
    }

    public int getArgb(DynamicScheme scheme) {
        int argb = this.getHct(scheme).toInt();
        if (this.opacity == null) {
            return argb;
        }
        double percentage = this.opacity.apply(scheme);
        int alpha = MathUtils.clampInt(0, 255, (int)Math.round(percentage * 255.0));
        return argb & 0xFFFFFF | alpha << 24;
    }

    public Hct getHct(DynamicScheme scheme) {
        Hct cachedAnswer = this.hctCache.get(scheme);
        if (cachedAnswer != null) {
            return cachedAnswer;
        }
        Hct answer = Hct.from(this.hue.apply(scheme), this.chroma.apply(scheme), this.getTone(scheme));
        if (this.hctCache.size() > 4) {
            this.hctCache.clear();
        }
        this.hctCache.put(scheme, answer);
        return answer;
    }

    public double getTone(DynamicScheme scheme) {
        boolean decreasingContrast;
        double answer = this.tone.apply(scheme);
        boolean bl = decreasingContrast = scheme.contrastLevel < 0.0;
        if (scheme.contrastLevel != 0.0) {
            double startTone = this.tone.apply(scheme);
            double endTone = decreasingContrast ? this.toneMinContrast.apply(scheme) : this.toneMaxContrast.apply(scheme);
            double delta = (endTone - startTone) * Math.abs(scheme.contrastLevel);
            answer = delta + startTone;
        }
        DynamicColor bgDynamicColor = this.background == null ? null : this.background.apply(scheme);
        double minRatio = 1.0;
        double maxRatio = 21.0;
        if (bgDynamicColor != null) {
            boolean bgHasBg = bgDynamicColor.background != null && bgDynamicColor.background.apply(scheme) != null;
            double standardRatio = Contrast.ratioOfTones(this.tone.apply(scheme), bgDynamicColor.tone.apply(scheme));
            if (decreasingContrast) {
                double minContrastRatio = Contrast.ratioOfTones(this.toneMinContrast.apply(scheme), bgDynamicColor.toneMinContrast.apply(scheme));
                minRatio = bgHasBg ? minContrastRatio : 1.0;
                maxRatio = standardRatio;
            } else {
                double maxContrastRatio = Contrast.ratioOfTones(this.toneMaxContrast.apply(scheme), bgDynamicColor.toneMaxContrast.apply(scheme));
                minRatio = bgHasBg ? Math.min(maxContrastRatio, standardRatio) : 1.0;
                maxRatio = bgHasBg ? Math.max(maxContrastRatio, standardRatio) : 21.0;
            }
        }
        double finalMinRatio = minRatio;
        double finalMaxRatio = maxRatio;
        double finalAnswer = answer;
        answer = DynamicColor.calculateDynamicTone(scheme, this.tone, dynamicColor -> dynamicColor.getTone(scheme), (a, b) -> finalAnswer, s -> bgDynamicColor, this.toneDeltaConstraint, s -> finalMinRatio, s -> finalMaxRatio);
        return answer;
    }

    public static double toneMinContrastDefault(Function<DynamicScheme, Double> tone, Function<DynamicScheme, DynamicColor> background, DynamicScheme scheme, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint) {
        return DynamicColor.calculateDynamicTone(scheme, tone, c -> c.toneMinContrast.apply(scheme), (stdRatio, bgTone) -> {
            double answer = (Double)tone.apply(scheme);
            if (stdRatio >= 7.0) {
                answer = DynamicColor.contrastingTone(bgTone, 4.5);
            } else if (stdRatio >= 3.0) {
                answer = DynamicColor.contrastingTone(bgTone, 3.0);
            } else {
                boolean backgroundHasBackground;
                boolean bl = backgroundHasBackground = background != null && background.apply(scheme) != null && ((DynamicColor)background.apply(scheme)).background != null && ((DynamicColor)background.apply(scheme)).background.apply(scheme) != null;
                if (backgroundHasBackground) {
                    answer = DynamicColor.contrastingTone(bgTone, stdRatio);
                }
            }
            return answer;
        }, background, toneDeltaConstraint, null, standardRatio -> standardRatio);
    }

    public static double toneMaxContrastDefault(Function<DynamicScheme, Double> tone, Function<DynamicScheme, DynamicColor> background, DynamicScheme scheme, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint) {
        return DynamicColor.calculateDynamicTone(scheme, tone, c -> c.toneMaxContrast.apply(scheme), (stdRatio, bgTone) -> {
            boolean backgroundHasBackground;
            boolean bl = backgroundHasBackground = background != null && background.apply(scheme) != null && ((DynamicColor)background.apply(scheme)).background != null && ((DynamicColor)background.apply(scheme)).background.apply(scheme) != null;
            if (backgroundHasBackground) {
                return DynamicColor.contrastingTone(bgTone, 7.0);
            }
            return DynamicColor.contrastingTone(bgTone, Math.max(7.0, stdRatio));
        }, background, toneDeltaConstraint, null, null);
    }

    public static double calculateDynamicTone(DynamicScheme scheme, Function<DynamicScheme, Double> toneStandard, Function<DynamicColor, Double> toneToJudge, BiFunction<Double, Double, Double> desiredTone, Function<DynamicScheme, DynamicColor> background, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint, Function<Double, Double> minRatio, Function<Double, Double> maxRatio) {
        double minRatioRealized;
        DynamicColor bgDynamic;
        double toneStd;
        double answer = toneStd = toneStandard.apply(scheme).doubleValue();
        DynamicColor dynamicColor = bgDynamic = background == null ? null : background.apply(scheme);
        if (bgDynamic == null) {
            return answer;
        }
        double bgToneStd = bgDynamic.tone.apply(scheme);
        double stdRatio = Contrast.ratioOfTones(toneStd, bgToneStd);
        double bgTone = toneToJudge.apply(bgDynamic);
        double myDesiredTone = desiredTone.apply(stdRatio, bgTone);
        double currentRatio = Contrast.ratioOfTones(bgTone, myDesiredTone);
        double d = minRatio == null ? 1.0 : (minRatioRealized = minRatio.apply(stdRatio) == null ? 1.0 : minRatio.apply(stdRatio));
        double maxRatioRealized = maxRatio == null ? 21.0 : (maxRatio.apply(stdRatio) == null ? 21.0 : maxRatio.apply(stdRatio));
        double desiredRatio = MathUtils.clampDouble(minRatioRealized, maxRatioRealized, currentRatio);
        answer = desiredRatio == currentRatio ? myDesiredTone : DynamicColor.contrastingTone(bgTone, desiredRatio);
        if (bgDynamic.background == null || bgDynamic.background.apply(scheme) == null) {
            answer = DynamicColor.enableLightForeground(answer);
        }
        answer = DynamicColor.ensureToneDelta(answer, toneStd, scheme, toneDeltaConstraint, toneToJudge);
        return answer;
    }

    static double ensureToneDelta(double tone, double toneStandard, DynamicScheme scheme, Function<DynamicScheme, ToneDeltaConstraint> toneDeltaConstraint, Function<DynamicColor, Double> toneToDistanceFrom) {
        ToneDeltaConstraint constraint;
        ToneDeltaConstraint toneDeltaConstraint2 = constraint = toneDeltaConstraint == null ? null : toneDeltaConstraint.apply(scheme);
        if (constraint == null) {
            return tone;
        }
        double requiredDelta = constraint.delta;
        double keepAwayTone = toneToDistanceFrom.apply(constraint.keepAway);
        double delta = Math.abs(tone - keepAwayTone);
        if (delta >= requiredDelta) {
            return tone;
        }
        switch (constraint.keepAwayPolarity) {
            case DARKER: {
                return MathUtils.clampDouble(0.0, 100.0, keepAwayTone + requiredDelta);
            }
            case LIGHTER: {
                return MathUtils.clampDouble(0.0, 100.0, keepAwayTone - requiredDelta);
            }
            case NO_PREFERENCE: {
                double keepAwayToneStandard = constraint.keepAway.tone.apply(scheme);
                boolean preferLighten = toneStandard > keepAwayToneStandard;
                double alterAmount = Math.abs(delta - requiredDelta);
                boolean lighten = preferLighten ? tone + alterAmount <= 100.0 : tone < alterAmount;
                return lighten ? tone + alterAmount : tone - alterAmount;
            }
        }
        return tone;
    }

    public static double contrastingTone(double bgTone, double ratio) {
        double lighterTone = Contrast.lighterUnsafe(bgTone, ratio);
        double darkerTone = Contrast.darkerUnsafe(bgTone, ratio);
        double lighterRatio = Contrast.ratioOfTones(lighterTone, bgTone);
        double darkerRatio = Contrast.ratioOfTones(darkerTone, bgTone);
        boolean preferLighter = DynamicColor.tonePrefersLightForeground(bgTone);
        if (preferLighter) {
            boolean negligibleDifference;
            boolean bl = negligibleDifference = Math.abs(lighterRatio - darkerRatio) < 0.1 && lighterRatio < ratio && darkerRatio < ratio;
            if (lighterRatio >= ratio || lighterRatio >= darkerRatio || negligibleDifference) {
                return lighterTone;
            }
            return darkerTone;
        }
        return darkerRatio >= ratio || darkerRatio >= lighterRatio ? darkerTone : lighterTone;
    }

    public static double enableLightForeground(double tone) {
        if (DynamicColor.tonePrefersLightForeground(tone) && !DynamicColor.toneAllowsLightForeground(tone)) {
            return 49.0;
        }
        return tone;
    }

    public static boolean tonePrefersLightForeground(double tone) {
        return Math.round(tone) <= 60L;
    }

    public static boolean toneAllowsLightForeground(double tone) {
        return Math.round(tone) <= 49L;
    }
}

