/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.material.R;
import com.google.android.material.color.utilities.DynamicColor;
import com.google.android.material.color.utilities.DynamicScheme;
import com.google.android.material.color.utilities.MaterialDynamicColors;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialColorUtilitiesHelper {
    private static final Map<Integer, DynamicColor> colorResourceIdToColorValue;

    private MaterialColorUtilitiesHelper() {
    }

    @NonNull
    public static Map<Integer, Integer> createColorResourcesIdsToColorValues(@NonNull DynamicScheme colorScheme) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, DynamicColor> entry : colorResourceIdToColorValue.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getArgb(colorScheme));
        }
        return Collections.unmodifiableMap(map);
    }

    static {
        HashMap<Integer, DynamicColor> map = new HashMap<Integer, DynamicColor>();
        map.put(R.color.material_personalized_color_primary, MaterialDynamicColors.primary);
        map.put(R.color.material_personalized_color_on_primary, MaterialDynamicColors.onPrimary);
        map.put(R.color.material_personalized_color_primary_inverse, MaterialDynamicColors.primaryInverse);
        map.put(R.color.material_personalized_color_primary_container, MaterialDynamicColors.primaryContainer);
        map.put(R.color.material_personalized_color_on_primary_container, MaterialDynamicColors.onPrimaryContainer);
        map.put(R.color.material_personalized_color_secondary, MaterialDynamicColors.secondary);
        map.put(R.color.material_personalized_color_on_secondary, MaterialDynamicColors.onSecondary);
        map.put(R.color.material_personalized_color_secondary_container, MaterialDynamicColors.secondaryContainer);
        map.put(R.color.material_personalized_color_on_secondary_container, MaterialDynamicColors.onSecondaryContainer);
        map.put(R.color.material_personalized_color_tertiary, MaterialDynamicColors.tertiary);
        map.put(R.color.material_personalized_color_on_tertiary, MaterialDynamicColors.onTertiary);
        map.put(R.color.material_personalized_color_tertiary_container, MaterialDynamicColors.tertiaryContainer);
        map.put(R.color.material_personalized_color_on_tertiary_container, MaterialDynamicColors.onTertiaryContainer);
        map.put(R.color.material_personalized_color_background, MaterialDynamicColors.background);
        map.put(R.color.material_personalized_color_on_background, MaterialDynamicColors.onBackground);
        map.put(R.color.material_personalized_color_surface, MaterialDynamicColors.surface);
        map.put(R.color.material_personalized_color_on_surface, MaterialDynamicColors.onSurface);
        map.put(R.color.material_personalized_color_surface_variant, MaterialDynamicColors.surfaceVariant);
        map.put(R.color.material_personalized_color_on_surface_variant, MaterialDynamicColors.onSurfaceVariant);
        map.put(R.color.material_personalized_color_surface_inverse, MaterialDynamicColors.surfaceInverse);
        map.put(R.color.material_personalized_color_on_surface_inverse, MaterialDynamicColors.onSurfaceInverse);
        map.put(R.color.material_personalized_color_surface_bright, MaterialDynamicColors.surfaceBright);
        map.put(R.color.material_personalized_color_surface_dim, MaterialDynamicColors.surfaceDim);
        map.put(R.color.material_personalized_color_surface_container, MaterialDynamicColors.surfaceContainer);
        map.put(R.color.material_personalized_color_surface_container_low, MaterialDynamicColors.surfaceSub1);
        map.put(R.color.material_personalized_color_surface_container_high, MaterialDynamicColors.surfaceAdd1);
        map.put(R.color.material_personalized_color_surface_container_lowest, MaterialDynamicColors.surfaceSub2);
        map.put(R.color.material_personalized_color_surface_container_highest, MaterialDynamicColors.surfaceAdd2);
        map.put(R.color.material_personalized_color_outline, MaterialDynamicColors.outline);
        map.put(R.color.material_personalized_color_outline_variant, MaterialDynamicColors.outlineVariant);
        map.put(R.color.material_personalized_color_error, MaterialDynamicColors.error);
        map.put(R.color.material_personalized_color_on_error, MaterialDynamicColors.onError);
        map.put(R.color.material_personalized_color_error_container, MaterialDynamicColors.errorContainer);
        map.put(R.color.material_personalized_color_on_error_container, MaterialDynamicColors.onErrorContainer);
        map.put(R.color.material_personalized_color_control_activated, MaterialDynamicColors.controlActivated);
        map.put(R.color.material_personalized_color_control_normal, MaterialDynamicColors.controlNormal);
        map.put(R.color.material_personalized_color_control_highlight, MaterialDynamicColors.controlHighlight);
        map.put(R.color.material_personalized_color_text_primary_inverse, MaterialDynamicColors.textPrimaryInverse);
        map.put(R.color.material_personalized_color_text_secondary_and_tertiary_inverse, MaterialDynamicColors.textSecondaryAndTertiaryInverse);
        map.put(R.color.material_personalized_color_text_secondary_and_tertiary_inverse_disabled, MaterialDynamicColors.textSecondaryAndTertiaryInverseDisabled);
        map.put(R.color.material_personalized_color_text_primary_inverse_disable_only, MaterialDynamicColors.textPrimaryInverseDisableOnly);
        map.put(R.color.material_personalized_color_text_hint_foreground_inverse, MaterialDynamicColors.textHintInverse);
        colorResourceIdToColorValue = Collections.unmodifiableMap(map);
    }
}

