/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.chip;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.annotation.AnimatorRes;
import androidx.annotation.BoolRes;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.chip.ChipDrawable;
import com.google.android.material.chip.ChipGroup;
import com.google.android.material.internal.MaterialCheckable;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.resources.TextAppearanceFontCallback;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.List;

public class Chip
extends AppCompatCheckBox
implements ChipDrawable.Delegate,
Shapeable,
MaterialCheckable<Chip> {
    private static final String TAG = "Chip";
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Chip_Action;
    private static final int CHIP_BODY_VIRTUAL_ID = 0;
    private static final int CLOSE_ICON_VIRTUAL_ID = 1;
    private static final Rect EMPTY_BOUNDS = new Rect();
    private static final int[] SELECTED_STATE = new int[]{0x10100A1};
    private static final int[] CHECKABLE_STATE_SET = new int[]{16842911};
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final int MIN_TOUCH_TARGET_DP = 48;
    @Nullable
    private ChipDrawable chipDrawable;
    @Nullable
    private InsetDrawable insetBackgroundDrawable;
    @Nullable
    private RippleDrawable ripple;
    @Nullable
    private View.OnClickListener onCloseIconClickListener;
    @Nullable
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
    @Nullable
    private MaterialCheckable.OnCheckedChangeListener<Chip> onCheckedChangeListenerInternal;
    private boolean deferredCheckedValue;
    private boolean closeIconPressed;
    private boolean closeIconHovered;
    private boolean closeIconFocused;
    private boolean ensureMinTouchTargetSize;
    private int lastLayoutDirection;
    @Dimension(unit=1)
    private int minTouchTargetSize;
    @Nullable
    private CharSequence accessibilityClassName;
    private static final String BUTTON_ACCESSIBILITY_CLASS_NAME = "android.widget.Button";
    private static final String RADIO_BUTTON_ACCESSIBILITY_CLASS_NAME = "android.widget.RadioButton";
    private static final String GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME = "android.view.View";
    @NonNull
    private final ChipTouchHelper touchHelper;
    private boolean touchHelperEnabled;
    private final Rect rect = new Rect();
    private final RectF rectF = new RectF();
    private final TextAppearanceFontCallback fontCallback = new TextAppearanceFontCallback(){

        @Override
        public void onFontRetrieved(@NonNull Typeface typeface, boolean fontResolvedSynchronously) {
            Chip.this.setText(Chip.this.chipDrawable.shouldDrawText() ? Chip.this.chipDrawable.getText() : Chip.this.getText());
            Chip.this.requestLayout();
            Chip.this.invalidate();
        }

        @Override
        public void onFontRetrievalFailed(int reason) {
        }
    };

    public Chip(Context context) {
        this(context, null);
    }

    public Chip(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.chipStyle);
    }

    public Chip(Context context, AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.validateAttributes(attrs);
        ChipDrawable drawable2 = ChipDrawable.createFromAttributes(context, attrs, defStyleAttr, DEF_STYLE_RES);
        this.initMinTouchTarget(context, attrs, defStyleAttr);
        this.setChipDrawable(drawable2);
        drawable2.setElevation(ViewCompat.getElevation((View)this));
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.Chip, defStyleAttr, DEF_STYLE_RES, new int[0]);
        if (Build.VERSION.SDK_INT < 23) {
            this.setTextColor(MaterialResources.getColorStateList(context, a, R.styleable.Chip_android_textColor));
        }
        boolean hasShapeAppearanceAttribute = a.hasValue(R.styleable.Chip_shapeAppearance);
        a.recycle();
        this.touchHelper = new ChipTouchHelper(this);
        this.updateAccessibilityDelegate();
        if (!hasShapeAppearanceAttribute) {
            this.initOutlineProvider();
        }
        this.setChecked(this.deferredCheckedValue);
        this.setText(drawable2.getText());
        this.setEllipsize(drawable2.getEllipsize());
        this.updateTextPaintDrawState();
        if (!this.chipDrawable.shouldDrawText()) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
        }
        this.setGravity(8388627);
        this.updatePaddingInternal();
        if (this.shouldEnsureMinTouchTargetSize()) {
            this.setMinHeight(this.minTouchTargetSize);
        }
        this.lastLayoutDirection = ViewCompat.getLayoutDirection((View)this);
        super.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (this.onCheckedChangeListenerInternal != null) {
                this.onCheckedChangeListenerInternal.onCheckedChanged(this, isChecked);
            }
            if (this.onCheckedChangeListener != null) {
                this.onCheckedChangeListener.onCheckedChanged(buttonView, isChecked);
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.chipDrawable);
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        if (this.chipDrawable != null) {
            this.chipDrawable.setElevation(elevation);
        }
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(this.getAccessibilityClassName());
        info.setCheckable(this.isCheckable());
        info.setClickable(this.isClickable());
        if (this.getParent() instanceof ChipGroup) {
            ChipGroup chipGroup = (ChipGroup)this.getParent();
            AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
            int columnIndex = chipGroup.isSingleLine() ? chipGroup.getIndexOfChip((View)this) : -1;
            infoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)chipGroup.getRowIndex((View)this), (int)1, (int)columnIndex, (int)1, (boolean)false, (boolean)this.isChecked()));
        }
    }

    private void updateAccessibilityDelegate() {
        if (this.hasCloseIcon() && this.isCloseIconVisible() && this.onCloseIconClickListener != null) {
            ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.touchHelper);
            this.touchHelperEnabled = true;
        } else {
            ViewCompat.setAccessibilityDelegate((View)this, null);
            this.touchHelperEnabled = false;
        }
    }

    private void initMinTouchTarget(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.Chip, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.ensureMinTouchTargetSize = a.getBoolean(R.styleable.Chip_ensureMinTouchTargetSize, false);
        float defaultMinTouchTargetSize = (float)Math.ceil(ViewUtils.dpToPx(this.getContext(), 48));
        this.minTouchTargetSize = (int)Math.ceil(a.getDimension(R.styleable.Chip_chipMinTouchTargetSize, defaultMinTouchTargetSize));
        a.recycle();
    }

    private void updatePaddingInternal() {
        if (TextUtils.isEmpty((CharSequence)this.getText()) || this.chipDrawable == null) {
            return;
        }
        int paddingEnd = (int)(this.chipDrawable.getChipEndPadding() + this.chipDrawable.getTextEndPadding() + this.chipDrawable.calculateCloseIconWidth());
        int paddingStart = (int)(this.chipDrawable.getChipStartPadding() + this.chipDrawable.getTextStartPadding() + this.chipDrawable.calculateChipIconWidth());
        if (this.insetBackgroundDrawable != null) {
            Rect padding = new Rect();
            this.insetBackgroundDrawable.getPadding(padding);
            paddingStart += padding.left;
            paddingEnd += padding.right;
        }
        ViewCompat.setPaddingRelative((View)this, (int)paddingStart, (int)this.getPaddingTop(), (int)paddingEnd, (int)this.getPaddingBottom());
    }

    @TargetApi(value=17)
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (this.lastLayoutDirection != layoutDirection) {
            this.lastLayoutDirection = layoutDirection;
            this.updatePaddingInternal();
        }
    }

    private void validateAttributes(@Nullable AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "background") != null) {
            Log.w((String)TAG, (String)"Do not set the background; Chip manages its own background drawable.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableLeft") != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableStart") != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableEnd") != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableRight") != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        if (!attributeSet.getAttributeBooleanValue(NAMESPACE_ANDROID, "singleLine", true) || attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "lines", 1) != 1 || attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "minLines", 1) != 1 || attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "maxLines", 1) != 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        if (attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "gravity", 8388627) != 8388627) {
            Log.w((String)TAG, (String)"Chip text must be vertically center and start aligned");
        }
    }

    private void initOutlineProvider() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new ViewOutlineProvider(){

                @TargetApi(value=21)
                public void getOutline(View view, @NonNull Outline outline) {
                    if (Chip.this.chipDrawable != null) {
                        Chip.this.chipDrawable.getOutline(outline);
                    } else {
                        outline.setAlpha(0.0f);
                    }
                }
            });
        }
    }

    public Drawable getChipDrawable() {
        return this.chipDrawable;
    }

    public void setChipDrawable(@NonNull ChipDrawable drawable2) {
        if (this.chipDrawable != drawable2) {
            this.unapplyChipDrawable(this.chipDrawable);
            this.chipDrawable = drawable2;
            this.chipDrawable.setShouldDrawText(false);
            this.applyChipDrawable(this.chipDrawable);
            this.ensureAccessibleTouchTarget(this.minTouchTargetSize);
        }
    }

    private void updateBackgroundDrawable() {
        if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
            this.updateFrameworkRippleBackground();
        } else {
            this.chipDrawable.setUseCompatRipple(true);
            ViewCompat.setBackground((View)this, (Drawable)this.getBackgroundDrawable());
            this.updatePaddingInternal();
            this.ensureChipDrawableHasCallback();
        }
    }

    private void ensureChipDrawableHasCallback() {
        if (this.getBackgroundDrawable() == this.insetBackgroundDrawable && this.chipDrawable.getCallback() == null) {
            this.chipDrawable.setCallback((Drawable.Callback)this.insetBackgroundDrawable);
        }
    }

    @Nullable
    public Drawable getBackgroundDrawable() {
        if (this.insetBackgroundDrawable == null) {
            return this.chipDrawable;
        }
        return this.insetBackgroundDrawable;
    }

    private void updateFrameworkRippleBackground() {
        this.ripple = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(this.chipDrawable.getRippleColor()), this.getBackgroundDrawable(), null);
        this.chipDrawable.setUseCompatRipple(false);
        ViewCompat.setBackground((View)this, (Drawable)this.ripple);
        this.updatePaddingInternal();
    }

    private void unapplyChipDrawable(@Nullable ChipDrawable chipDrawable) {
        if (chipDrawable != null) {
            chipDrawable.setDelegate(null);
        }
    }

    private void applyChipDrawable(@NonNull ChipDrawable chipDrawable) {
        chipDrawable.setDelegate(this);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] state = super.onCreateDrawableState(extraSpace + 2);
        if (this.isChecked()) {
            Chip.mergeDrawableStates((int[])state, (int[])SELECTED_STATE);
        }
        if (this.isCheckable()) {
            Chip.mergeDrawableStates((int[])state, (int[])CHECKABLE_STATE_SET);
        }
        return state;
    }

    public void setGravity(int gravity) {
        if (gravity != 8388627) {
            Log.w((String)TAG, (String)"Chip text must be vertically center and start aligned");
        } else {
            super.setGravity(gravity);
        }
    }

    public void setBackgroundTintList(@Nullable ColorStateList tint) {
        Log.w((String)TAG, (String)"Do not set the background tint list; Chip manages its own background drawable.");
    }

    public void setBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        Log.w((String)TAG, (String)"Do not set the background tint mode; Chip manages its own background drawable.");
    }

    public void setBackgroundColor(int color2) {
        Log.w((String)TAG, (String)"Do not set the background color; Chip manages its own background drawable.");
    }

    public void setBackgroundResource(int resid) {
        Log.w((String)TAG, (String)"Do not set the background resource; Chip manages its own background drawable.");
    }

    public void setBackground(Drawable background) {
        if (background != this.getBackgroundDrawable() && background != this.ripple) {
            Log.w((String)TAG, (String)"Do not set the background; Chip manages its own background drawable.");
        } else {
            super.setBackground(background);
        }
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background != this.getBackgroundDrawable() && background != this.ripple) {
            Log.w((String)TAG, (String)"Do not set the background drawable; Chip manages its own background drawable.");
        } else {
            super.setBackgroundDrawable(background);
        }
    }

    public void setCompoundDrawables(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        if (left != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (right != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawables(left, top, right, bottom);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        if (left != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (right != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        if (left != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (right != null) {
            throw new UnsupportedOperationException("Please set right drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    @RequiresApi(value=17)
    public void setCompoundDrawablesRelative(@Nullable Drawable start, @Nullable Drawable top, @Nullable Drawable end, @Nullable Drawable bottom) {
        if (start != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (end != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelative(start, top, end, bottom);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        if (start != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (end != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(@Nullable Drawable start, @Nullable Drawable top, @Nullable Drawable end, @Nullable Drawable bottom) {
        if (start != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (end != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
    }

    @Nullable
    public TextUtils.TruncateAt getEllipsize() {
        return this.chipDrawable != null ? this.chipDrawable.getEllipsize() : null;
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (this.chipDrawable == null) {
            return;
        }
        if (where == TextUtils.TruncateAt.MARQUEE) {
            throw new UnsupportedOperationException("Text within a chip are not allowed to scroll.");
        }
        super.setEllipsize(where);
        if (this.chipDrawable != null) {
            this.chipDrawable.setEllipsize(where);
        }
    }

    public void setSingleLine(boolean singleLine) {
        if (!singleLine) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setSingleLine(singleLine);
    }

    public void setLines(int lines) {
        if (lines > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setLines(lines);
    }

    public void setMinLines(int minLines) {
        if (minLines > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMinLines(minLines);
    }

    public void setMaxLines(int maxLines) {
        if (maxLines > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMaxLines(maxLines);
    }

    public void setMaxWidth(@Px int maxWidth) {
        super.setMaxWidth(maxWidth);
        if (this.chipDrawable != null) {
            this.chipDrawable.setMaxWidth(maxWidth);
        }
    }

    @Override
    public void onChipDrawableSizeChange() {
        this.ensureAccessibleTouchTarget(this.minTouchTargetSize);
        this.requestLayout();
        if (Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setChecked(boolean checked) {
        if (this.chipDrawable == null) {
            this.deferredCheckedValue = checked;
        } else if (this.chipDrawable.isCheckable()) {
            super.setChecked(checked);
        }
    }

    public void setOnCheckedChangeListener(@Nullable CompoundButton.OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    public void setOnCloseIconClickListener(View.OnClickListener listener) {
        this.onCloseIconClickListener = listener;
        this.updateAccessibilityDelegate();
    }

    @CallSuper
    public boolean performCloseIconClick() {
        boolean result;
        this.playSoundEffect(0);
        if (this.onCloseIconClickListener != null) {
            this.onCloseIconClickListener.onClick((View)this);
            result = true;
        } else {
            result = false;
        }
        if (this.touchHelperEnabled) {
            this.touchHelper.sendEventForVirtualView(1, 1);
        }
        return result;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean handled = false;
        int action = event.getActionMasked();
        boolean eventInCloseIcon = this.getCloseIconTouchBounds().contains(event.getX(), event.getY());
        switch (action) {
            case 0: {
                if (!eventInCloseIcon) break;
                this.setCloseIconPressed(true);
                handled = true;
                break;
            }
            case 2: {
                if (!this.closeIconPressed) break;
                if (!eventInCloseIcon) {
                    this.setCloseIconPressed(false);
                }
                handled = true;
                break;
            }
            case 1: {
                if (this.closeIconPressed) {
                    this.performCloseIconClick();
                    handled = true;
                }
            }
            case 3: {
                this.setCloseIconPressed(false);
                break;
            }
        }
        return handled || super.onTouchEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        int action = event.getActionMasked();
        switch (action) {
            case 7: {
                this.setCloseIconHovered(this.getCloseIconTouchBounds().contains(event.getX(), event.getY()));
                break;
            }
            case 10: {
                this.setCloseIconHovered(false);
                break;
            }
        }
        return super.onHoverEvent(event);
    }

    protected boolean dispatchHoverEvent(@NonNull MotionEvent event) {
        if (!this.touchHelperEnabled) {
            return super.dispatchHoverEvent(event);
        }
        return this.touchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (!this.touchHelperEnabled) {
            return super.dispatchKeyEvent(event);
        }
        boolean handled = this.touchHelper.dispatchKeyEvent(event);
        if (handled && this.touchHelper.getKeyboardFocusedVirtualViewId() != Integer.MIN_VALUE) {
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this.touchHelperEnabled) {
            this.touchHelper.onFocusChanged(focused, direction, previouslyFocusedRect);
        }
    }

    public void getFocusedRect(@NonNull Rect r) {
        if (this.touchHelperEnabled && (this.touchHelper.getKeyboardFocusedVirtualViewId() == 1 || this.touchHelper.getAccessibilityFocusedVirtualViewId() == 1)) {
            r.set(this.getCloseIconTouchBoundsInt());
        } else {
            super.getFocusedRect(r);
        }
    }

    private void setCloseIconPressed(boolean pressed) {
        if (this.closeIconPressed != pressed) {
            this.closeIconPressed = pressed;
            this.refreshDrawableState();
        }
    }

    private void setCloseIconHovered(boolean hovered) {
        if (this.closeIconHovered != hovered) {
            this.closeIconHovered = hovered;
            this.refreshDrawableState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        boolean changed = false;
        if (this.chipDrawable != null && this.chipDrawable.isCloseIconStateful()) {
            changed = this.chipDrawable.setCloseIconState(this.createCloseIconDrawableState());
        }
        if (changed) {
            this.invalidate();
        }
    }

    @NonNull
    private int[] createCloseIconDrawableState() {
        int count = 0;
        if (this.isEnabled()) {
            ++count;
        }
        if (this.closeIconFocused) {
            ++count;
        }
        if (this.closeIconHovered) {
            ++count;
        }
        if (this.closeIconPressed) {
            ++count;
        }
        if (this.isChecked()) {
            ++count;
        }
        int[] stateSet = new int[count];
        int i = 0;
        if (this.isEnabled()) {
            stateSet[i] = 16842910;
            ++i;
        }
        if (this.closeIconFocused) {
            stateSet[i] = 16842908;
            ++i;
        }
        if (this.closeIconHovered) {
            stateSet[i] = 16843623;
            ++i;
        }
        if (this.closeIconPressed) {
            stateSet[i] = 16842919;
            ++i;
        }
        if (this.isChecked()) {
            stateSet[i] = 0x10100A1;
            ++i;
        }
        return stateSet;
    }

    private boolean hasCloseIcon() {
        return this.chipDrawable != null && this.chipDrawable.getCloseIcon() != null;
    }

    @NonNull
    private RectF getCloseIconTouchBounds() {
        this.rectF.setEmpty();
        if (this.hasCloseIcon() && this.onCloseIconClickListener != null) {
            this.chipDrawable.getCloseIconTouchBounds(this.rectF);
        }
        return this.rectF;
    }

    @NonNull
    private Rect getCloseIconTouchBoundsInt() {
        RectF bounds = this.getCloseIconTouchBounds();
        this.rect.set((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom);
        return this.rect;
    }

    @Nullable
    @TargetApi(value=24)
    public PointerIcon onResolvePointerIcon(@NonNull MotionEvent event, int pointerIndex) {
        if (this.getCloseIconTouchBounds().contains(event.getX(), event.getY()) && this.isEnabled()) {
            return PointerIcon.getSystemIcon((Context)this.getContext(), (int)1002);
        }
        return null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setInternalOnCheckedChangeListener(@Nullable MaterialCheckable.OnCheckedChangeListener<Chip> listener) {
        this.onCheckedChangeListenerInternal = listener;
    }

    @Nullable
    public ColorStateList getChipBackgroundColor() {
        return this.chipDrawable != null ? this.chipDrawable.getChipBackgroundColor() : null;
    }

    public void setChipBackgroundColorResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipBackgroundColorResource(id2);
        }
    }

    public void setChipBackgroundColor(@Nullable ColorStateList chipBackgroundColor) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipBackgroundColor(chipBackgroundColor);
        }
    }

    public float getChipMinHeight() {
        return this.chipDrawable != null ? this.chipDrawable.getChipMinHeight() : 0.0f;
    }

    public void setChipMinHeightResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipMinHeightResource(id2);
        }
    }

    public void setChipMinHeight(float minHeight) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipMinHeight(minHeight);
        }
    }

    public float getChipCornerRadius() {
        return this.chipDrawable != null ? Math.max(0.0f, this.chipDrawable.getChipCornerRadius()) : 0.0f;
    }

    @Deprecated
    public void setChipCornerRadiusResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipCornerRadiusResource(id2);
        }
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.chipDrawable.setShapeAppearanceModel(shapeAppearanceModel);
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.chipDrawable.getShapeAppearanceModel();
    }

    @Deprecated
    public void setChipCornerRadius(float chipCornerRadius) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipCornerRadius(chipCornerRadius);
        }
    }

    @Nullable
    public ColorStateList getChipStrokeColor() {
        return this.chipDrawable != null ? this.chipDrawable.getChipStrokeColor() : null;
    }

    public void setChipStrokeColorResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeColorResource(id2);
        }
    }

    public void setChipStrokeColor(@Nullable ColorStateList chipStrokeColor) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeColor(chipStrokeColor);
        }
    }

    public float getChipStrokeWidth() {
        return this.chipDrawable != null ? this.chipDrawable.getChipStrokeWidth() : 0.0f;
    }

    public void setChipStrokeWidthResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeWidthResource(id2);
        }
    }

    public void setChipStrokeWidth(float chipStrokeWidth) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeWidth(chipStrokeWidth);
        }
    }

    @Nullable
    public ColorStateList getRippleColor() {
        return this.chipDrawable != null ? this.chipDrawable.getRippleColor() : null;
    }

    public void setRippleColorResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setRippleColorResource(id2);
            if (!this.chipDrawable.getUseCompatRipple()) {
                this.updateFrameworkRippleBackground();
            }
        }
    }

    public void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setRippleColor(rippleColor);
        }
        if (!this.chipDrawable.getUseCompatRipple()) {
            this.updateFrameworkRippleBackground();
        }
    }

    @Deprecated
    public CharSequence getChipText() {
        return this.getText();
    }

    public void setLayoutDirection(int layoutDirection) {
        if (this.chipDrawable == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            super.setLayoutDirection(layoutDirection);
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.chipDrawable == null) {
            return;
        }
        if (text == null) {
            text = "";
        }
        super.setText(this.chipDrawable.shouldDrawText() ? null : text, type);
        if (this.chipDrawable != null) {
            this.chipDrawable.setText(text);
        }
    }

    @Deprecated
    public void setChipTextResource(@StringRes int id2) {
        this.setText(this.getResources().getString(id2));
    }

    @Deprecated
    public void setChipText(@Nullable CharSequence chipText) {
        this.setText(chipText);
    }

    public void setTextAppearanceResource(@StyleRes int id2) {
        this.setTextAppearance(this.getContext(), id2);
    }

    public void setTextAppearance(@Nullable TextAppearance textAppearance) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextAppearance(textAppearance);
        }
        this.updateTextPaintDrawState();
    }

    public void setTextAppearance(Context context, int resId) {
        super.setTextAppearance(context, resId);
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextAppearanceResource(resId);
        }
        this.updateTextPaintDrawState();
    }

    public void setTextAppearance(int resId) {
        super.setTextAppearance(resId);
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextAppearanceResource(resId);
        }
        this.updateTextPaintDrawState();
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        }
        this.updateTextPaintDrawState();
    }

    private void updateTextPaintDrawState() {
        TextAppearance textAppearance;
        TextPaint textPaint = this.getPaint();
        if (this.chipDrawable != null) {
            textPaint.drawableState = this.chipDrawable.getState();
        }
        if ((textAppearance = this.getTextAppearance()) != null) {
            textAppearance.updateDrawState(this.getContext(), textPaint, this.fontCallback);
        }
    }

    @Nullable
    private TextAppearance getTextAppearance() {
        return this.chipDrawable != null ? this.chipDrawable.getTextAppearance() : null;
    }

    public boolean isChipIconVisible() {
        return this.chipDrawable != null && this.chipDrawable.isChipIconVisible();
    }

    @Deprecated
    public boolean isChipIconEnabled() {
        return this.isChipIconVisible();
    }

    public void setChipIconVisible(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconVisible(id2);
        }
    }

    public void setChipIconVisible(boolean chipIconVisible) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconVisible(chipIconVisible);
        }
    }

    @Deprecated
    public void setChipIconEnabledResource(@BoolRes int id2) {
        this.setChipIconVisible(id2);
    }

    @Deprecated
    public void setChipIconEnabled(boolean chipIconEnabled) {
        this.setChipIconVisible(chipIconEnabled);
    }

    @Nullable
    public Drawable getChipIcon() {
        return this.chipDrawable != null ? this.chipDrawable.getChipIcon() : null;
    }

    public void setChipIconResource(@DrawableRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconResource(id2);
        }
    }

    public void setChipIcon(@Nullable Drawable chipIcon) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIcon(chipIcon);
        }
    }

    @Nullable
    public ColorStateList getChipIconTint() {
        return this.chipDrawable != null ? this.chipDrawable.getChipIconTint() : null;
    }

    public void setChipIconTintResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconTintResource(id2);
        }
    }

    public void setChipIconTint(@Nullable ColorStateList chipIconTint) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconTint(chipIconTint);
        }
    }

    public float getChipIconSize() {
        return this.chipDrawable != null ? this.chipDrawable.getChipIconSize() : 0.0f;
    }

    public void setChipIconSizeResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconSizeResource(id2);
        }
    }

    public void setChipIconSize(float chipIconSize) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconSize(chipIconSize);
        }
    }

    public boolean isCloseIconVisible() {
        return this.chipDrawable != null && this.chipDrawable.isCloseIconVisible();
    }

    @Deprecated
    public boolean isCloseIconEnabled() {
        return this.isCloseIconVisible();
    }

    public void setCloseIconVisible(@BoolRes int id2) {
        this.setCloseIconVisible(this.getResources().getBoolean(id2));
    }

    public void setCloseIconVisible(boolean closeIconVisible) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconVisible(closeIconVisible);
        }
        this.updateAccessibilityDelegate();
    }

    @Deprecated
    public void setCloseIconEnabledResource(@BoolRes int id2) {
        this.setCloseIconVisible(id2);
    }

    @Deprecated
    public void setCloseIconEnabled(boolean closeIconEnabled) {
        this.setCloseIconVisible(closeIconEnabled);
    }

    @Nullable
    public Drawable getCloseIcon() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIcon() : null;
    }

    public void setCloseIconResource(@DrawableRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconResource(id2);
        }
        this.updateAccessibilityDelegate();
    }

    public void setCloseIcon(@Nullable Drawable closeIcon) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIcon(closeIcon);
        }
        this.updateAccessibilityDelegate();
    }

    @Nullable
    public ColorStateList getCloseIconTint() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconTint() : null;
    }

    public void setCloseIconTintResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconTintResource(id2);
        }
    }

    public void setCloseIconTint(@Nullable ColorStateList closeIconTint) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconTint(closeIconTint);
        }
    }

    public float getCloseIconSize() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconSize() : 0.0f;
    }

    public void setCloseIconSizeResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconSizeResource(id2);
        }
    }

    public void setCloseIconSize(float closeIconSize) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconSize(closeIconSize);
        }
    }

    public void setCloseIconContentDescription(@Nullable CharSequence closeIconContentDescription) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconContentDescription(closeIconContentDescription);
        }
    }

    @Nullable
    public CharSequence getCloseIconContentDescription() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconContentDescription() : null;
    }

    public boolean isCheckable() {
        return this.chipDrawable != null && this.chipDrawable.isCheckable();
    }

    public void setCheckableResource(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckableResource(id2);
        }
    }

    public void setCheckable(boolean checkable) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckable(checkable);
        }
    }

    public boolean isCheckedIconVisible() {
        return this.chipDrawable != null && this.chipDrawable.isCheckedIconVisible();
    }

    @Deprecated
    public boolean isCheckedIconEnabled() {
        return this.isCheckedIconVisible();
    }

    public void setCheckedIconVisible(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconVisible(id2);
        }
    }

    public void setCheckedIconVisible(boolean checkedIconVisible) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconVisible(checkedIconVisible);
        }
    }

    @Deprecated
    public void setCheckedIconEnabledResource(@BoolRes int id2) {
        this.setCheckedIconVisible(id2);
    }

    @Deprecated
    public void setCheckedIconEnabled(boolean checkedIconEnabled) {
        this.setCheckedIconVisible(checkedIconEnabled);
    }

    @Nullable
    public Drawable getCheckedIcon() {
        return this.chipDrawable != null ? this.chipDrawable.getCheckedIcon() : null;
    }

    public void setCheckedIconResource(@DrawableRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconResource(id2);
        }
    }

    public void setCheckedIcon(@Nullable Drawable checkedIcon) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIcon(checkedIcon);
        }
    }

    @Nullable
    public ColorStateList getCheckedIconTint() {
        return this.chipDrawable != null ? this.chipDrawable.getCheckedIconTint() : null;
    }

    public void setCheckedIconTintResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconTintResource(id2);
        }
    }

    public void setCheckedIconTint(@Nullable ColorStateList checkedIconTint) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconTint(checkedIconTint);
        }
    }

    @Nullable
    public MotionSpec getShowMotionSpec() {
        return this.chipDrawable != null ? this.chipDrawable.getShowMotionSpec() : null;
    }

    public void setShowMotionSpecResource(@AnimatorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setShowMotionSpecResource(id2);
        }
    }

    public void setShowMotionSpec(@Nullable MotionSpec showMotionSpec) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setShowMotionSpec(showMotionSpec);
        }
    }

    @Nullable
    public MotionSpec getHideMotionSpec() {
        return this.chipDrawable != null ? this.chipDrawable.getHideMotionSpec() : null;
    }

    public void setHideMotionSpecResource(@AnimatorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setHideMotionSpecResource(id2);
        }
    }

    public void setHideMotionSpec(@Nullable MotionSpec hideMotionSpec) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setHideMotionSpec(hideMotionSpec);
        }
    }

    public float getChipStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getChipStartPadding() : 0.0f;
    }

    public void setChipStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStartPaddingResource(id2);
        }
    }

    public void setChipStartPadding(float chipStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStartPadding(chipStartPadding);
        }
    }

    public float getIconStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getIconStartPadding() : 0.0f;
    }

    public void setIconStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconStartPaddingResource(id2);
        }
    }

    public void setIconStartPadding(float iconStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconStartPadding(iconStartPadding);
        }
    }

    public float getIconEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getIconEndPadding() : 0.0f;
    }

    public void setIconEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconEndPaddingResource(id2);
        }
    }

    public void setIconEndPadding(float iconEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconEndPadding(iconEndPadding);
        }
    }

    public float getTextStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getTextStartPadding() : 0.0f;
    }

    public void setTextStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextStartPaddingResource(id2);
        }
    }

    public void setTextStartPadding(float textStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextStartPadding(textStartPadding);
        }
    }

    public float getTextEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getTextEndPadding() : 0.0f;
    }

    public void setTextEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextEndPaddingResource(id2);
        }
    }

    public void setTextEndPadding(float textEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextEndPadding(textEndPadding);
        }
    }

    public float getCloseIconStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconStartPadding() : 0.0f;
    }

    public void setCloseIconStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconStartPaddingResource(id2);
        }
    }

    public void setCloseIconStartPadding(float closeIconStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconStartPadding(closeIconStartPadding);
        }
    }

    public float getCloseIconEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconEndPadding() : 0.0f;
    }

    public void setCloseIconEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconEndPaddingResource(id2);
        }
    }

    public void setCloseIconEndPadding(float closeIconEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconEndPadding(closeIconEndPadding);
        }
    }

    public float getChipEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getChipEndPadding() : 0.0f;
    }

    public void setChipEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipEndPaddingResource(id2);
        }
    }

    public void setChipEndPadding(float chipEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipEndPadding(chipEndPadding);
        }
    }

    public boolean shouldEnsureMinTouchTargetSize() {
        return this.ensureMinTouchTargetSize;
    }

    public void setEnsureMinTouchTargetSize(boolean flag) {
        this.ensureMinTouchTargetSize = flag;
        this.ensureAccessibleTouchTarget(this.minTouchTargetSize);
    }

    public boolean ensureAccessibleTouchTarget(@Dimension int minTargetPx) {
        int deltaY;
        this.minTouchTargetSize = minTargetPx;
        if (!this.shouldEnsureMinTouchTargetSize()) {
            if (this.insetBackgroundDrawable != null) {
                this.removeBackgroundInset();
            } else {
                this.updateBackgroundDrawable();
            }
            return false;
        }
        int deltaHeight = Math.max(0, minTargetPx - this.chipDrawable.getIntrinsicHeight());
        int deltaWidth = Math.max(0, minTargetPx - this.chipDrawable.getIntrinsicWidth());
        if (deltaWidth <= 0 && deltaHeight <= 0) {
            if (this.insetBackgroundDrawable != null) {
                this.removeBackgroundInset();
            } else {
                this.updateBackgroundDrawable();
            }
            return false;
        }
        int deltaX = deltaWidth > 0 ? deltaWidth / 2 : 0;
        int n = deltaY = deltaHeight > 0 ? deltaHeight / 2 : 0;
        if (this.insetBackgroundDrawable != null) {
            Rect padding = new Rect();
            this.insetBackgroundDrawable.getPadding(padding);
            if (padding.top == deltaY && padding.bottom == deltaY && padding.left == deltaX && padding.right == deltaX) {
                this.updateBackgroundDrawable();
                return true;
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (this.getMinHeight() != minTargetPx) {
                this.setMinHeight(minTargetPx);
            }
            if (this.getMinWidth() != minTargetPx) {
                this.setMinWidth(minTargetPx);
            }
        } else {
            this.setMinHeight(minTargetPx);
            this.setMinWidth(minTargetPx);
        }
        this.insetChipBackgroundDrawable(deltaX, deltaY, deltaX, deltaY);
        this.updateBackgroundDrawable();
        return true;
    }

    public void setAccessibilityClassName(@Nullable CharSequence className) {
        this.accessibilityClassName = className;
    }

    @NonNull
    public CharSequence getAccessibilityClassName() {
        if (!TextUtils.isEmpty((CharSequence)this.accessibilityClassName)) {
            return this.accessibilityClassName;
        }
        if (this.isCheckable()) {
            ViewParent parent = this.getParent();
            if (parent instanceof ChipGroup && ((ChipGroup)parent).isSingleSelection()) {
                return RADIO_BUTTON_ACCESSIBILITY_CLASS_NAME;
            }
            return BUTTON_ACCESSIBILITY_CLASS_NAME;
        }
        if (this.isClickable()) {
            return BUTTON_ACCESSIBILITY_CLASS_NAME;
        }
        return GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME;
    }

    private void removeBackgroundInset() {
        if (this.insetBackgroundDrawable != null) {
            this.insetBackgroundDrawable = null;
            this.setMinWidth(0);
            this.setMinHeight((int)this.getChipMinHeight());
            this.updateBackgroundDrawable();
        }
    }

    private void insetChipBackgroundDrawable(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this.insetBackgroundDrawable = new InsetDrawable((Drawable)this.chipDrawable, insetLeft, insetTop, insetRight, insetBottom);
    }

    private class ChipTouchHelper
    extends ExploreByTouchHelper {
        ChipTouchHelper(Chip view) {
            super((View)view);
        }

        protected int getVirtualViewAt(float x, float y) {
            return Chip.this.hasCloseIcon() && Chip.this.getCloseIconTouchBounds().contains(x, y) ? 1 : 0;
        }

        protected void getVisibleVirtualViews(@NonNull List<Integer> virtualViewIds) {
            virtualViewIds.add(0);
            if (Chip.this.hasCloseIcon() && Chip.this.isCloseIconVisible() && Chip.this.onCloseIconClickListener != null) {
                virtualViewIds.add(1);
            }
        }

        protected void onVirtualViewKeyboardFocusChanged(int virtualViewId, boolean hasFocus) {
            if (virtualViewId == 1) {
                Chip.this.closeIconFocused = hasFocus;
                Chip.this.refreshDrawableState();
            }
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, @NonNull AccessibilityNodeInfoCompat node) {
            if (virtualViewId == 1) {
                CharSequence closeIconContentDescription = Chip.this.getCloseIconContentDescription();
                if (closeIconContentDescription != null) {
                    node.setContentDescription(closeIconContentDescription);
                } else {
                    CharSequence chipText = Chip.this.getText();
                    node.setContentDescription((CharSequence)Chip.this.getContext().getString(R.string.mtrl_chip_close_icon_content_description, new Object[]{!TextUtils.isEmpty((CharSequence)chipText) ? chipText : ""}).trim());
                }
                node.setBoundsInParent(Chip.this.getCloseIconTouchBoundsInt());
                node.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
                node.setEnabled(Chip.this.isEnabled());
            } else {
                node.setContentDescription((CharSequence)"");
                node.setBoundsInParent(EMPTY_BOUNDS);
            }
        }

        protected void onPopulateNodeForHost(@NonNull AccessibilityNodeInfoCompat node) {
            node.setCheckable(Chip.this.isCheckable());
            node.setClickable(Chip.this.isClickable());
            node.setClassName(Chip.this.getAccessibilityClassName());
            CharSequence chipText = Chip.this.getText();
            if (Build.VERSION.SDK_INT >= 23) {
                node.setText(chipText);
            } else {
                node.setContentDescription(chipText);
            }
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            if (action == 16) {
                if (virtualViewId == 0) {
                    return Chip.this.performClick();
                }
                if (virtualViewId == 1) {
                    return Chip.this.performCloseIconClick();
                }
            }
            return false;
        }
    }
}

